/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.market.api;

import com.ejianc.business.market.hystrix.ProjectHystrix;
import com.ejianc.business.market.vo.ProjectRegisterVO;
import com.ejianc.framework.core.response.CommonResponse;
import java.math.BigDecimal;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

@FeignClient(name="ejc-market-web", url="${common.env.feign-client-url}", path="ejc-market-web", fallback=ProjectHystrix.class)
public interface IProjectApi {
    @GetMapping(value={"/api/project/queryProjectBySourceId"})
    public CommonResponse<ProjectRegisterVO> queryProjectBySourceId(@RequestParam(value="sourceId") String var1);

    @GetMapping(value={"/api/project/queryProjectByProjectDepartmentId"})
    public CommonResponse<ProjectRegisterVO> queryProjectByProjectDepartmentId(@RequestParam(value="projectDepartmentId") String var1);

    @GetMapping(value={"/api/project/queryProjectByIds"})
    public CommonResponse<List<ProjectRegisterVO>> queryProjectByIds(@RequestParam(value="ids") List<Long> var1);

    @GetMapping(value={"/api/project/getDataByName"})
    public CommonResponse<ProjectRegisterVO> getDataByName(@RequestParam(value="projectName") String var1);

    @GetMapping(value={"/api/project/getProjectIdsByProperties"})
    public CommonResponse<List<Long>> getProjectIdsByProperties(@RequestParam(value="projectRange") int var1);

    @GetMapping(value={"/api/project/getProjectIdsByEngineeringType"})
    public CommonResponse<List<Long>> getProjectIdsByEngineeringType(@RequestParam(value="projectRange") int var1, @RequestParam(value="engineeringType", required=false) Long var2);

    @GetMapping(value={"/api/project/saveContractMny"})
    public CommonResponse<ProjectRegisterVO> saveContractMny(@RequestParam(value="id") Long var1, @RequestParam(value="contractTaxMny") BigDecimal var2, @RequestParam(value="contractMny") BigDecimal var3, @RequestParam(value="contractId") Long var4);

    @PostMapping(value={"/api/project/updProject"})
    public CommonResponse<String> updProject(@RequestBody ProjectRegisterVO var1);

    @GetMapping(value={"/api/project/queryProjectByPid"})
    public CommonResponse<List<ProjectRegisterVO>> queryProjectByPid(@RequestParam(value="pid") Long var1);

    @PostMapping(value={"/api/project/syncProject"})
    public CommonResponse<ProjectRegisterVO> syncProject(@RequestBody ProjectRegisterVO var1);

    @PostMapping(value={"updateProjectByBidCost"})
    public CommonResponse<String> updateProjectByBidCost(@RequestBody ProjectRegisterVO var1);
}

