package com.ejianc.business.market.hystrix;

import java.util.List;
import java.util.Map;

import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.market.vo.ProjectSubVO;
import com.ejianc.framework.core.response.QueryParam;
import org.springframework.stereotype.Component;

import com.ejianc.business.market.api.IProjectApi;
import com.ejianc.business.market.vo.ProjectRegisterVO;
import com.ejianc.framework.core.response.CommonResponse;

/**
 * 项目hystrix
 *
 * @author liyongjia
 *
 */
@Component
public class ProjectHystrix implements IProjectApi {

	@Override
	public CommonResponse<ProjectRegisterVO> queryProjectBySourceId(String sourceId) {
		return CommonResponse.error("网络问题， 查询失败。");
	}

	/**
	 * @param projectDepartmentId
	 * @Author mrsir_wxp
	 * @Date 2020/8/21 根据项目部id查询项目信息
	 * @Description queryProjectByProjectDepartmentId
	 * @Param [sourceId]
	 * @Return com.ejianc.framework.core.response.CommonResponse<com.ejianc.business.market.vo.ProjectRegisterVO>
	 */
	@Override
	public CommonResponse<ProjectRegisterVO> queryProjectByProjectDepartmentId(String projectDepartmentId) {
		return CommonResponse.error("网络问题， 查询失败。");
	}

	@Override
	public CommonResponse<List<ProjectRegisterVO>> queryProjectByIds(List<Long> ids) {
		return CommonResponse.error("网络问题， 查询失败。");
	}

	@Override
	public CommonResponse<JSONArray> queryProjectArray(List<Long> ids) {
		return CommonResponse.error("网络问题， 查询失败。");
	}

	@Override
	public CommonResponse<List<Long>> getProjectIdsByProperties(int projectRange) {
		return CommonResponse.error("网络问题， 查询失败。");
	}

	@Override
	public CommonResponse<List<ProjectRegisterVO>> queryProjectByUserId(Long userId) {
		return CommonResponse.error("网络问题， 查询失败。");
	}

	/***
	 * @Author mrsir_wxp
	 * @Date 2021/2/1 查询本下启用的项目，参数为需要查询的条数，默认十条
	 * @Description queryProjectList
	 * @Param [num]
	 * @Return com.ejianc.framework.core.response.CommonResponse<java.util.List<com.ejianc.business.market.vo.ProjectRegisterVO>>
	 */
	@Override
	public CommonResponse<List<ProjectRegisterVO>> queryProjectList(int num) {
		return CommonResponse.error("网络问题， 查询失败。");
	}

	/**
	 * @param queryParam
	 * @Author mrsir_wxp
	 * @Date 2021/5/18
	 * @Description queryProjectPage
	 * @Param [queryParam]
	 * @Return com.ejianc.framework.core.response.CommonResponse<com.baomidou.mybatisplus.core.metadata.IPage < com.ejianc.business.market.vo.ProjectRegisterVO>>
	 */
	@Override
	public CommonResponse<Page<ProjectRegisterVO>> queryProjectPage(QueryParam queryParam) {
		return CommonResponse.error("网络问题， 查询失败。");
	}

	@Override
	public CommonResponse<List<ProjectRegisterVO>> queryChildrenProjectByOrgId(Long orgId) {
		return CommonResponse.error("网络问题， 查询失败。");
	}

	@Override
	public CommonResponse<List<Map>> queryProjects(Long orgId, List<String> statusList, List<String> focusTypeList,List<Long> engineeringTypeList,String searchText) {
		return CommonResponse.error("网络问题， 查询失败。");
	}

	@Override
	public CommonResponse<ProjectRegisterVO> queryProjectDetail(Long projectId) {
		return CommonResponse.error("网络问题， 查询失败。");
	}

	@Override
	public CommonResponse<Map<Long, List<ProjectSubVO>>> queryProjectSub(List<Long> projectIds) {
		return CommonResponse.error("网络问题， 查询失败。");
	}


}
