package com.ejianc.business.market.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.apache.commons.lang3.StringUtils;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * 工程登记
 */
public class ProjectRegisterVO extends BaseVO {
    private static final long serialVersionUID = 6397319563174429996L;
    private final SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    /**
     * 商机Id
     */
    private Long busOpprId;

    /**
     * 项目编号
     */
    private String code;
    /**
     * 项目名称
     */
    private String name;

    /**
     * 所属组织
     */
    private Long orgId;

    /**
     * 所属项目部Id
     */
    private Long projectDepartmentId;

    /**
     * 项目状态：1-未开工, 2-在建，3-完成
     */
    private String status;

    /**
     * 项目状态：0-启用，1-停用
     */
    private String validStatus;

    /**
     * 项目类型：1-自营，2-联营
     */
    private String type;

    /**
     * 承包模式
     *
     */
    private Long contractualModel;

    /**
     * 发包单位
     */
    private Long pubUnit;

    /**
     * 承包单位
     */
    private Long contractorUnit;

    /**
     * 项目地区
     */
    private String area;
    /**
     * 详细地址
     */
    private String address;
    /**
     * 投资主体
     */
    private Long investor;

    /**
     * 资金来源
     */
    private String fundsSource;
    /**
     * 总造价(万元)
     */
    private BigDecimal costTotal;
    /**
     * 招标形式
     */
    private Long biddingForm;
    /**
     * 计划开工日期
     */
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date plannedCommencementDate;
    /**
     * 计划竣工日期
     */
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date plannedFinishDate;
    /**
     * 建筑面积(㎡)
     */
    private BigDecimal builtArea;

    /**
     * 结构类型
     */
    private Long structureType;
    /**
     * 工程用途
     */
    private Long engineeringPurpose;
    /**
     * 工程概况
     */
    private String projectOverview;

    /**
     * 项目成员
     */
    private List<Map<String, Object>> membersList;

    /**
     * 冗余所属组织名称
     */
    private String orgName;
    /**
     * 冗余承包单位名称
     */
    private String contractorUnitName;
    /**
     * 冗余发包单位名称
     */
    private String pubUnitName;

    /**
     * 承包模式
     */
    private String contractualModelName;

    /**
     * 投资主体
     */
    private String investorName;

    /**
     * 招标形式
     */
    private String biddingFormName;

    /**
     * 结构类型
     */
    private String structureTypeName;
    /**
     * 工程用途
     */
    private String engineeringPurposeName;

    /**
     * 创建人名称
     */
    private String createUserName;

    private String createTimeStr;
    private String statusName;
    private String typeName;
    private String validStatusName;

    //数据同步字段
    /**
     * 数据在第三方系统中主键值
     */
    private String sourceId;

    private String sourceOrgId;

    /**
     * 数据来源系统Id
     */
    private Long systemId;

    /**
     * 数据来源系统编码
     */
    private String systemCode;

    /**
     * 签订日期
     */
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date signDate;

    /**
     * 项目经理
     */
    private Long projectManager;

    /**
     * 项目经理名称
     */
    private String projectManagerName;

    /**
     * 工程类型
     */
    private Long engineeringType;

    /**
     * 工程类型名称
     */
    private String engineeringTypeName;

    /**
     * 省份
     */
    private String province;

    /**
     * 市区
     */
    private String city;

    /**
     * 区县
     */
    private String region;

    /**
     * 是否使用材料核销
     */
    private Boolean materialVerification;

    /**
     * 关注类型 0-普通项目 1-工程局重点关注 2-工程局重点监控 3-二级单位重点关注 4-二级单位重点监控
     */
    private String focusType;
    /**
     * 纬度
     */
    private String lat;
    /**
     * 经度
     */
    private String lng;

    /**
     * 是否开启现场检查
     */
    private Boolean checkOpen;

    /**
     * 新项目标识 1-是
     */
    private String newState;

    /**
     * 项目简称
     */
    private String shortName;


    private List<ProjectSubVO> projectSubList = new ArrayList<>(); // 局内分包项目

    public List<ProjectSubVO> getProjectSubList() {
        return projectSubList;
    }

    public void setProjectSubList(List<ProjectSubVO> projectSubList) {
        this.projectSubList = projectSubList;
    }

    public String getLat() {
        return lat;
    }

    public void setLat(String lat) {
        this.lat = lat;
    }

    public String getLng() {
        return lng;
    }

    public void setLng(String lng) {
        this.lng = lng;
    }

    public String getFocusType() {
        return focusType;
    }

    public void setFocusType(String focusType) {
        this.focusType = focusType;
    }


    public Boolean getMaterialVerification() {
        return materialVerification;
    }

    public void setMaterialVerification(Boolean materialVerification) {
        this.materialVerification = materialVerification;
    }

    public String getProjectManagerName() {
        return projectManagerName;
    }

    public void setProjectManagerName(String projectManagerName) {
        this.projectManagerName = projectManagerName;
    }

    public Long getProjectManager() {
        return projectManager;
    }

    @ReferDeserialTransfer
    public void setProjectManager(Long projectManager) {
        this.projectManager = projectManager;
    }

    public Long getEngineeringType() {
        return engineeringType;
    }

    public void setEngineeringType(Long engineeringType) {
        this.engineeringType = engineeringType;
    }

    public String getEngineeringTypeName() {
        return engineeringTypeName;
    }

    public void setEngineeringTypeName(String engineeringTypeName) {
        this.engineeringTypeName = engineeringTypeName;
    }

    public String getSystemCode() {
        return systemCode;
    }

    public void setSystemCode(String systemCode) {
        this.systemCode = systemCode;
    }

    public String getSourceId() {
        return sourceId;
    }

    public void setSourceId(String sourceId) {
        this.sourceId = sourceId;
    }

    public Long getSystemId() {
        return systemId;
    }

    public void setSystemId(Long systemId) {
        this.systemId = systemId;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @ReferSerialTransfer(referCode="idm-org")
    public Long getOrgId() {
        return orgId;
    }

    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public Long getContractualModel() {
        return contractualModel;
    }

    public void setContractualModel(Long contractualModel) {
        this.contractualModel = contractualModel;
    }

    @ReferDeserialTransfer
    public Long getPubUnit() {
        return pubUnit;
    }

    public void setPubUnit(Long pubUnit) {
        this.pubUnit = pubUnit;
    }

    @ReferSerialTransfer(referCode="support-supplier")
    public Long getContractorUnit() {
        return contractorUnit;
    }

    @ReferDeserialTransfer
    public void setContractorUnit(Long contractorUnit) {
        this.contractorUnit = contractorUnit;
    }

    public String getArea() {
        return area;
    }

    public void setArea(String area) {
        this.area = area;
    }

    public String getAddress() {
        return address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public Long getInvestor() {
        return investor;
    }

    public void setInvestor(Long investor) {
        this.investor = investor;
    }

    public String getFundsSource() {
        return fundsSource;
    }

    public void setFundsSource(String fundsSource) {
        this.fundsSource = fundsSource;
    }

    public BigDecimal getCostTotal() {
        return costTotal;
    }

    public void setCostTotal(BigDecimal costTotal) {
        this.costTotal = costTotal;
    }

    public Long getBiddingForm() {
        return biddingForm;
    }

    public void setBiddingForm(Long biddingForm) {
        this.biddingForm = biddingForm;
    }

    public Date getPlannedCommencementDate() {
        return plannedCommencementDate;
    }

    public void setPlannedCommencementDate(Date plannedCommencementDate) {
        this.plannedCommencementDate = plannedCommencementDate;
    }

    public Date getPlannedFinishDate() {
        return plannedFinishDate;
    }

    public void setPlannedFinishDate(Date plannedFinishDate) {
        this.plannedFinishDate = plannedFinishDate;
    }

    public BigDecimal getBuiltArea() {
        return builtArea;
    }

    public void setBuiltArea(BigDecimal builtArea) {
        this.builtArea = builtArea;
    }

    public Long getStructureType() {
        return structureType;
    }

    public void setStructureType(Long structureType) {
        this.structureType = structureType;
    }

    public Long getEngineeringPurpose() {
        return engineeringPurpose;
    }

    public void setEngineeringPurpose(Long engineeringPurpose) {
        this.engineeringPurpose = engineeringPurpose;
    }

    public String getProjectOverview() {
        return projectOverview;
    }

    public void setProjectOverview(String projectOverview) {
        this.projectOverview = projectOverview;
    }

    public List<Map<String, Object>> getMembersList() {
        return membersList;
    }

    public void setMembersList(List<Map<String, Object>> membersList) {
        this.membersList = membersList;
    }

    public String getValidStatus() {
        return validStatus;
    }

    public void setValidStatus(String validStatus) {
        this.validStatus = validStatus;
    }

    @ReferSerialTransfer(referCode="idm-org")
    public Long getProjectDepartmentId() {
        return projectDepartmentId;
    }

    @ReferDeserialTransfer
    public void setProjectDepartmentId(Long projectDepartmentId) {
        this.projectDepartmentId = projectDepartmentId;
    }

    public Long getBusOpprId() {
        return busOpprId;
    }

    public void setBusOpprId(Long busOpprId) {
        this.busOpprId = busOpprId;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public String getContractorUnitName() {
        return contractorUnitName;
    }

    public void setContractorUnitName(String contractorUnitName) {
        this.contractorUnitName = contractorUnitName;
    }

    public String getPubUnitName() {
        return pubUnitName;
    }

    public void setPubUnitName(String pubUnitName) {
        this.pubUnitName = pubUnitName;
    }

    public String getContractualModelName() {
        return contractualModelName;
    }

    public void setContractualModelName(String contractualModelName) {
        this.contractualModelName = contractualModelName;
    }

    public String getInvestorName() {
        return investorName;
    }

    public void setInvestorName(String investorName) {
        this.investorName = investorName;
    }

    public String getBiddingFormName() {
        return biddingFormName;
    }

    public void setBiddingFormName(String biddingFormName) {
        this.biddingFormName = biddingFormName;
    }

    public String getStructureTypeName() {
        return structureTypeName;
    }

    public void setStructureTypeName(String structureTypeName) {
        this.structureTypeName = structureTypeName;
    }

    public String getEngineeringPurposeName() {
        return engineeringPurposeName;
    }

    public void setEngineeringPurposeName(String engineeringPurposeName) {
        this.engineeringPurposeName = engineeringPurposeName;
    }

    public String getCreateUserName() {
        return createUserName;
    }

    public void setCreateUserName(String createUserName) {
        this.createUserName = createUserName;
    }

    public String getCreateTimeStr() {
        return null != this.getCreateTime() ? sdf.format(this.getCreateTime()) : null;
    }

    public String getStatusName() {
        return StringUtils.isNotBlank(this.status) ? ("1".equals(this.status) ? "未开工" : "2".equals(this.status) ? "在建" : "完工") : null;
    }

    public String getTypeName() {
        return "1".equals(this.type) ? "自营" : "联营";
    }

    public String getValidStatusName() {
        return "0".equals(this.validStatus) ? "启用" : "停用";
    }

    public Date getSignDate() {
        return signDate;
    }

    public void setSignDate(Date signDate) {
        this.signDate = signDate;
    }

    public String getSourceOrgId() {
        return sourceOrgId;
    }

    public void setSourceOrgId(String sourceOrgId) {
        this.sourceOrgId = sourceOrgId;
    }

    public String getProvince() {
        return province;
    }

    public void setProvince(String province) {
        this.province = province;
    }

    public String getCity() {
        return city;
    }

    public void setCity(String city) {
        this.city = city;
    }

    public String getRegion() {
        return region;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public Boolean getCheckOpen() {
        return checkOpen;
    }

    public void setCheckOpen(Boolean checkOpen) {
        this.checkOpen = checkOpen;
    }

    public String getNewState() {
        return newState;
    }

    public void setNewState(String newState) {
        this.newState = newState;
    }

    public String getShortName() {
        return shortName;
    }

    public void setShortName(String shortName) {
        this.shortName = shortName;
    }
}
