package com.ejianc.business.market.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 项目管理备案登记表
 * 
 * @author generator
 * 
 */
 @TableName("ejc_market_preparation_manage")
public class PreparationManageEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="preparation_plan_id")
    private Long preparationPlanId; // 预备案
    @TableField(value="preparation_plan_code")
    private String preparationPlanCode; // 项目编号（转自预备编号）
    @TableField(value="type")
    private String type; // 项目类型：1-自营，2-联营
    @TableField(value="org_id")
    private Long orgId; // 所属组织
    @TableField(value="org_name")
    private String orgName; // 所属组织名称
    @TableField(value="code")
    private String code; // 单据编码
    @TableField(value="name")
    private String name; // 项目名称
    @TableField(value="short_name")
    private String shortName; // 项目简称
    @TableField(value="address")
    private String address; // 项目地点
    @TableField(value="pub_unit")
    private Long pubUnit; // 建设单位
    @TableField(value="pub_unit_name")
    private String pubUnitName; // 建设单位
    @TableField(value="supervisor")
    private String supervisor; // 监理单位
    @TableField(value="designer")
    private String designer; // 设计单位
    @TableField(value="business_type")
    private Long businessType; // 业务类型
    @TableField(value="business_type_name")
    private String businessTypeName; // 业务类型
    @TableField(value="memo")
    private String memo; // 项目内容概述
    @TableField(value="contract_flag")
    private String contractFlag; // 是否已签订合同
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    @TableField(value="contract_sign_date")
    private Date contractSignDate; // 合同签订日期
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    @TableField(value="planned_commencement_date")
    private Date plannedCommencementDate; // 计划开工日期
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    @TableField(value="planned_finish_date")
    private Date plannedFinishDate; // 计划竣工日期
    @TableField(value="cost_total")
    private BigDecimal costTotal; // 金额（元）
    @TableField(value="tax_rate")
    private BigDecimal taxRate; // 税率
    @TableField(value="expect_cost_total")
    private BigDecimal expectCostTotal; // 预计成本总额（元）
    @TableField(value="expect_profit_rate")
    private BigDecimal expectProfitRate; // 预计利润率（%）
    @TableField(value="quality_maintain_flag")
    private String qualityMaintainFlag; // 是否含有质保\养护期
    @TableField(value="quality_maintain_date")
    private String qualityMaintainDate; // 预计质保\养护期起止日
    @TableField(value="quality_maintain_mny")
    private BigDecimal qualityMaintainMny; // 质保\养护金额（元）
    @TableField(value="bill_state")
    private Integer billState; // 单据状态（审批必须字段）
    
    
    

    public Long getPreparationPlanId() {
        return preparationPlanId;
    }

    public void setPreparationPlanId(Long preparationPlanId) {
        this.preparationPlanId = preparationPlanId;
    }
    public String getPreparationPlanCode() {
        return preparationPlanCode;
    }

    public void setPreparationPlanCode(String preparationPlanCode) {
        this.preparationPlanCode = preparationPlanCode;
    }
    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }
    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }
    public String getShortName() {
        return shortName;
    }

    public void setShortName(String shortName) {
        this.shortName = shortName;
    }
    public String getAddress() {
        return address;
    }

    public void setAddress(String address) {
        this.address = address;
    }
    public Long getPubUnit() {
        return pubUnit;
    }

    public void setPubUnit(Long pubUnit) {
        this.pubUnit = pubUnit;
    }
    public String getPubUnitName() {
        return pubUnitName;
    }

    public void setPubUnitName(String pubUnitName) {
        this.pubUnitName = pubUnitName;
    }
    public String getSupervisor() {
        return supervisor;
    }

    public void setSupervisor(String supervisor) {
        this.supervisor = supervisor;
    }
    public String getDesigner() {
        return designer;
    }

    public void setDesigner(String designer) {
        this.designer = designer;
    }
    public Long getBusinessType() {
        return businessType;
    }

    public void setBusinessType(Long businessType) {
        this.businessType = businessType;
    }
    public String getBusinessTypeName() {
        return businessTypeName;
    }

    public void setBusinessTypeName(String businessTypeName) {
        this.businessTypeName = businessTypeName;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public String getContractFlag() {
        return contractFlag;
    }

    public void setContractFlag(String contractFlag) {
        this.contractFlag = contractFlag;
    }
    public Date getContractSignDate() {
        return contractSignDate;
    }

    public void setContractSignDate(Date contractSignDate) {
        this.contractSignDate = contractSignDate;
    }
    public Date getPlannedCommencementDate() {
        return plannedCommencementDate;
    }

    public void setPlannedCommencementDate(Date plannedCommencementDate) {
        this.plannedCommencementDate = plannedCommencementDate;
    }
    public Date getPlannedFinishDate() {
        return plannedFinishDate;
    }

    public void setPlannedFinishDate(Date plannedFinishDate) {
        this.plannedFinishDate = plannedFinishDate;
    }
    public BigDecimal getCostTotal() {
        return costTotal;
    }

    public void setCostTotal(BigDecimal costTotal) {
        this.costTotal = costTotal;
    }
    public BigDecimal getTaxRate() {
        return taxRate;
    }

    public void setTaxRate(BigDecimal taxRate) {
        this.taxRate = taxRate;
    }
    public BigDecimal getExpectCostTotal() {
        return expectCostTotal;
    }

    public void setExpectCostTotal(BigDecimal expectCostTotal) {
        this.expectCostTotal = expectCostTotal;
    }
    public BigDecimal getExpectProfitRate() {
        return expectProfitRate;
    }

    public void setExpectProfitRate(BigDecimal expectProfitRate) {
        this.expectProfitRate = expectProfitRate;
    }
    public String getQualityMaintainFlag() {
        return qualityMaintainFlag;
    }

    public void setQualityMaintainFlag(String qualityMaintainFlag) {
        this.qualityMaintainFlag = qualityMaintainFlag;
    }
    public String getQualityMaintainDate() {
        return qualityMaintainDate;
    }

    public void setQualityMaintainDate(String qualityMaintainDate) {
        this.qualityMaintainDate = qualityMaintainDate;
    }
    public BigDecimal getQualityMaintainMny() {
        return qualityMaintainMny;
    }

    public void setQualityMaintainMny(BigDecimal qualityMaintainMny) {
        this.qualityMaintainMny = qualityMaintainMny;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    
}
