package com.ejianc.business.market.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import com.ejianc.business.market.bean.ProjectApplyOuterPeopleEntity;
import com.ejianc.business.market.bean.ProjectBidPeopleEntity;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 项目立项申请
 * 
 * @author generator
 * 
 */
 @TableName("ejc_market_apply_project")
public class ProjectApplyEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="code")
    private String code; // 单据编号
    @TableField(value="project_code")
    private String projectCode; // 项目编号
    @TableField(value="name")
    private String name; // 项目名称
    @TableField(value="short_name")
    private String shortName; // 简称项目名称
    @TableField(value="org_id")
    private Long orgId; // 所属组织
    @TableField(value="status")
    private String status; // 项目状态：1-未开工, 2-在建，3-完成
    @TableField(value="type")
    private String type; // 项目类型：1-自营，2-联营
    @TableField(value="manage_charge_ratio")
    private Double manageChargeRatio; // 管理费
    @TableField(value="contractual_model")
    private Long contractualModel; // 承包模式
    @TableField(value="pub_unit")
    private Long pubUnit; // 发包单位
    @TableField(value="contractor_unit")
    private Long contractorUnit; // 承包单位
    @TableField(value="area")
    private String area; // 项目地区
    @TableField(value="address")
    private String address; // 详细地址
    @TableField(value="investor")
    private Long investor; // 投资主体
    @TableField(value="funds_source")
    private String fundsSource; // 资金来源
    @TableField(value="cost_total")
    private BigDecimal costTotal; // 总造价(万元)
    @TableField(value="bidding_from")
    private Long biddingForm; // 招标形式
    @TableField(value="bus_oppr_id")
    private Long busOpprId;
    @TableField(value="bus_oppr_name")
    private String busOpprName;
    @TableField(value="planned_commencement_date")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date plannedCommencementDate; // 计划开工日期
    @TableField(value="planned_finish_date")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date plannedFinishDate; // 计划竣工日期
    @TableField(value="built_area")
    private BigDecimal builtArea; // 建筑面积(㎡)
    @TableField(value="structure_type")
    private Long structureType; // 结构类型
    @TableField(value="engineering_purpose")
    private Long engineeringPurpose; // 工程用途
    @TableField(value="project_overview")
    private String projectOverview; // 工程概况
    @TableField(value="project_department_id")
    private Long projectDepartmentId; // 项目部Id
    @TableField(value="valid_status")
    private String validStatus; // 项目状态：0-启用，1-停用
    @TableField(value="org_name")
    private String orgName; // 所属组织名称
    @TableField(value="contractor_unit_name")
    private String contractorUnitName; // 承包单位名字
    @TableField(value="pub_unit_name")
    private String pubUnitName; // 发包单位名称
    @TableField(value="contractual_model_name")
    private String contractualModelName; // 承包模式名称
    @TableField(value="investor_name")
    private String investorName; // 投资主体名称
    @TableField(value="bidding_form_name")
    private String biddingFormName; // 招标形式名称
    @TableField(value="structure_type_name")
    private String structureTypeName; // 结构类型名称
    @TableField(value="engineering_purpose_name")
    private String engineeringPurposeName; // 工程用途名称
    @TableField(value="create_user_name")
    private String createUserName; // 创建人名称
    @TableField(value="project_owner")
    private String projectOwner; // 项目所属人
    @TableField(value="source_id")
    private String sourceId; // 数据在来源系统中的主键
    @TableField(value="system_code")
    private String systemCode; // 数据来源系统编码
    @TableField(value="system_id")
    private Long systemId; // 数据来源系统在平台中的主键
    @TableField(value="sign_date")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date signDate; // 项目签订日期
    @TableField(value="engineering_type")
    private Long engineeringType; // 工程类型
    @TableField(value="engineering_type_name")
    private String engineeringTypeName; // 工程类型名称
    @TableField(value="project_manager")
    private Long projectManager; // 项目经理
    @TableField(value="project_manager_name")
    private String projectManagerName; // 项目经理名称
    @TableField(value="province")
    private String province; // 省份
    @TableField(value="city")
    private String city; // 市
    @TableField(value="region")
    private String region; // 区县
    @TableField(value="material_verification")
    private Integer materialVerification; // 是否使用材料核销
    @TableField(value="focus_type")
    private String focusType; // 关注类型 0-普通项目 1-工程局重点关注 2-工程局重点监控 3-二级单位重点关注 4-二级单位重点监控
    @TableField(value="area_id")
    private Long areaId; // 区域id
    @TableField(value="area_code")
    private String areaCode; // 区域编码
    @TableField(value="area_name")
    private String areaName; // 区域名称
    @TableField(value="lat")
    private String lat; // 纬度
    @TableField(value="lng")
    private String lng; // 经度
    @TableField(value="supervisor")
    private String supervisor; // 监理单位人员
    @TableField(value="designer")
    private String designer; // 设计单位人员
    @TableField(value="project_control_level")
    private Long projectControlLevel; // 项目管控级别
    @TableField(value="begin_bid_date")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date beginBidDate; // 开标日期
    @TableField(value="win_bid_date")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date winBidDate; // 中标日期
    @TableField(value="start_date")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date startDate; // 开工日期
    @TableField(value="finish_date")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date finishDate; // 完工日期
    @TableField(value="inspect_date")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date inspectDate; // 验收日期
    @TableField(value="plan_duration")
    private String planDuration; // 计划工期
    /**
     * 信息来源
     */
    @TableField(value = "info_source")
    private Long infoSource;

    /**
     * 信息来源名称
     */
    @TableField(value = "info_source_name")
    private String infoSourceName;
    /**
     * 单据状态
     */
    @TableField(value = "bill_state")
    private Integer billState;
    
    @TableField(exist=false)
    @SubEntity(serviceName="projectApplyOuterPeopleService")
    private List<ProjectApplyOuterPeopleEntity> outerPeopleList = new ArrayList<>(); // 项目立项申请-外派人员
    @TableField(exist=false)
    @SubEntity(serviceName="projectApplyBidPeopleService")
    private List<ProjectApplyBidPeopleEntity> bidPeopleList = new ArrayList<>(); // 项目立项申请-投标人员
    @TableField(exist=false)
    @SubEntity(serviceName="projectApplyMembersService")
    private List<ProjectApplyMembersEntity> membersList = new ArrayList<>(); // 项目立项申请-项目成员


    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }
    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }
    public String getShortName() {
        return shortName;
    }

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    public void setShortName(String shortName) {
        this.shortName = shortName;
    }
    public Long getOrgId() {
        return orgId;
    }

    public Long getInfoSource() {
        return infoSource;
    }

    public void setInfoSource(Long infoSource) {
        this.infoSource = infoSource;
    }

    public String getInfoSourceName() {
        return infoSourceName;
    }

    public void setInfoSourceName(String infoSourceName) {
        this.infoSourceName = infoSourceName;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getStatus() {
        return status;
    }

    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }

    public void setStatus(String status) {
        this.status = status;
    }
    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }
    public Double getManageChargeRatio() {
        return manageChargeRatio;
    }

    public void setManageChargeRatio(Double manageChargeRatio) {
        this.manageChargeRatio = manageChargeRatio;
    }
    public Long getContractualModel() {
        return contractualModel;
    }

    public void setContractualModel(Long contractualModel) {
        this.contractualModel = contractualModel;
    }
    public Long getPubUnit() {
        return pubUnit;
    }

    public void setPubUnit(Long pubUnit) {
        this.pubUnit = pubUnit;
    }
    public Long getContractorUnit() {
        return contractorUnit;
    }

    public void setContractorUnit(Long contractorUnit) {
        this.contractorUnit = contractorUnit;
    }
    public String getArea() {
        return area;
    }

    public void setArea(String area) {
        this.area = area;
    }
    public String getAddress() {
        return address;
    }

    public void setAddress(String address) {
        this.address = address;
    }
    public Long getInvestor() {
        return investor;
    }

    public List<ProjectApplyMembersEntity> getMembersList() {
        return membersList;
    }

    public void setMembersList(List<ProjectApplyMembersEntity> membersList) {
        this.membersList = membersList;
    }

    public Long getBusOpprId() {
        return busOpprId;
    }

    public void setBusOpprId(Long busOpprId) {
        this.busOpprId = busOpprId;
    }

    public String getBusOpprName() {
        return busOpprName;
    }

    public void setBusOpprName(String busOpprName) {
        this.busOpprName = busOpprName;
    }

    public void setInvestor(Long investor) {
        this.investor = investor;
    }
    public String getFundsSource() {
        return fundsSource;
    }

    public void setFundsSource(String fundsSource) {
        this.fundsSource = fundsSource;
    }
    public BigDecimal getCostTotal() {
        return costTotal;
    }

    public void setCostTotal(BigDecimal costTotal) {
        this.costTotal = costTotal;
    }

    public Long getBiddingForm() {
        return biddingForm;
    }

    public void setBiddingForm(Long biddingForm) {
        this.biddingForm = biddingForm;
    }

    public Date getPlannedCommencementDate() {
        return plannedCommencementDate;
    }

    public void setPlannedCommencementDate(Date plannedCommencementDate) {
        this.plannedCommencementDate = plannedCommencementDate;
    }
    public Date getPlannedFinishDate() {
        return plannedFinishDate;
    }

    public void setPlannedFinishDate(Date plannedFinishDate) {
        this.plannedFinishDate = plannedFinishDate;
    }
    public BigDecimal getBuiltArea() {
        return builtArea;
    }

    public void setBuiltArea(BigDecimal builtArea) {
        this.builtArea = builtArea;
    }
    public Long getStructureType() {
        return structureType;
    }

    public void setStructureType(Long structureType) {
        this.structureType = structureType;
    }
    public Long getEngineeringPurpose() {
        return engineeringPurpose;
    }

    public void setEngineeringPurpose(Long engineeringPurpose) {
        this.engineeringPurpose = engineeringPurpose;
    }
    public String getProjectOverview() {
        return projectOverview;
    }

    public void setProjectOverview(String projectOverview) {
        this.projectOverview = projectOverview;
    }
    public Long getProjectDepartmentId() {
        return projectDepartmentId;
    }

    public void setProjectDepartmentId(Long projectDepartmentId) {
        this.projectDepartmentId = projectDepartmentId;
    }
    public String getValidStatus() {
        return validStatus;
    }

    public void setValidStatus(String validStatus) {
        this.validStatus = validStatus;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public String getContractorUnitName() {
        return contractorUnitName;
    }

    public void setContractorUnitName(String contractorUnitName) {
        this.contractorUnitName = contractorUnitName;
    }
    public String getPubUnitName() {
        return pubUnitName;
    }

    public void setPubUnitName(String pubUnitName) {
        this.pubUnitName = pubUnitName;
    }
    public String getContractualModelName() {
        return contractualModelName;
    }

    public void setContractualModelName(String contractualModelName) {
        this.contractualModelName = contractualModelName;
    }
    public String getInvestorName() {
        return investorName;
    }

    public void setInvestorName(String investorName) {
        this.investorName = investorName;
    }
    public String getBiddingFormName() {
        return biddingFormName;
    }

    public void setBiddingFormName(String biddingFormName) {
        this.biddingFormName = biddingFormName;
    }
    public String getStructureTypeName() {
        return structureTypeName;
    }

    public void setStructureTypeName(String structureTypeName) {
        this.structureTypeName = structureTypeName;
    }
    public String getEngineeringPurposeName() {
        return engineeringPurposeName;
    }

    public void setEngineeringPurposeName(String engineeringPurposeName) {
        this.engineeringPurposeName = engineeringPurposeName;
    }
    public String getCreateUserName() {
        return createUserName;
    }

    public void setCreateUserName(String createUserName) {
        this.createUserName = createUserName;
    }
    public String getProjectOwner() {
        return projectOwner;
    }

    public void setProjectOwner(String projectOwner) {
        this.projectOwner = projectOwner;
    }
    public String getSourceId() {
        return sourceId;
    }

    public void setSourceId(String sourceId) {
        this.sourceId = sourceId;
    }
    public String getSystemCode() {
        return systemCode;
    }

    public void setSystemCode(String systemCode) {
        this.systemCode = systemCode;
    }
    public Long getSystemId() {
        return systemId;
    }

    public void setSystemId(Long systemId) {
        this.systemId = systemId;
    }
    public Date getSignDate() {
        return signDate;
    }

    public void setSignDate(Date signDate) {
        this.signDate = signDate;
    }
    public Long getEngineeringType() {
        return engineeringType;
    }

    public void setEngineeringType(Long engineeringType) {
        this.engineeringType = engineeringType;
    }
    public String getEngineeringTypeName() {
        return engineeringTypeName;
    }

    public void setEngineeringTypeName(String engineeringTypeName) {
        this.engineeringTypeName = engineeringTypeName;
    }
    public Long getProjectManager() {
        return projectManager;
    }

    public void setProjectManager(Long projectManager) {
        this.projectManager = projectManager;
    }
    public String getProjectManagerName() {
        return projectManagerName;
    }

    public void setProjectManagerName(String projectManagerName) {
        this.projectManagerName = projectManagerName;
    }
    public String getProvince() {
        return province;
    }

    public void setProvince(String province) {
        this.province = province;
    }
    public String getCity() {
        return city;
    }

    public void setCity(String city) {
        this.city = city;
    }
    public String getRegion() {
        return region;
    }

    public void setRegion(String region) {
        this.region = region;
    }
    public Integer getMaterialVerification() {
        return materialVerification;
    }

    public void setMaterialVerification(Integer materialVerification) {
        this.materialVerification = materialVerification;
    }
    public String getFocusType() {
        return focusType;
    }

    public void setFocusType(String focusType) {
        this.focusType = focusType;
    }
    public Long getAreaId() {
        return areaId;
    }

    public void setAreaId(Long areaId) {
        this.areaId = areaId;
    }
    public String getAreaCode() {
        return areaCode;
    }

    public void setAreaCode(String areaCode) {
        this.areaCode = areaCode;
    }
    public String getAreaName() {
        return areaName;
    }

    public void setAreaName(String areaName) {
        this.areaName = areaName;
    }
    public String getLat() {
        return lat;
    }

    public void setLat(String lat) {
        this.lat = lat;
    }
    public String getLng() {
        return lng;
    }

    public void setLng(String lng) {
        this.lng = lng;
    }
    public String getSupervisor() {
        return supervisor;
    }

    public void setSupervisor(String supervisor) {
        this.supervisor = supervisor;
    }
    public String getDesigner() {
        return designer;
    }

    public void setDesigner(String designer) {
        this.designer = designer;
    }
    public Long getProjectControlLevel() {
        return projectControlLevel;
    }

    public void setProjectControlLevel(Long projectControlLevel) {
        this.projectControlLevel = projectControlLevel;
    }
    public Date getBeginBidDate() {
        return beginBidDate;
    }

    public void setBeginBidDate(Date beginBidDate) {
        this.beginBidDate = beginBidDate;
    }
    public Date getWinBidDate() {
        return winBidDate;
    }

    public void setWinBidDate(Date winBidDate) {
        this.winBidDate = winBidDate;
    }
    public Date getStartDate() {
        return startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }
    public Date getFinishDate() {
        return finishDate;
    }

    public void setFinishDate(Date finishDate) {
        this.finishDate = finishDate;
    }
    public Date getInspectDate() {
        return inspectDate;
    }

    public void setInspectDate(Date inspectDate) {
        this.inspectDate = inspectDate;
    }
    public String getPlanDuration() {
        return planDuration;
    }

    public void setPlanDuration(String planDuration) {
        this.planDuration = planDuration;
    }


    public List<ProjectApplyOuterPeopleEntity> getOuterPeopleList() {
        return outerPeopleList;
    }

    public void setOuterPeopleList(List<ProjectApplyOuterPeopleEntity> outerPeopleList) {
        this.outerPeopleList = outerPeopleList;
    }

    public List<ProjectApplyBidPeopleEntity> getBidPeopleList() {
        return bidPeopleList;
    }

    public void setBidPeopleList(List<ProjectApplyBidPeopleEntity> bidPeopleList) {
        this.bidPeopleList = bidPeopleList;
    }
}
