package com.ejianc.business.market.controller;

import java.io.Serializable;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.market.bean.BusinessOpportunityEntity;
import com.ejianc.business.market.bean.ProjectApplyMembersEntity;
import com.ejianc.business.market.bean.ProjectRegisterEntity;
import com.ejianc.business.market.service.IBusinessOpportunityService;
import com.ejianc.business.market.service.IProjectRegisterService;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.market.bean.ProjectApplyEntity;
import com.ejianc.business.market.service.IProjectApplyService;
import com.ejianc.business.market.vo.ProjectApplyVO;

/**
 * 项目立项申请
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("projectApply")
public class ProjectApplyController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    IBusinessOpportunityService businessOpportunityService;
    private static final String BILL_CODE = "marketProjectApply";//此处需要根据实际修改

    @Autowired
    private IProjectApplyService service;
    @Autowired
    private IProjectRegisterService projectRegisterService;

    @Autowired
    private SessionManager sessionManager;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ProjectApplyVO> saveOrUpdate(@RequestBody ProjectApplyVO saveOrUpdateVO) {
    	ProjectApplyEntity entity = BeanMapper.map(saveOrUpdateVO, ProjectApplyEntity.class);
    	if((entity.getId() == null || entity.getId() == 0)&&StringUtils.isEmpty(entity.getCode())){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
    	if (CollectionUtils.isNotEmpty(entity.getMembersList())){
            entity.getMembersList().forEach(i->{
                if (StringUtils.isNotBlank(i.getRowState())){
                    i.setRowStateName(i.getRowState());
                }
            });
        }
    	if (StringUtils.isNotBlank(entity.getProjectCode())||StringUtils.isNotBlank(entity.getName())){
            QueryWrapper<ProjectRegisterEntity> query = Wrappers.query();
            query.and(item->{
                item.eq(StringUtils.isNotBlank(entity.getName()),"name",entity.getName()).or();
                item.eq(StringUtils.isNotBlank(entity.getProjectCode()),"code",entity.getProjectCode());
                return item;
                    });
            query.eq("dr", BaseVO.DR_UNDELETE);
            int count = projectRegisterService.count(query);
            if (count>0){
                throw new BusinessException("保存失败，该项目编号/项目名称已存在，请重新填写！");
            }
        }
    	service.saveOrUpdate(entity, false);
        if(null!=saveOrUpdateVO.getBusOpprId()){
            BusinessOpportunityEntity buOpr = businessOpportunityService.selectById(saveOrUpdateVO.getBusOpprId());
            if(null != buOpr) {
                buOpr.setApplyIsSet(true);
                businessOpportunityService.saveOrUpdate(buOpr, false);
            }
        }
    	ProjectApplyVO vo = BeanMapper.map(entity, ProjectApplyVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ProjectApplyVO> queryDetail(Long id) {
    	ProjectApplyEntity entity = service.selectById(id);
    	ProjectApplyVO vo = BeanMapper.map(entity, ProjectApplyVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ProjectApplyVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (ProjectApplyVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
                //判断是否参照商机，若参照商机则恢复商机对应的引用状态
                ProjectApplyEntity projectApplyEntity = service.selectById(vo.getId());
                if (null!=projectApplyEntity.getBusOpprId()) {
                    BusinessOpportunityEntity buOpr = businessOpportunityService.selectById(projectApplyEntity.getBusOpprId());
                    if (null != buOpr) {
                        logger.info("项目删除，还原对应商机[id-{}]引用状态", buOpr.getId());
                        buOpr.setApplyIsSet(false);
                        businessOpportunityService.saveOrUpdate(buOpr, false);
                    }
                }
            }
        }

        service.removeByIds(vos.stream().map(ProjectApplyVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<ProjectApplyVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getFuzzyFields().add("code");
        param.getFuzzyFields().add("name");
        param.getFuzzyFields().add("orgName");
        param.getFuzzyFields().add("pubUnitName");
        //添加简称项目名称模糊查询
        param.getFuzzyFields().add("shortName");
        param.getFuzzyFields().add("createUserName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));

        IPage<ProjectApplyEntity> page = service.queryPage(param,false);
        IPage<ProjectApplyVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), ProjectApplyVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getFuzzyFields().add("code");
        param.getFuzzyFields().add("name");
        param.getFuzzyFields().add("orgName");
        param.getFuzzyFields().add("pubUnitName");
        //添加简称项目名称模糊查询
        param.getFuzzyFields().add("shortName");
        param.getFuzzyFields().add("createUserName");
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<ProjectApplyEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", BeanMapper.mapList(list, ProjectApplyVO.class));
        ExcelExport.getInstance().export("project-apply-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refProjectApplyData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<ProjectApplyVO>> refProjectApplyData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<ProjectApplyEntity> page = service.queryPage(param,false);
        IPage<ProjectApplyVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), ProjectApplyVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }
}
