package com.ejianc.business.market.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.market.bean.ProjectApplyEntity;
import com.ejianc.business.market.bean.ProjectApplyMembersEntity;
import com.ejianc.business.market.bean.ProjectRegisterEntity;
import com.ejianc.business.market.service.IProjectApplyService;
import com.ejianc.business.market.service.IProjectRegisterService;
import com.ejianc.business.market.vo.ProjectRegisterVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.skeleton.template.BaseVO;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Service("projectApply") 
public class ProjectApplyBpmServiceImpl implements ICommonBusinessService {
	private Logger logger = LoggerFactory.getLogger(this.getClass());
	@Autowired
	private IProjectRegisterService projectRegisterService;

	@Autowired
	private IProjectApplyService service;
	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批后回调
	 *
	 * @param billId	//单据id
	 * @param state		//单据状态
	 * @param billTypeCode		//单据类型code
	 * @param taskId		//该流程id
	 * @param isEnd		//该节点是否结束
	 * @return
	 */
	@Override
	public CommonResponse<String> afterInApprovalBack(Long billId, Integer state, String billTypeCode, String taskId, Boolean isEnd, String sign, Map<String,Object> other){
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		ProjectApplyEntity projectApplyEntity = service.selectById(billId);
		List<ProjectApplyMembersEntity> applyMembersEntity=new ArrayList();
		if (CollectionUtils.isNotEmpty(projectApplyEntity.getMembersList())){
			applyMembersEntity=projectApplyEntity.getMembersList();
		}
		//数据类型不同此处置为空下方特殊处理
		projectApplyEntity.setMembersList(null);
		ProjectRegisterVO proVo = BeanMapper.map(projectApplyEntity, ProjectRegisterVO.class);
		proVo.setId(null);
		proVo.setCode(projectApplyEntity.getProjectCode());
		proVo.setCreateTime(null);
		proVo.setCreateUserCode(null);
		proVo.setUpdateTime(null);
		proVo.setUpdateUserCode(null);
		proVo.setDr(0);
		proVo.setApplyId(projectApplyEntity.getId());
		if (CollectionUtils.isNotEmpty(proVo.getBidPeopleList())){
			proVo.getBidPeopleList().forEach(item->{
				item.setId(null);
			});
		}
		if (CollectionUtils.isNotEmpty(proVo.getOuterPeopleList())){
			proVo.getOuterPeopleList().forEach(item->{
				item.setId(null);
			});
		}
		if (CollectionUtils.isNotEmpty(applyMembersEntity)){
			List<Map<String, Object>> memberList = new ArrayList();
			applyMembersEntity.forEach(item->{
						Map<String, Object> map = new HashMap();
						map.put("userId",String.valueOf(item.getUserId()));
						map.put("employeeId",String.valueOf(item.getEmployeeId()));
						map.put("userName",item.getUserName());
						map.put("jobType",item.getJobType());
						map.put("jobId",String.valueOf(item.getJobId()));
						map.put("roleId",String.valueOf(item.getRoleId()));
						map.put("roleName",item.getRoleName());
						map.put("isAdd",item.getIsAdd());
						map.put("type",item.getType());
						JSONObject jsonObj = new JSONObject();
						if (null!=item.getPostId()) {
							jsonObj.put("id", String.valueOf(item.getPostId()));
							jsonObj.put("name", item.getPostName());
						}
						map.put("postId",jsonObj);
						map.put("rowState",item.getRowStateName());
						memberList.add(map);
					}
			);
			proVo.setMembersList(memberList);
		}
		logger.info("项目申请---项目立项传递VO------------>：{}",JSONObject.toJSONString(proVo));
		CommonResponse<ProjectRegisterVO> projectRegisterVOCommonResponse = projectRegisterService.saveProject(proVo);
		if (!projectRegisterVOCommonResponse.isSuccess()){
			return CommonResponse.error(projectRegisterVOCommonResponse.getMsg());
		}
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		QueryWrapper<ProjectRegisterEntity> query = Wrappers.query();
		query.eq("dr", BaseVO.DR_UNDELETE);
		query.eq("apply_id", billId);
		int count = projectRegisterService.count(query);
		if (count>0){
			throw new BusinessException("该项目立项申请已生成项目档案，撤回失败！");
		}
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

}
