package com.ejianc.business.market.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.market.vo.BidDetailVO;
import com.ejianc.business.market.vo.ProjectBidPeopleVO;
//import com.ejianc.business.oa.vo.CertApplyListVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.market.mapper.ProjectBidPeopleMapper;
import com.ejianc.business.market.bean.ProjectBidPeopleEntity;
import com.ejianc.business.market.service.IProjectBidPeopleService;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 项目登记-投标人员
 * 
 * @author generator
 * 
 */
@Service("projectBidPeopleService")
public class ProjectBidPeopleServiceImpl extends BaseServiceImpl<ProjectBidPeopleMapper, ProjectBidPeopleEntity> implements IProjectBidPeopleService{
    @Autowired
    private IOrgApi orgApi;



    @Override
    public List<BidDetailVO> queryBidDetail(QueryParam param) {
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.addAll(Arrays.asList("employeeType","code","name"));
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("org_id", new Parameter("in", orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        Parameter parameter = param.getParams().get("employeeId");
        if (null==parameter){
            throw new BusinessException("人员id不能为空！");
        }
        Long employeeId =  Long.valueOf((String)param.getParams().get("employeeId").getValue());
        param.getParams().remove("employeeId");
        param.getOrderMap().put("beginDate",QueryParam.DESC);
        QueryWrapper wrapper = changeToQueryWrapper(param);
        List<BidDetailVO> bidDetailVOS = baseMapper.queryBidDetail(wrapper, employeeId);
        return bidDetailVOS;
    }
}
