package com.ejianc.business.market.vo;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
  * @Author mrsir_wxp
  * @String 2020/5/20 商机登记导出vo
  * @Description BusinessOpportunityExportVO
  */
 
public class BusinessOpportunityExportVO implements Serializable {

    private static final Long serialVersionUID = 2779265683203439571L;

    /**
     * 单据状态
     */
    private String billState;

    /**
     * 工程名称
     */
    private String engineeringName;

     /**
      * 所属组织
      */
     private Long orgId;

    /**
     * 工程编码
     */
    private String billCode;

    /**
     * 工程类型
     */
    private String engineeringType;

    /**
     * 工程类型名称
     */
    private String engineeringTypeName;

    /**
     * 信息来源
     */
    private String infoSource;

    /**
     * 信息来源名称
     */
    private String infoSourceName;

    /**
     * 跟踪人
     */
    private String followPerson;

    /**
     * 跟踪人名称
     */
    private String followPersonName;

    /**
     * 跟踪人电话
     */
    private String followPersonPhone;

    /**
     * 项目阶段
     */
    private String engineeringStage;

    /**
     * 项目阶段名称
     */
    private String engineeringStageName;

    /**
     * 地区
     */
    private String area;

    /**
     * 详细地址
     */
    private String address;

    /**
     * 建设单位
     */
    private String constructionUnit;

    /**
     * 建设单位名称
     */
    private String constructionUnitName;

    /**
     * 联系人
     */
    private String connectPerson;

    /**
     * 联系电话
     */
    private String connectPhone;

    /**
     * 投资主体
     */
    private String investor;

    /**
     * 资金来源
     */
    private String fundsSource;

    /**
     * 总造价(万元)
     */
    private BigDecimal costTotal;

    /**
     * 招标形式
     */
    private String biddingForm;

    /**
     * 招标形式名称
     */
    private String biddingFormName;

    /**
     * 预计招标日期
     */
    private String estimatedBiddingDate;

    /**
     * 计划开工日期
     */
    private String plannedCommencementDate;

    /**
     * 计划竣工日期
     */
    private String plannedFinishDate;

    /**
     * 工程概况
     */
    private String projectOverview;

    /**
     * 建筑面积(㎡)
     */
    private BigDecimal builtArea;

    /**
     * 结构类型
     */
    private String structureType;

    /**
     * 工程用途
     */
    private String engineeringPurpose;

    /**
     * 质量等级
     */
    private String qualityLeave;

    /**
     * 是否立项
     */
    private String projectIsSet;

    /**
     * 项目立项单据id
     */
    private String projectSetId;
     /**
      * 中标状态 1是 0否
      */
     private Integer resultState;

     /**
      * 中标状态 1是 0否
      */
     private String resultStateStr;
     private String inviteAgency; // 招标代理机构
     @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
     private Date signEndDate; // 报名截止日期
     private String signWebsite; // 项目报名网址
     @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
     private Date openDate; // 开标日期
     private String openAddress; // 开标地点
     private BigDecimal signCost; // 报名费用
     public String getResultStateStr() {
         return resultStateStr;
     }

     public void setResultStateStr(String resultStateStr) {
         this.resultStateStr = resultStateStr;
     }

     public Integer getResultState() {
         return resultState;
     }

     public void setResultState(Integer resultState) {
         this.resultState = resultState;
     }


    public String getBillState() {
        return billState;
    }

    public void setBillState(String billType) {
        this.billState = billType;
    }

    public String getEngineeringName() {
        return engineeringName;
    }

    public String getInviteAgency() {
        return inviteAgency;
    }

    public void setInviteAgency(String inviteAgency) {
        this.inviteAgency = inviteAgency;
    }

    public Date getSignEndDate() {
        return signEndDate;
    }

    public void setSignEndDate(Date signEndDate) {
        this.signEndDate = signEndDate;
    }

    public String getSignWebsite() {
        return signWebsite;
    }

    public void setSignWebsite(String signWebsite) {
        this.signWebsite = signWebsite;
    }

    public Date getOpenDate() {
        return openDate;
    }

    public void setOpenDate(Date openDate) {
        this.openDate = openDate;
    }

    public String getOpenAddress() {
        return openAddress;
    }

    public void setOpenAddress(String openAddress) {
        this.openAddress = openAddress;
    }

    public BigDecimal getSignCost() {
        return signCost;
    }

    public void setSignCost(BigDecimal signCost) {
        this.signCost = signCost;
    }

    public void setEngineeringName(String engineeringName) {
        this.engineeringName = engineeringName;
    }

     public Long getOrgId() {
         return orgId;
     }

     public void setOrgId(Long orgId) {
         this.orgId = orgId;
     }

     public String getBillCode() {
         return billCode;
     }

     public void setBillCode(String billCode) {
         this.billCode = billCode;
     }

     public String getEngineeringType() {
        return engineeringType;
    }

    public void setEngineeringType(String engineeringType) {
        this.engineeringType = engineeringType;
    }

    public String getInfoSource() {
        return infoSource;
    }

    public void setInfoSource(String infoSource) {
        this.infoSource = infoSource;
    }

    public String getFollowPerson() {
        return followPerson;
    }

    public void setFollowPerson(String followPerson) {
        this.followPerson = followPerson;
    }

    public String getFollowPersonPhone() {
        return followPersonPhone;
    }

    public void setFollowPersonPhone(String followPersonPhone) {
        this.followPersonPhone = followPersonPhone;
    }

    public String getEngineeringStage() {
        return engineeringStage;
    }

    public void setEngineeringStage(String engineeringStage) {
        this.engineeringStage = engineeringStage;
    }

    public String getEngineeringStageName() {
        return engineeringStageName;
    }

    public void setEngineeringStageName(String engineeringStageName) {
        this.engineeringStageName = engineeringStageName;
    }

    public String getArea() {
        return area;
    }

    public void setArea(String area) {
        this.area = area;
    }

    public String getAddress() {
        return address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public String getConstructionUnit() {
        return constructionUnit;
    }

    public void setConstructionUnit(String constructionUnit) {
        this.constructionUnit = constructionUnit;
    }

    public String getConnectPerson() {
        return connectPerson;
    }

    public void setConnectPerson(String connectPerson) {
        this.connectPerson = connectPerson;
    }

    public String getConnectPhone() {
        return connectPhone;
    }

    public void setConnectPhone(String connectPhone) {
        this.connectPhone = connectPhone;
    }

    public String getInvestor() {
        return investor;
    }

    public void setInvestor(String investor) {
        this.investor = investor;
    }

    public String getFundsSource() {
        return fundsSource;
    }

    public void setFundsSource(String fundsSource) {
        this.fundsSource = fundsSource;
    }

    public BigDecimal getCostTotal() {
        return costTotal;
    }

    public void setCostTotal(BigDecimal costTotal) {
        this.costTotal = costTotal;
    }

    public String getBiddingForm() {
        return biddingForm;
    }

    public void setBiddingForm(String biddingForm) {
        this.biddingForm = biddingForm;
    }

    public String getEstimatedBiddingDate() {
        return estimatedBiddingDate;
    }

    public void setEstimatedBiddingDate(String estimatedBiddingDate) {
        this.estimatedBiddingDate = estimatedBiddingDate;
    }

    public String getPlannedCommencementDate() {
        return plannedCommencementDate;
    }

    public void setPlannedCommencementDate(String plannedCommencementDate) {
        this.plannedCommencementDate = plannedCommencementDate;
    }

    public String getPlannedFinishDate() {
        return plannedFinishDate;
    }

    public void setPlannedFinishDate(String plannedFinishDate) {
        this.plannedFinishDate = plannedFinishDate;
    }

    public String getProjectOverview() {
        return projectOverview;
    }

    public void setProjectOverview(String projectOverview) {
        this.projectOverview = projectOverview;
    }

    public BigDecimal getBuiltArea() {
        return builtArea;
    }

    public void setBuiltArea(BigDecimal builtArea) {
        this.builtArea = builtArea;
    }

    public String getStructureType() {
        return structureType;
    }

    public void setStructureType(String structureType) {
        this.structureType = structureType;
    }

    public String getEngineeringPurpose() {
        return engineeringPurpose;
    }

    public void setEngineeringPurpose(String engineeringPurpose) {
        this.engineeringPurpose = engineeringPurpose;
    }

    public String getQualityLeave() {
        return qualityLeave;
    }

    public void setQualityLeave(String qualityLeave) {
        this.qualityLeave = qualityLeave;
    }

    public String getEngineeringTypeName() {
        return engineeringTypeName;
    }

    public void setEngineeringTypeName(String engineeringTypeName) {
        this.engineeringTypeName = engineeringTypeName;
    }

    public String getInfoSourceName() {
        return infoSourceName;
    }

    public void setInfoSourceName(String infoSourceName) {
        this.infoSourceName = infoSourceName;
    }

    public String getFollowPersonName() {
        return followPersonName;
    }

    public void setFollowPersonName(String followPersonName) {
        this.followPersonName = followPersonName;
    }

    public String getConstructionUnitName() {
        return constructionUnitName;
    }

    public void setConstructionUnitName(String constructionUnitName) {
        this.constructionUnitName = constructionUnitName;
    }

    public String getBiddingFormName() {
        return biddingFormName;
    }

    public void setBiddingFormName(String biddingFormName) {
        this.biddingFormName = biddingFormName;
    }

    public String getProjectIsSet() {
        return projectIsSet;
    }

    public void setProjectIsSet(String projectIsSet) {
        this.projectIsSet = projectIsSet;
    }

    public String getProjectSetId() {
        return projectSetId;
    }

    public void setProjectSetId(String projectSetId) {
        this.projectSetId = projectSetId;
    }
}
