/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.market.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.market.bean.BusinessOpportunityEntity;
import com.ejianc.business.market.service.IBusinessOpportunityService;
import com.ejianc.business.market.vo.BusinessOpportunityExportVO;
import com.ejianc.business.market.vo.BusinessOpportunityVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.ComplexParam;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/business/opportunity/"})
public class BusinessOpportunityController
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Autowired
    IBusinessOpportunityService iBusinessOpportunityService;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<BusinessOpportunityVO> saveOrUpdate(@RequestBody BusinessOpportunityVO businessOpportunityVO) {
        BusinessOpportunityEntity entity = (BusinessOpportunityEntity)((Object)BeanMapper.map((Object)businessOpportunityVO, BusinessOpportunityEntity.class));
        BusinessOpportunityEntity backEntity = this.iBusinessOpportunityService.insertOrUpdate(entity);
        BusinessOpportunityVO vo = (BusinessOpportunityVO)BeanMapper.map((Object)((Object)backEntity), BusinessOpportunityVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<BusinessOpportunityVO> queryDetail(Long id) {
        BusinessOpportunityEntity entity = this.iBusinessOpportunityService.queryDetail(id);
        BusinessOpportunityVO vo = (BusinessOpportunityVO)BeanMapper.map((Object)((Object)entity), BusinessOpportunityVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryPrint"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<JSONObject> queryPrint(Long id) {
        JSONObject json = new JSONObject();
        json.put("BusinessOpportunity", (Object)this.iBusinessOpportunityService.queryDetail(id));
        return CommonResponse.success((String)"\u67e5\u8be2\u6253\u5370\u6570\u636e\u6210\u529f\uff01", (Object)json);
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<BusinessOpportunityEntity>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("address");
        fuzzyFields.add("area");
        fuzzyFields.add("engineeringName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("engineeringTypeName");
        fuzzyFields.add("infoSourceName");
        fuzzyFields.add("followPersonName");
        fuzzyFields.add("constructionUnitName");
        fuzzyFields.add("followPersonPhone");
        fuzzyFields.add("inviteAgency");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        IPage businessOpportunityEntityIPage = this.iBusinessOpportunityService.queryPage(param, false);
        List records = businessOpportunityEntityIPage.getRecords();
        records.forEach(item -> {
            if (null != item.getResultState() && item.getResultState() == 1) {
                item.setResultStateStr("\u5df2\u4e2d\u6807");
            } else {
                item.setResultStateStr("\u672a\u4e2d\u6807");
            }
        });
        businessOpportunityEntityIPage.setRecords(records);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)businessOpportunityEntityIPage);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<BusinessOpportunityVO> vos) {
        this.iBusinessOpportunityService.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam queryParam, HttpServletResponse response) {
        queryParam.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        queryParam.setPageIndex(0);
        queryParam.setPageSize(10000);
        List<BusinessOpportunityExportVO> supplierVos = this.iBusinessOpportunityService.queryExportList(queryParam);
        supplierVos.forEach(item -> {
            if (null != item.getResultState() && item.getResultState() == 1) {
                item.setResultStateStr("\u5df2\u4e2d\u6807");
            } else {
                item.setResultStateStr("\u672a\u4e2d\u6807");
            }
        });
        HashMap<String, List<BusinessOpportunityExportVO>> beans = new HashMap<String, List<BusinessOpportunityExportVO>>();
        beans.put("records", supplierVos);
        ExcelExport.getInstance().export("business-opportunity-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refer"})
    @ResponseBody
    public CommonResponse<IPage<BusinessOpportunityVO>> refer(@RequestParam(defaultValue="1") Integer pageNumber, @RequestParam(defaultValue="10") Integer pageSize, String searchText) {
        QueryParam queryParam = new QueryParam();
        queryParam.setPageIndex(pageNumber.intValue());
        queryParam.setPageSize(pageSize.intValue());
        queryParam.setSearchText(searchText);
        List fuzzyFields = queryParam.getFuzzyFields();
        fuzzyFields.add("address");
        fuzzyFields.add("area");
        fuzzyFields.add("engineeringName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("engineeringTypeName");
        fuzzyFields.add("infoSourceName");
        fuzzyFields.add("followPersonName");
        fuzzyFields.add("constructionUnitName");
        queryParam.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        queryParam.getParams().put("billState", new Parameter("in", (Object)"1,3"));
        queryParam.getOrderMap().put("createTime", "desc");
        ComplexParam c1 = new ComplexParam();
        c1.setLogic("and");
        ComplexParam c2 = new ComplexParam();
        c2.setLogic("or");
        c2.getParams().put("project_is_set", new Parameter("eq", null));
        ComplexParam c3 = new ComplexParam();
        c3.setLogic("or");
        c3.getParams().put("project_is_set", new Parameter("eq", (Object)false));
        c1.getComplexParams().add(c2);
        c1.getComplexParams().add(c3);
        queryParam.getComplexParams().add(c1);
        ComplexParam c4 = new ComplexParam();
        c4.setLogic("and");
        ComplexParam c5 = new ComplexParam();
        c5.setLogic("or");
        c5.getParams().put("apply_is_set", new Parameter("eq", null));
        ComplexParam c6 = new ComplexParam();
        c6.setLogic("or");
        c6.getParams().put("apply_is_set", new Parameter("eq", (Object)false));
        c4.getComplexParams().add(c5);
        c4.getComplexParams().add(c6);
        queryParam.getComplexParams().add(c4);
        IPage pageData = this.iBusinessOpportunityService.queryPage(queryParam, false);
        Page result = new Page(pageData.getCurrent(), pageData.getSize(), pageData.getTotal());
        List businessOpportunityVOS = BeanMapper.mapList((Iterable)pageData.getRecords(), BusinessOpportunityVO.class);
        businessOpportunityVOS.forEach(item -> {
            if (null != item.getResultState() && item.getResultState() == 1) {
                item.setResultStateStr("\u5df2\u4e2d\u6807");
            } else {
                item.setResultStateStr("\u672a\u4e2d\u6807");
            }
        });
        result.setRecords(businessOpportunityVOS);
        return CommonResponse.success((String)"\u53c2\u7167\u67e5\u8be2\u6210\u529f\uff01", (Object)result);
    }

    @RequestMapping(value={"/referOpp"})
    @ResponseBody
    public CommonResponse<IPage<BusinessOpportunityVO>> referOpp(@RequestParam(defaultValue="1") Integer pageNumber, @RequestParam(defaultValue="10") Integer pageSize, String searchText) {
        QueryParam queryParam = new QueryParam();
        queryParam.setPageIndex(pageNumber.intValue());
        queryParam.setPageSize(pageSize.intValue());
        queryParam.setSearchText(searchText);
        List fuzzyFields = queryParam.getFuzzyFields();
        fuzzyFields.add("address");
        fuzzyFields.add("area");
        fuzzyFields.add("engineeringName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("engineeringTypeName");
        fuzzyFields.add("infoSourceName");
        fuzzyFields.add("followPersonName");
        fuzzyFields.add("constructionUnitName");
        queryParam.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        queryParam.getParams().put("billState", new Parameter("in", (Object)"1,3"));
        queryParam.getOrderMap().put("createTime", "desc");
        IPage pageData = this.iBusinessOpportunityService.queryPage(queryParam, false);
        Page result = new Page(pageData.getCurrent(), pageData.getSize(), pageData.getTotal());
        List businessOpportunityVOS = BeanMapper.mapList((Iterable)pageData.getRecords(), BusinessOpportunityVO.class);
        businessOpportunityVOS.forEach(item -> {
            if (null != item.getResultState() && item.getResultState() == 1) {
                item.setResultStateStr("\u5df2\u4e2d\u6807");
            } else {
                item.setResultStateStr("\u672a\u4e2d\u6807");
            }
        });
        result.setRecords(businessOpportunityVOS);
        return CommonResponse.success((String)"\u53c2\u7167\u67e5\u8be2\u6210\u529f\uff01", (Object)result);
    }

    @RequestMapping(value={"/updateResultState"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<BusinessOpportunityVO> updateResultState(@RequestBody BusinessOpportunityVO businessOpportunityVO) {
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.eq(BaseEntity::getId, (Object)businessOpportunityVO.getId());
        updateWrapper.set(BusinessOpportunityEntity::getResultState, (Object)businessOpportunityVO.getResultState());
        this.iBusinessOpportunityService.update((Wrapper)updateWrapper);
        return CommonResponse.success((Object)businessOpportunityVO);
    }

    @RequestMapping(value={"/updateProjectIsSet"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<BusinessOpportunityVO> updateProjectIsSet(@RequestBody BusinessOpportunityVO businessOpportunityVO) {
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.eq(BaseEntity::getId, (Object)businessOpportunityVO.getId());
        updateWrapper.set(BusinessOpportunityEntity::getProjectIsSet, (Object)businessOpportunityVO.getProjectIsSet());
        this.iBusinessOpportunityService.update((Wrapper)updateWrapper);
        return CommonResponse.success((Object)businessOpportunityVO);
    }
}

