/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.market.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.center.api.IWarnCenterApi;
import com.ejianc.business.center.vo.EarlyWarnVO;
import com.ejianc.business.market.service.IProjectRegisterService;
import com.ejianc.business.market.vo.ProjectRegisterVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.api.IUserApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/statistics/"})
public class StatisticsMobileController {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IUserApi userApi;
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private IWarnCenterApi warnCenterApi;
    @Autowired
    private IProjectRegisterService projectRegisterService;

    @RequestMapping(value={"/queryProjectViewBoardList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<JSONObject>> queryProjectViewBoardList(@RequestBody QueryParam queryParam) {
        queryParam.getFuzzyFields().add("code");
        queryParam.getFuzzyFields().add("name");
        queryParam.getParams().put("validStatus", new Parameter("eq", (Object)Character.valueOf('0')));
        queryParam.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        queryParam.getOrderMap().put("createTime", "desc");
        Long current = System.currentTimeMillis();
        IPage pageData = this.projectRegisterService.queryPage(queryParam, false);
        this.logger.info("queryPage cost :{}", (Object)(System.currentTimeMillis() - current));
        Page result = new Page();
        return CommonResponse.success((Object)result);
    }

    @RequestMapping(value={"/queryCostByProjectId"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<JSONObject> queryCostByProjectId(@RequestParam(value="projectId") Long projectId) {
        return null;
    }

    @RequestMapping(value={"/queryReceiveInfoByProjectId"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<JSONObject> queryReceiveInfoByProjectId(@RequestParam(value="projectId") Long projectId) {
        return null;
    }

    @RequestMapping(value={"/queryDetailByProjectId"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<JSONObject> queryDetailByProjectId(@RequestParam(value="projectId") Long projectId) {
        JSONObject respJSONObject = new JSONObject();
        ProjectRegisterVO resp = (ProjectRegisterVO)BeanMapper.map((Object)((Object)this.projectRegisterService.queryById(projectId)), ProjectRegisterVO.class);
        CommonResponse membersResp = this.userApi.getEmployeeList(resp.getProjectDepartmentId());
        if (membersResp.isSuccess()) {
            int j;
            String[] list;
            ArrayList<String> role;
            Map o;
            int i;
            ArrayList<Map> trueMembers = new ArrayList<Map>();
            List toProcess = (List)membersResp.getData();
            HashMap<String, Map> mem = new HashMap<String, Map>();
            HashMap roles = new HashMap();
            for (i = 0; i < toProcess.size(); ++i) {
                o = (Map)toProcess.get(i);
                if (o.get("state") == null || !"1".equals(o.get("state").toString())) continue;
                mem.put(o.get("employeeId").toString(), o);
                role = (List)roles.get(o.get("employeeId").toString());
                if (ListUtil.isEmpty((List)role)) {
                    role = new ArrayList<String>();
                    roles.put(o.get("employeeId").toString(), role);
                }
                if (o.get("roleName") == null) continue;
                list = o.get("roleName").toString().split(",");
                for (j = 0; j < list.length; ++j) {
                    if (role.contains(list[j])) continue;
                    role.add(list[j]);
                }
            }
            for (i = 0; i < toProcess.size(); ++i) {
                o = (Map)toProcess.get(i);
                if (o.get("state") == null || !"1".equals(o.get("state").toString())) continue;
                role = (ArrayList<String>)roles.get(o.get("employeeId").toString());
                if (null == o.get("roleName")) continue;
                list = o.get("roleName").toString().split(",");
                for (j = 0; j < list.length; ++j) {
                    if (role.contains(list[j])) continue;
                    role.add(list[j]);
                }
            }
            for (String key : mem.keySet()) {
                Map member = (Map)mem.get(key);
                member.put("roleName", roles.get(key));
                trueMembers.add(member);
            }
            resp.setMembersList(trueMembers);
        } else {
            resp.setMembersList(new ArrayList());
        }
        respJSONObject.put("projectInfo", (Object)resp);
        CommonResponse response = this.warnCenterApi.queryProjectWarnListByOrgId(resp.getProjectDepartmentId());
        if (response.isSuccess()) {
            respJSONObject.put("warnNum", (Object)((List)response.getData()).size());
            respJSONObject.put("warnContent", ((List)response.getData()).stream().map(EarlyWarnVO::getEarlywarnContent).collect(Collectors.toList()));
        } else {
            respJSONObject.put("warnNum", (Object)0);
            respJSONObject.put("warnContent", new ArrayList());
        }
        return CommonResponse.success((Object)respJSONObject);
    }
}

