/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.market.controller.api;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.market.bean.ProjectRegisterEntity;
import com.ejianc.business.market.service.IProjectRegisterService;
import com.ejianc.business.market.vo.ProjectRegisterVO;
import com.ejianc.business.market.vo.ProjectVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/zjkj/projectApi/"})
public class ZjkjProjectApi {
    @Autowired
    private IProjectRegisterService projectService;
    @Autowired
    private IOrgApi orgApi;

    @GetMapping(value={"queryDetailById"})
    public CommonResponse<ProjectVO> queryDetailById(@RequestParam(value="id") Long id) {
        ProjectRegisterEntity entity = (ProjectRegisterEntity)((Object)this.projectService.selectById(id));
        ProjectVO vo = this.getProjectVO((ProjectRegisterVO)BeanMapper.map((Object)((Object)entity), ProjectRegisterVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @PostMapping(value={"queryProjectArray"})
    public CommonResponse<JSONArray> queryProjectArray(@RequestBody List<Long> ids) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"dr", (Object)0);
        queryWrapper.in((Object)"id", ids);
        List entitys = this.projectService.list((Wrapper)queryWrapper);
        List<ProjectVO> voList = this.getProjectVOS(BeanMapper.mapList((Iterable)entitys, ProjectRegisterVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)JSONArray.parseArray((String)JSONObject.toJSONString(voList)));
    }

    @GetMapping(value={"queryProjectByProjectDepartmentId"})
    public CommonResponse<ProjectVO> queryProjectByProjectDepartmentId(@RequestParam(value="projectDepartmentId") Long projectDepartmentId) {
        ProjectRegisterEntity entity = (ProjectRegisterEntity)((Object)this.projectService.selectById(projectDepartmentId));
        if (entity == null) {
            QueryParam param = new QueryParam();
            param.getParams().put("project_department_id", new Parameter("eq", (Object)projectDepartmentId));
            List list = this.projectService.queryList(param, false);
            if (ListUtil.isNotEmpty((List)list)) {
                entity = (ProjectRegisterEntity)((Object)list.get(0));
            }
        }
        if (entity == null) {
            return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", null);
        }
        ProjectVO vo = this.getProjectVO((ProjectRegisterVO)BeanMapper.map((Object)((Object)entity), ProjectRegisterVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)vo);
    }

    @PostMapping(value={"queryProjects"})
    @ResponseBody
    public CommonResponse<List<ProjectVO>> queryProjects(@RequestBody QueryParam param) {
        List orgIds = ((List)this.orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList());
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("project_department_id", new Parameter("in", orgIds));
        List list = this.projectService.queryList(param);
        List<ProjectVO> voList = this.getProjectVOS(BeanMapper.mapList((Iterable)list, ProjectRegisterVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", voList);
    }

    @PostMapping(value={"queryArray"})
    @ResponseBody
    CommonResponse<JSONArray> queryArray(@RequestBody QueryParam param) {
        List orgIds = ((List)this.orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList());
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("project_department_id", new Parameter("in", orgIds));
        List list = this.projectService.queryList(param);
        List<ProjectVO> voList = this.getProjectVOS(BeanMapper.mapList((Iterable)list, ProjectRegisterVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)JSONArray.parseArray((String)JSONObject.toJSONString(voList)));
    }

    @GetMapping(value={"queryProjectsByOrgId"})
    @ResponseBody
    public CommonResponse<List<ProjectVO>> queryProjectsByOrgId(@RequestParam(value="orgId") Long orgId) {
        List orgIds = ((List)this.orgApi.findChildrenByParentId(orgId).getData()).stream().map(BaseVO::getId).collect(Collectors.toList());
        QueryParam param = new QueryParam();
        param.getParams().put("status", new Parameter("eq", (Object)2));
        param.getParams().put("valid_status", new Parameter("eq", (Object)0));
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("project_department_id", new Parameter("in", orgIds));
        List list = this.projectService.queryList(param);
        List<ProjectVO> voList = this.getProjectVOS(BeanMapper.mapList((Iterable)list, ProjectRegisterVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", voList);
    }

    @GetMapping(value={"queryArrayByOrgId"})
    @ResponseBody
    CommonResponse<JSONArray> queryArrayByOrgId(@RequestParam(value="orgId") Long orgId) {
        List orgIds = ((List)this.orgApi.findChildrenByParentId(orgId).getData()).stream().map(BaseVO::getId).collect(Collectors.toList());
        QueryParam param = new QueryParam();
        param.getParams().put("status", new Parameter("eq", (Object)2));
        param.getParams().put("valid_status", new Parameter("eq", (Object)0));
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("project_department_id", new Parameter("in", orgIds));
        List list = this.projectService.queryList(param);
        List<ProjectVO> voList = this.getProjectVOS(BeanMapper.mapList((Iterable)list, ProjectRegisterVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)JSONArray.parseArray((String)JSONObject.toJSONString(voList)));
    }

    /*
     * Enabled aggressive block sorting
     */
    @RequestMapping(value={"/refProjectData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<ProjectVO>> refProjectData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam queryParam;
        block17: {
            queryParam = new QueryParam();
            queryParam.setPageSize(pageSize.intValue());
            queryParam.setPageIndex(pageNumber.intValue());
            queryParam.setSearchText(searchText);
            queryParam.setSearchObject(searchObject);
            List fuzzyFields = queryParam.getFuzzyFields();
            fuzzyFields.add("code");
            fuzzyFields.add("name");
            fuzzyFields.add("orgName");
            fuzzyFields.add("shortName");
            fuzzyFields.add("createUserName");
            queryParam.getParams().put("validStatus", new Parameter("eq", (Object)Character.valueOf('0')));
            queryParam.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
            queryParam.getOrderMap().put("createTime", "desc");
            ArrayList commonOrgIds = new ArrayList();
            ArrayList departmentIds = new ArrayList();
            Long orgId = InvocationInfoProxy.getOrgId();
            Boolean tenantLeave = false;
            Boolean mobileLeave = false;
            if (StringUtils.isNotBlank((CharSequence)condition)) {
                Map conditionMap = (Map)JSONObject.parseObject((String)condition, Map.class);
                if (null != conditionMap.get("orgId")) {
                    orgId = Long.valueOf(conditionMap.get("orgId").toString());
                }
                if (null != conditionMap.get("tenantLeave")) {
                    tenantLeave = true;
                }
                if (null != conditionMap.get("mobileLeave")) {
                    mobileLeave = true;
                }
                if (null != conditionMap.get("province")) {
                    queryParam.getParams().put("province", new Parameter("eq", conditionMap.get("province")));
                }
                if (null != conditionMap.get("city")) {
                    queryParam.getParams().put("city", new Parameter("eq", conditionMap.get("city")));
                }
                if (null != conditionMap.get("region")) {
                    queryParam.getParams().put("region", new Parameter("eq", conditionMap.get("region")));
                }
                if (null != conditionMap.get("projectId")) {
                    queryParam.getParams().put("id", new Parameter("ne", conditionMap.get("projectId")));
                }
            }
            if (mobileLeave.booleanValue()) {
                CommonResponse response = this.orgApi.findProjectOrgsByUserId(InvocationInfoProxy.getUserid());
                if (response.isSuccess() && ListUtil.isNotEmpty((List)((List)response.getData()))) {
                    queryParam.getParams().put("projectDepartmentId", new Parameter("in", ((List)response.getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
                    break block17;
                } else {
                    Page pageData = new Page((long)pageNumber.intValue(), (long)pageSize.intValue(), 0L);
                    return CommonResponse.success((String)"\u8be5\u7528\u6237\u6ca1\u6709\u4efb\u4f55\u9879\u76ee\u6743\u9650\uff01", (Object)pageData);
                }
            }
            if (!tenantLeave.booleanValue()) {
                CommonResponse orgListResp = this.orgApi.findChildrenByParentId(orgId);
                if (!orgListResp.isSuccess()) {
                    Page pageData = new Page((long)pageNumber.intValue(), (long)pageSize.intValue(), 0L);
                    return CommonResponse.success((String)"\u67e5\u8be2\u6570\u8868\u53c2\u7167\u5931\u8d25\uff0c\u9879\u76ee\u7ec4\u7ec7\u4fe1\u606f\u67e5\u8be2\u5931\u8d25\uff01", (Object)pageData);
                }
                List orgList = (List)orgListResp.getData();
                if (CollectionUtils.isNotEmpty((Collection)orgList)) {
                    orgList.forEach(orgVO -> {
                        if (5 == orgVO.getOrgType()) {
                            departmentIds.add(orgVO.getId());
                        } else {
                            commonOrgIds.add(orgVO.getId());
                        }
                    });
                    if (CollectionUtils.isNotEmpty(commonOrgIds)) {
                        queryParam.getParams().put("orgId", new Parameter("in", commonOrgIds));
                    } else if (CollectionUtils.isNotEmpty(departmentIds)) {
                        queryParam.getParams().put("projectDepartmentId", new Parameter("eq", departmentIds.get(0)));
                    }
                }
            }
        }
        IPage page = this.projectService.queryPage(queryParam, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(this.getProjectVOS(BeanMapper.mapList((Iterable)page.getRecords(), ProjectRegisterVO.class)));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    public ProjectVO getProjectVO(ProjectRegisterVO vo) {
        ProjectVO map = (ProjectVO)BeanMapper.map((Object)vo, ProjectVO.class);
        map.setProjectName(vo.getName());
        map.setBillCode(vo.getCode());
        map.setLeader(vo.getProjectManager());
        map.setStartDate(vo.getPlannedCommencementDate());
        map.setEndDate(vo.getPlannedFinishDate());
        map.setContractualModel(vo.getEngineeringType());
        return map;
    }

    public List<ProjectVO> getProjectVOS(List<ProjectRegisterVO> vos) {
        ArrayList<ProjectVO> list = new ArrayList<ProjectVO>();
        for (ProjectRegisterVO vo : vos) {
            ProjectVO projectVO = this.getProjectVO(vo);
            list.add(projectVO);
        }
        return list;
    }
}

