/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.market.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.market.bean.BusinessOpportunityEntity;
import com.ejianc.business.market.bean.ProjectRegisterEntity;
import com.ejianc.business.market.mapper.ProjectRegisterMapper;
import com.ejianc.business.market.service.IBusinessOpportunityService;
import com.ejianc.business.market.service.IProjectRegisterService;
import com.ejianc.business.market.vo.ProjectBidPeopleVO;
import com.ejianc.business.market.vo.ProjectRegisterVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.orgcenter.api.IEmployeeApi;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.api.IUserApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.permission.vo.RoleUserRelationVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.wzxtUserProject.api.IWzxtUserProjectRelationApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.ComplexParam;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.billState.service.CommonUpdateBillStateService;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.support.idworker.util.IdWorker;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="projectRegisterService")
public class ProjectRegisterServiceImpl
extends BaseServiceImpl<ProjectRegisterMapper, ProjectRegisterEntity>
implements IProjectRegisterService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private final String DEFAULT_RULE_CODE = "marketProjectRegister";
    @Autowired
    private ProjectRegisterMapper projectRegisterMapper;
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private IBusinessOpportunityService businessOpportunityService;
    @Autowired
    private IWzxtUserProjectRelationApi wzxtUserProjectRelationApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private IEmployeeApi employeeApi;
    @Autowired
    private IUserApi userApi;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private CommonUpdateBillStateService commonUpdateBillStateService;

    @Override
    public ProjectRegisterEntity queryById(Long id) {
        return (ProjectRegisterEntity)((Object)this.projectRegisterMapper.selectById(id));
    }

    @Override
    public CommonResponse<ProjectRegisterVO> saveProject(ProjectRegisterVO projectRegisterVO) {
        CommonResponse resp;
        CommonResponse resp2;
        Map<String, Object> memberMap;
        ProjectRegisterEntity saveEntity;
        projectRegisterVO.setName(projectRegisterVO.getName().replaceAll(" ", ""));
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(BaseEntity::getTenantId, (Object)InvocationInfoProxy.getTenantid());
        queryWrapper.eq(ProjectRegisterEntity::getName, (Object)projectRegisterVO.getName());
        queryWrapper.ne(null != projectRegisterVO.getId(), BaseEntity::getId, (Object)projectRegisterVO.getId());
        int count = this.count((Wrapper)queryWrapper);
        if (count > 0) {
            return CommonResponse.error((String)"\u5f53\u524d\u9879\u76ee\u540d\u79f0\u5df2\u4f7f\u7528\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\uff01");
        }
        if (StringUtils.isNotBlank((CharSequence)projectRegisterVO.getCode())) {
            projectRegisterVO.setCode(projectRegisterVO.getCode().replaceAll(" ", ""));
            boolean codeCheck = this.codeUsedCheck(projectRegisterVO);
            if (codeCheck) {
                return CommonResponse.error((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u7f16\u7801\u91cd\u590d\uff01");
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)projectRegisterVO.getBidPeopleList())) {
            List bidPeopleList = projectRegisterVO.getBidPeopleList();
            for (ProjectBidPeopleVO bidPeopleVO : bidPeopleList) {
                bidPeopleVO.setEndDateOne(bidPeopleVO.getChangeDateTwo());
                bidPeopleVO.setEndDateTwo(bidPeopleVO.getChangeDateThree());
                bidPeopleVO.setEndDateThree(bidPeopleVO.getChangeDateFour());
            }
        }
        if (StringUtils.isNotBlank((CharSequence)(saveEntity = (ProjectRegisterEntity)((Object)BeanMapper.map((Object)projectRegisterVO, ProjectRegisterEntity.class))).getArea())) {
            String regex = "((?<provinceAndCity>[^\u5e02]+\u5e02|.*?\u81ea\u6cbb\u5dde|.*?\u533a|.*\u53bf)(?<town>[^\u533a]+\u533a|.*?\u5e02|.*?\u53bf|.*?\u8def|.*?\u8857|.*?\u9053|.*?\u9547|.*?\u65d7)(?<detailAddress>.*))";
            Matcher matcher = Pattern.compile(regex).matcher(saveEntity.getArea());
            while (matcher.find()) {
                saveEntity.setRegion(matcher.group("town"));
                String regex2 = "((?<province>[^\u7701]+\u7701|.+\u81ea\u6cbb\u533a|\u4e0a\u6d77\u5e02|\u5317\u4eac\u5e02|\u5929\u6d25\u5e02|\u91cd\u5e86\u5e02|\u4e0a\u6d77|\u5317\u4eac|\u5929\u6d25|\u91cd\u5e86|\u9999\u6e2f\u7279\u522b\u884c\u653f\u533a|\u6fb3\u95e8\u7279\u522b\u884c\u653f\u533a)(?<city>.*))";
                Matcher matcher2 = Pattern.compile(regex2).matcher(matcher.group("provinceAndCity"));
                while (matcher2.find()) {
                    saveEntity.setProvince(matcher2.group("province"));
                    String city = matcher2.group("city");
                    if (StringUtils.isBlank((CharSequence)city)) {
                        saveEntity.setCity(saveEntity.getProvince());
                        continue;
                    }
                    saveEntity.setCity(matcher2.group("city"));
                }
            }
        }
        OrgVO projectDepartment = null;
        BusinessOpportunityEntity buOpr = null;
        boolean storeFlag = false;
        boolean add = false;
        if (null != projectRegisterVO.getId()) {
            ProjectRegisterEntity dbEntity = this.queryById(projectRegisterVO.getId());
            saveEntity.setManageChargeRatio(dbEntity.getManageChargeRatio());
            saveEntity.setTenantId(dbEntity.getTenantId());
            saveEntity.setCreateTime(dbEntity.getCreateTime());
            saveEntity.setCreateUserCode(dbEntity.getCreateUserCode());
            saveEntity.setSyncEsFlag(dbEntity.getSyncEsFlag());
            saveEntity.setDr(dbEntity.getDr());
            if (!projectRegisterVO.getOrgId().equals(dbEntity.getOrgId())) {
                projectDepartment = (OrgVO)this.getRespData(this.orgApi.getOneById(dbEntity.getProjectDepartmentId()), true, "\u4fdd\u5b58\u5931\u8d25\uff0c\u67e5\u8be2\u6240\u5c5e\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
                projectDepartment.setParentId(projectRegisterVO.getOrgId());
            }
            if (!projectRegisterVO.getName().equals(dbEntity.getName())) {
                if (null == projectDepartment) {
                    projectDepartment = (OrgVO)this.getRespData(this.orgApi.getOneById(dbEntity.getProjectDepartmentId()), true, "\u4fdd\u5b58\u5931\u8d25\uff0c\u67e5\u8be2\u6240\u5c5e\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
                }
                projectDepartment.setName(projectRegisterVO.getName());
                projectDepartment.setShortName(projectRegisterVO.getName());
            }
            if (!projectRegisterVO.getStatus().equals(dbEntity.getStatus()) && null == projectDepartment) {
                projectDepartment = (OrgVO)this.getRespData(this.orgApi.getOneById(dbEntity.getProjectDepartmentId()), true, "\u4fdd\u5b58\u5931\u8d25\uff0c\u67e5\u8be2\u6240\u5c5e\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
            }
        } else {
            storeFlag = true;
            add = true;
            projectDepartment = this.generateProjectDepartment(projectRegisterVO, false);
            saveEntity.setProjectDepartmentId(projectDepartment.getId());
            projectRegisterVO.setProjectDepartmentId(projectDepartment.getId());
            UserContext userContext = this.sessionManager.getUserContext();
            saveEntity.setCreateUserName(userContext.getUserName());
            saveEntity.setValidStatus("0");
        }
        if (StringUtils.isBlank((CharSequence)projectRegisterVO.getCode())) {
            saveEntity.setCode(this.getAutoCode());
        }
        if (null != projectDepartment) {
            projectDepartment.setSourceId(projectRegisterVO.getSourceId());
            if ("2".equals(saveEntity.getStatus())) {
                projectDepartment.setProjectState(Integer.valueOf(1));
            } else {
                projectDepartment.setProjectState(Integer.valueOf(2));
            }
            CommonResponse resp3 = this.orgApi.saveOrgInfo(projectDepartment);
            if (!resp3.isSuccess()) {
                throw new BusinessException("\u4fdd\u5b58\u5931\u8d25\uff0c\u4fdd\u5b58\u9879\u76ee\u90e8\u4fe1\u606f\u51fa\u9519: " + resp3.getMsg());
            }
        }
        if (!(memberMap = this.getMemberMap(projectRegisterVO)).isEmpty() && !(resp2 = this.employeeApi.manageProjectMembers(memberMap)).isSuccess()) {
            throw new BusinessException("\u4fdd\u5b58\u5931\u8d25\uff0c\u65b0\u589e\u6210\u5458\u51fa\u9519: " + resp2.getMsg());
        }
        Map<String, Object> memberUpdateMap = this.getMemberUpdateMap(projectRegisterVO);
        if (!memberUpdateMap.isEmpty() && !(resp = this.employeeApi.manageUpdateProjectMembers(memberUpdateMap)).isSuccess()) {
            throw new BusinessException("\u4fdd\u5b58\u5931\u8d25\uff0c\u65b0\u589e\u6210\u5458\u51fa\u9519: " + resp.getMsg());
        }
        super.saveOrUpdate((Object)saveEntity, false);
        if (null != projectRegisterVO.getBusOpprId()) {
            buOpr = this.businessOpportunityService.queryDetail(projectRegisterVO.getBusOpprId());
            buOpr.setProjectIsSet(true);
            buOpr.setProjectSetId(saveEntity.getId());
            this.businessOpportunityService.saveOrUpdate((Object)buOpr, false);
        }
        if (null != saveEntity.getApplyId()) {
            this.attachmentApi.copyFiles(String.valueOf(saveEntity.getApplyId()), "BT202407000002", "projectApplyImage", String.valueOf(saveEntity.getId()), "BT200519000000002", "projectImage", false);
        }
        if (storeFlag) {
            this.generateStore(saveEntity);
        }
        if (!add) {
            this.commonUpdateBillStateService.updateQuoteData(saveEntity.getId(), "BT200519000000002");
        }
        resp = (ProjectRegisterVO)BeanMapper.map((Object)((Object)saveEntity), ProjectRegisterVO.class);
        List list = (List)this.getRespData(this.userApi.getEmployeeList(resp.getProjectDepartmentId()), false, null);
        for (Map map : list) {
            JSONObject jsonObj = new JSONObject();
            jsonObj.put("id", map.get("postId"));
            jsonObj.put("name", map.get("postName"));
            map.put("postId", jsonObj);
        }
        resp.setMembersList(list);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6210\u529f\uff01", (Object)resp);
    }

    private String getAutoCode() {
        ProjectRegisterVO project = new ProjectRegisterVO();
        while (null == project.getCode()) {
            String code = this.getRespData(this.billCodeApi.getCodeBatchByRuleCode("marketProjectRegister", InvocationInfoProxy.getTenantid()), true, "\u4fdd\u5b58\u5931\u8d25\uff0c\u81ea\u52a8\u751f\u6210\u7f16\u7801\u5931\u8d25\uff01").toString();
            project.setCode(code);
            boolean checkResult = this.codeUsedCheck(project);
            if (!checkResult) continue;
            project.setCode(null);
        }
        return project.getCode();
    }

    private void generateStore(ProjectRegisterEntity saveEntity) {
    }

    @Override
    public void saveImportProject(List<ProjectRegisterVO> proList) {
        ArrayList<ProjectRegisterEntity> saveProList = new ArrayList<ProjectRegisterEntity>();
        ArrayList<OrgVO> saveDepartmentList = new ArrayList<OrgVO>();
        ProjectRegisterEntity saveEntity = null;
        OrgVO projectDepartment = null;
        if (CollectionUtils.isNotEmpty(proList)) {
            Long codeCount = proList.stream().filter(item -> StringUtils.isBlank((CharSequence)item.getCode())).count();
            List billCode = (List)this.getRespData(this.billCodeApi.getCodeBatchByRuleCode("marketProjectRegister", InvocationInfoProxy.getTenantid(), codeCount.intValue()), true, "\u5bfc\u5165\u6570\u636e\u4fdd\u5b58\u5931\u8d25\uff0c\u81ea\u52a8\u751f\u6210\u7f16\u7801\u5931\u8d25\uff01");
            int i = 0;
            for (ProjectRegisterVO pro : proList) {
                saveEntity = (ProjectRegisterEntity)((Object)BeanMapper.map((Object)pro, ProjectRegisterEntity.class));
                projectDepartment = this.generateProjectDepartment(pro, false);
                saveEntity.setProjectDepartmentId(projectDepartment.getId());
                UserContext userContext = this.sessionManager.getUserContext();
                saveEntity.setCreateUserName(userContext.getUserName());
                saveEntity.setValidStatus("0");
                if (StringUtils.isBlank((CharSequence)saveEntity.getCode())) {
                    saveEntity.setCode((String)billCode.get(i++));
                }
                saveDepartmentList.add(projectDepartment);
                saveProList.add(saveEntity);
            }
            CommonResponse saveResp = this.orgApi.saveProOrgList(saveDepartmentList);
            if (!saveResp.isSuccess()) {
                this.logger.error("\u5bfc\u5165\u6570\u636e\u4fdd\u5b58\u5931\u8d25\uff0c\u4fdd\u5b58\u9879\u76ee\u90e8\u4fe1\u606f\u5931\u8d25\uff1a" + saveResp.getMsg());
                throw new BusinessException("\u5bfc\u5165\u6570\u636e\u4fdd\u5b58\u5931\u8d25\uff0c\u4fdd\u5b58\u9879\u76ee\u90e8\u4fe1\u606f\u5931\u8d25\uff01");
            }
            super.saveBatch(saveProList);
            for (ProjectRegisterEntity entity : saveProList) {
                this.generateStore(entity);
            }
        }
    }

    @Override
    public Map<String, Integer> countProjectNum(QueryParam queryParam) {
        HashMap<String, Integer> resp = new HashMap<String, Integer>();
        QueryWrapper queryWrapper = null;
        ComplexParam c1 = new ComplexParam();
        c1.setLogic("and");
        c1.getParams().put("status", new Parameter("eq", (Object)"2"));
        queryParam.getComplexParams().add(c1);
        queryWrapper = ProjectRegisterServiceImpl.changeToQueryWrapper((QueryParam)queryParam);
        resp.put("buildingNum", super.count((Wrapper)queryWrapper));
        queryParam.getComplexParams().remove(c1);
        c1.getParams().put("status", new Parameter("eq", (Object)"3"));
        queryParam.getComplexParams().add(c1);
        queryWrapper = ProjectRegisterServiceImpl.changeToQueryWrapper((QueryParam)queryParam);
        resp.put("finishNum", super.count((Wrapper)queryWrapper));
        return resp;
    }

    @Override
    public boolean codeUsedCheck(ProjectRegisterVO project) {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        queryParam.getParams().put("code", new Parameter("eq", (Object)project.getCode()));
        queryParam.getParams().put("id", new Parameter("ne", (Object)project.getId()));
        List proList = super.queryList(queryParam, false);
        return CollectionUtils.isNotEmpty((Collection)proList);
    }

    @Override
    public void changeValidStatus(ProjectRegisterVO projectRegisterVO) {
        ProjectRegisterEntity e = (ProjectRegisterEntity)((Object)super.selectById((Serializable)projectRegisterVO.getId()));
        CommonResponse orgResp = this.orgApi.getOneById(e.getProjectDepartmentId());
        if (!orgResp.isSuccess()) {
            throw new BusinessException("\u66f4\u6539\u9879\u76ee\u72b6\u6001\u5931\u8d25\uff0c\u83b7\u53d6\u9879\u76ee\u90e8\u4fe1\u606f\u5931\u8d25\uff01");
        }
        OrgVO department = (OrgVO)orgResp.getData();
        if ("1".equals(projectRegisterVO.getValidStatus())) {
            department.setState(Integer.valueOf(0));
            e.setValidStatus(projectRegisterVO.getValidStatus());
        } else if ("0".equals(projectRegisterVO.getValidStatus())) {
            department.setState(Integer.valueOf(1));
            e.setValidStatus(projectRegisterVO.getValidStatus());
        } else {
            throw new BusinessException("\u66f4\u6539\u9879\u76ee\u72b6\u6001\u5931\u8d25\uff0c\u975e\u6cd5\u7684\u9879\u76ee\u72b6\u6001\uff01");
        }
        CommonResponse resp = this.orgApi.saveOrgInfo(department);
        if (!resp.isSuccess()) {
            throw new BusinessException("\u66f4\u6539\u9879\u76ee\u72b6\u6001\u5931\u8d25\u5931\u8d25\uff0c\u66f4\u65b0\u9879\u76ee\u90e8\u4fe1\u606f\u51fa\u9519: " + resp.getMsg());
        }
        super.saveOrUpdate((Object)e);
    }

    @Override
    public List<Long> queryProIdsByProperties(QueryParam queryParam, boolean queryNewSignedCurYear) {
        QueryWrapper queryWrapper = ProjectRegisterServiceImpl.changeToQueryWrapper((QueryParam)queryParam);
        queryWrapper.select(new String[]{"id"});
        queryWrapper.eq((Object)"dr", (Object)0);
        queryWrapper.apply(queryNewSignedCurYear, " date_format(sign_date, '%Y') = date_format(now(), '%Y')", new Object[0]);
        List result = ((ProjectRegisterMapper)this.baseMapper).selectObjs((Wrapper)queryWrapper);
        ArrayList<Long> ids = new ArrayList<Long>();
        result.forEach(obj -> ids.add(Long.valueOf(obj.toString())));
        return ids;
    }

    private OrgVO generateProjectDepartment(ProjectRegisterVO projectRegisterVO, boolean isSyncProject) {
        CommonResponse response = this.orgApi.getOneById(projectRegisterVO.getOrgId());
        OrgVO parentOrg = null;
        if (!response.isSuccess()) {
            throw new BusinessException("\u4fdd\u5b58\u9879\u76ee\u4fe1\u606f\u5931\u8d25\uff0c\u67e5\u8be2\u9879\u76ee\u6240\u5c5e\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25: " + response.getMsg());
        }
        parentOrg = (OrgVO)response.getData();
        if (null == parentOrg) {
            throw new BusinessException("\u4fdd\u5b58\u9879\u76ee\u4fe1\u606f\u5931\u8d25\uff0c\u9879\u76ee\u6240\u5c5e\u7ec4\u7ec7\u4fe1\u606f\u4e0d\u5b58\u5728\u3002");
        }
        OrgVO projectDepartment = new OrgVO();
        projectDepartment.setId(Long.valueOf(IdWorker.getId()));
        projectDepartment.setParentId(projectRegisterVO.getOrgId());
        projectDepartment.setTenantId(parentOrg.getTenantId());
        projectDepartment.setEnterpriseId(parentOrg.getEnterpriseId());
        projectDepartment.setIsParent(Boolean.valueOf(false));
        projectDepartment.setName(projectRegisterVO.getName());
        projectDepartment.setShortName(projectRegisterVO.getName());
        projectDepartment.setSourceId(projectRegisterVO.getSourceId());
        projectDepartment.setState(Integer.valueOf(1));
        projectDepartment.setOrgType(OrgVO.ORG_TYPE_DEPARTMENT);
        if (isSyncProject) {
            projectDepartment.setSourceId(projectRegisterVO.getSourceId());
        }
        return projectDepartment;
    }

    private Object getRespData(CommonResponse resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    private Map<String, Object> getMemberMap(ProjectRegisterVO projectRegisterVO) {
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        if (CollectionUtils.isNotEmpty((Collection)projectRegisterVO.getMembersList())) {
            JSONObject jsonObject;
            HashMap<String, ArrayList<RoleUserRelationVO>> moveMap = new HashMap<String, ArrayList<RoleUserRelationVO>>();
            HashMap<String, ArrayList<RoleUserRelationVO>> parttimeMap = new HashMap<String, ArrayList<RoleUserRelationVO>>();
            List<Object> relationList = null;
            RoleUserRelationVO tmp = null;
            for (Map member : projectRegisterVO.getMembersList()) {
                JSONObject jsonObject2;
                if (null == member.get("isAdd") || !"true".equals(member.get("isAdd"))) continue;
                tmp = new RoleUserRelationVO();
                tmp.setUserId(null != member.get("userId") ? Long.valueOf(member.get("userId").toString()) : null);
                tmp.setJobId(null != member.get("jobId") ? Long.valueOf(member.get("jobId").toString()) : null);
                tmp.setAuthOrgId(projectRegisterVO.getProjectDepartmentId());
                tmp.setEmployeeId(null != member.get("employeeId") ? Long.valueOf(member.get("employeeId").toString()) : null);
                tmp.setRoleId(null != member.get("roleId") ? Long.valueOf(member.get("roleId").toString()) : null);
                if (member.get("postId") != null && (jsonObject2 = (JSONObject)JSONObject.toJSON(member.get("postId"))).get((Object)"id") != null) {
                    tmp.setPostId(Long.valueOf(Long.parseLong(jsonObject2.get((Object)"id").toString())));
                }
                if ("move".equals(member.get("type").toString())) {
                    relationList = (ArrayList<RoleUserRelationVO>)moveMap.get(tmp.getEmployeeId());
                    if (null == relationList) {
                        relationList = new ArrayList<RoleUserRelationVO>();
                    }
                    relationList.add(tmp);
                    moveMap.put(tmp.getEmployeeId().toString(), (ArrayList<RoleUserRelationVO>)relationList);
                    continue;
                }
                relationList = (List)parttimeMap.get(tmp.getEmployeeId());
                if (null == relationList) {
                    relationList = new ArrayList();
                }
                relationList.add(tmp);
                parttimeMap.put(tmp.getEmployeeId().toString(), (ArrayList<RoleUserRelationVO>)relationList);
            }
            if (!moveMap.isEmpty()) {
                HashMap<String, Object> moveData = new HashMap<String, Object>();
                if (moveData.get("postId") != null) {
                    jsonObject = new JSONObject();
                    jsonObject = (JSONObject)moveMap.get("postId");
                    if (jsonObject.get((Object)"id") != null) {
                        moveData.put("postId", jsonObject.get((Object)"id"));
                    }
                }
                moveData.put("orgId", projectRegisterVO.getProjectDepartmentId());
                moveData.put("detail", moveMap);
                dataMap.put("moveMembers", moveData);
            }
            if (!parttimeMap.isEmpty()) {
                HashMap<String, Object> parttimeData = new HashMap<String, Object>();
                parttimeData.put("orgId", projectRegisterVO.getProjectDepartmentId());
                if (parttimeData.get("postId") != null) {
                    jsonObject = new JSONObject();
                    jsonObject = (JSONObject)moveMap.get("postId");
                    if (jsonObject.get((Object)"id") != null) {
                        parttimeData.put("postId", jsonObject.get((Object)"id"));
                    }
                }
                parttimeData.put("detail", parttimeMap);
                dataMap.put("parttimeMembers", parttimeData);
            }
        }
        return dataMap;
    }

    private Map<String, Object> getMemberUpdateMap(ProjectRegisterVO projectRegisterVO) {
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        if (CollectionUtils.isNotEmpty((Collection)projectRegisterVO.getMembersList())) {
            HashMap moveMap = new HashMap();
            HashMap<String, ArrayList<RoleUserRelationVO>> parttimeMap = new HashMap<String, ArrayList<RoleUserRelationVO>>();
            ArrayList<RoleUserRelationVO> relationList = null;
            RoleUserRelationVO tmp = null;
            for (Map member : projectRegisterVO.getMembersList()) {
                if (null == member.get("rowState") || !"edit".equals(member.get("rowState"))) continue;
                tmp = new RoleUserRelationVO();
                tmp.setJobId(null != member.get("jobId") ? Long.valueOf(member.get("jobId").toString()) : null);
                tmp.setEmployeeId(null != member.get("employeeId") ? Long.valueOf(member.get("employeeId").toString()) : null);
                JSONObject jsonObject = new JSONObject();
                if (member.get("postId") != null && (jsonObject = (JSONObject)JSONObject.toJSON(member.get("postId"))).get((Object)"id") != null) {
                    tmp.setPostId(Long.valueOf(Long.parseLong(jsonObject.get((Object)"id").toString())));
                }
                if (null == (relationList = (ArrayList<RoleUserRelationVO>)parttimeMap.get(tmp.getEmployeeId()))) {
                    relationList = new ArrayList<RoleUserRelationVO>();
                }
                relationList.add(tmp);
                parttimeMap.put(tmp.getEmployeeId().toString(), relationList);
            }
            if (!parttimeMap.isEmpty()) {
                dataMap.put("detail", parttimeMap);
            }
        }
        return dataMap;
    }

    @Override
    public CommonResponse<List<ProjectRegisterVO>> queryProjectByUserId(Long userId) {
        CommonResponse list = this.wzxtUserProjectRelationApi.queryProjectByUserId(userId);
        if (list.isSuccess()) {
            if (list.getData() != null && ((List)list.getData()).size() > 0) {
                ArrayList projectIds = new ArrayList();
                ((List)list.getData()).forEach(e -> projectIds.add(e.getProjectId()));
                List entitys = (List)this.listByIds(projectIds);
                if (entitys != null && entitys.size() > 0) {
                    return CommonResponse.success((Object)BeanMapper.mapList((Iterable)entitys, ProjectRegisterVO.class));
                }
            }
        } else {
            return CommonResponse.error((String)list.getMsg());
        }
        return CommonResponse.success();
    }

    @Override
    public ProjectRegisterVO saveSyncProject(ProjectRegisterVO projectRegisterVO) {
        CommonResponse resp;
        Map<String, Object> memberMap;
        ProjectRegisterEntity saveEntity = (ProjectRegisterEntity)((Object)BeanMapper.map((Object)projectRegisterVO, ProjectRegisterEntity.class));
        if (StringUtils.isNotBlank((CharSequence)saveEntity.getArea())) {
            String regex = "((?<provinceAndCity>[^\u5e02]+\u5e02|.*?\u81ea\u6cbb\u5dde|.*?\u533a|.*\u53bf)(?<town>[^\u533a]+\u533a|.*?\u5e02|.*?\u53bf|.*?\u8def|.*?\u8857|.*?\u9053|.*?\u9547|.*?\u65d7)(?<detailAddress>.*))";
            Matcher matcher = Pattern.compile(regex).matcher(saveEntity.getArea());
            while (matcher.find()) {
                saveEntity.setRegion(matcher.group("town"));
                String regex2 = "((?<province>[^\u7701]+\u7701|.+\u81ea\u6cbb\u533a|\u4e0a\u6d77\u5e02|\u5317\u4eac\u5e02|\u5929\u6d25\u5e02|\u91cd\u5e86\u5e02|\u4e0a\u6d77|\u5317\u4eac|\u5929\u6d25|\u91cd\u5e86|\u9999\u6e2f\u7279\u522b\u884c\u653f\u533a|\u6fb3\u95e8\u7279\u522b\u884c\u653f\u533a)(?<city>.*))";
                Matcher matcher2 = Pattern.compile(regex2).matcher(matcher.group("provinceAndCity"));
                while (matcher2.find()) {
                    saveEntity.setProvince(matcher2.group("province"));
                    String city = matcher2.group("city");
                    if (StringUtils.isBlank((CharSequence)city)) {
                        saveEntity.setCity(saveEntity.getProvince());
                        continue;
                    }
                    saveEntity.setCity(matcher2.group("city"));
                }
            }
        }
        OrgVO projectDepartment = null;
        BusinessOpportunityEntity buOpr = null;
        boolean storeFlag = false;
        if (null != projectRegisterVO.getId()) {
            ProjectRegisterEntity dbEntity = this.queryById(projectRegisterVO.getId());
            saveEntity.setManageChargeRatio(dbEntity.getManageChargeRatio());
            saveEntity.setCode(dbEntity.getCode());
            saveEntity.setTenantId(dbEntity.getTenantId());
            saveEntity.setCreateTime(dbEntity.getCreateTime());
            saveEntity.setCreateUserCode(dbEntity.getCreateUserCode());
            saveEntity.setSyncEsFlag(dbEntity.getSyncEsFlag());
            saveEntity.setDr(dbEntity.getDr());
            if (!projectRegisterVO.getOrgId().equals(dbEntity.getOrgId())) {
                projectDepartment = (OrgVO)this.getRespData(this.orgApi.getOneById(dbEntity.getProjectDepartmentId()), true, "\u4fdd\u5b58\u5931\u8d25\uff0c\u67e5\u8be2\u6240\u5c5e\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
                projectDepartment.setParentId(projectRegisterVO.getOrgId());
            }
            if (!projectRegisterVO.getName().equals(dbEntity.getName())) {
                if (null == projectDepartment) {
                    projectDepartment = (OrgVO)this.getRespData(this.orgApi.getOneById(dbEntity.getProjectDepartmentId()), true, "\u4fdd\u5b58\u5931\u8d25\uff0c\u67e5\u8be2\u6240\u5c5e\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
                }
                projectDepartment.setName(projectRegisterVO.getName());
                projectDepartment.setShortName(projectRegisterVO.getName());
            }
            if (StringUtils.isNotBlank((CharSequence)projectRegisterVO.getCode()) && !dbEntity.getCode().equals(projectRegisterVO.getCode())) {
                this.logger.info("\u9879\u76ee[id-{}]\u7f16\u7801\u7531-{}\u6539\u4e3a-{}", new Object[]{dbEntity.getId(), dbEntity.getCode(), projectRegisterVO.getCode()});
                saveEntity.setCode(projectRegisterVO.getCode());
            }
        } else {
            storeFlag = true;
            projectDepartment = this.generateProjectDepartment(projectRegisterVO, true);
            saveEntity.setProjectDepartmentId(projectDepartment.getId());
            UserContext userContext = this.sessionManager.getUserContext();
            saveEntity.setCreateUserName(userContext.getUserName());
            saveEntity.setValidStatus("0");
            saveEntity.setStatus("2");
            if (null != projectRegisterVO.getBusOpprId()) {
                buOpr = this.businessOpportunityService.queryDetail(projectRegisterVO.getBusOpprId());
                if (null != buOpr.getProjectIsSet() && buOpr.getProjectIsSet().booleanValue()) {
                    throw new BusinessException("\u65b0\u589e\u5931\u8d25\uff0c\u8be5\u5546\u673a\u5df2\u7acb\u9879\uff01");
                }
                saveEntity.setArea(buOpr.getArea());
                saveEntity.setAddress(buOpr.getAddress());
                saveEntity.setInvestor(buOpr.getInvestor());
                saveEntity.setFundsSource(buOpr.getFundsSource());
                saveEntity.setCostTotal(buOpr.getCostTotal());
                saveEntity.setBiddingForm(buOpr.getBiddingForm());
                saveEntity.setBiddingFormName(buOpr.getBiddingFormName());
                saveEntity.setPlannedCommencementDate(buOpr.getPlannedCommencementDate());
                saveEntity.setPlannedFinishDate(buOpr.getPlannedFinishDate());
                saveEntity.setBuiltArea(buOpr.getBuiltArea());
                saveEntity.setStructureType(buOpr.getStructureType());
                saveEntity.setProjectOverview(buOpr.getProjectOverview());
                saveEntity.setPubUnitName(buOpr.getConstructionUnitName());
                saveEntity.setPubUnit(buOpr.getConstructionUnit());
                saveEntity.setEngineeringPurpose(buOpr.getEngineeringPurpose());
                saveEntity.setEngineeringType(buOpr.getEngineeringType());
                saveEntity.setEngineeringTypeName(buOpr.getEngineeringTypeName());
            }
            if (StringUtils.isBlank((CharSequence)projectRegisterVO.getCode())) {
                saveEntity.setCode(this.getAutoCode());
            }
        }
        if (null != projectDepartment) {
            projectDepartment.setSourceId(projectRegisterVO.getSourceId());
            CommonResponse resp2 = this.orgApi.saveOrgInfo(projectDepartment);
            if (!resp2.isSuccess()) {
                throw new BusinessException("\u4fdd\u5b58\u5931\u8d25\uff0c\u4fdd\u5b58\u9879\u76ee\u90e8\u4fe1\u606f\u51fa\u9519: " + resp2.getMsg());
            }
        }
        if (!(memberMap = this.getMemberMap(projectRegisterVO)).isEmpty() && !(resp = this.employeeApi.manageProjectMembers(memberMap)).isSuccess()) {
            throw new BusinessException("\u4fdd\u5b58\u5931\u8d25\uff0c\u65b0\u589e\u6210\u5458\u51fa\u9519: " + resp.getMsg());
        }
        super.saveOrUpdate((Object)saveEntity, false);
        if (null != buOpr) {
            buOpr.setProjectIsSet(true);
            buOpr.setProjectSetId(saveEntity.getId());
            this.businessOpportunityService.saveOrUpdate((Object)buOpr, false);
        }
        if (storeFlag) {
            this.generateStore(saveEntity);
        }
        return (ProjectRegisterVO)BeanMapper.map((Object)((Object)saveEntity), ProjectRegisterVO.class);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public String delProject(Long projectId) {
        ProjectRegisterEntity entity = (ProjectRegisterEntity)((Object)super.selectById((Serializable)projectId));
        if ("0".equals(entity.getValidStatus())) {
            throw new BusinessException("\u5220\u9664\u5931\u8d25\uff0c\u9879\u76ee\uff1a\u3010" + entity.getName() + "\u3011\u4e3a\u542f\u7528\u72b6\u6001\u4e0d\u53ef\u5220\u9664\uff01");
        }
        BusinessOpportunityEntity buOpr = this.businessOpportunityService.selectByProjectId(projectId);
        if (null != buOpr) {
            this.logger.info("\u9879\u76ee\u5220\u9664\uff0c\u8fd8\u539f\u5bf9\u5e94\u5546\u673a[id-{}]\u5f15\u7528\u72b6\u6001", (Object)buOpr.getId());
            buOpr.setProjectIsSet(false);
            buOpr.setProjectSetId(null);
            this.businessOpportunityService.saveOrUpdate((Object)buOpr, false);
        }
        super.removeById((Serializable)projectId);
        this.logger.info("\u6267\u884c\u9879\u76ee\u5220\u90e8\u9664\u64cd\u4f5c\uff0c\u5220\u9664\u9879\u76ee\u90e8[id-{}]", (Object)entity.getProjectDepartmentId());
        CommonResponse delResp = this.orgApi.delByOrgId(entity.getProjectDepartmentId());
        if (!delResp.isSuccess()) {
            this.logger.error("\u5220\u9664\u9879\u76ee[id-{}]\u5bf9\u5e94\u9879\u76ee\u90e8[id-{}]\u4fe1\u606f\u5931\u8d25\uff0c\u539f\u56e0\uff1a{}", new Object[]{projectId, entity.getProjectDepartmentId(), delResp.getMsg()});
            throw new BusinessException("\u9879\u76ee\u5220\u9664\u5931\u8d25\uff0c\u5220\u9664\u5bf9\u5e94\u9879\u76ee\u90e8\u4fe1\u606f\u5931\u8d25\u3002");
        }
        return null;
    }

    @Override
    public ProjectRegisterVO changeStatus(ProjectRegisterVO projectRegisterVO) {
        ProjectRegisterEntity saveEntity = (ProjectRegisterEntity)((Object)this.selectById(projectRegisterVO.getId()));
        saveEntity.setStatus(projectRegisterVO.getStatus());
        OrgVO projectDepartment = (OrgVO)this.getRespData(this.orgApi.getOneById(saveEntity.getProjectDepartmentId()), true, "\u4fdd\u5b58\u5931\u8d25\uff0c\u67e5\u8be2\u6240\u5c5e\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        super.saveOrUpdate((Object)saveEntity, false);
        if (null != projectDepartment) {
            if ("2".equals(projectRegisterVO.getStatus())) {
                projectDepartment.setProjectState(Integer.valueOf(1));
            } else {
                projectDepartment.setProjectState(Integer.valueOf(2));
            }
            CommonResponse resp = this.orgApi.saveOrgInfo(projectDepartment);
            if (!resp.isSuccess()) {
                throw new BusinessException("\u4fdd\u5b58\u5931\u8d25\uff0c\u4fdd\u5b58\u9879\u76ee\u90e8\u4fe1\u606f\u51fa\u9519: " + resp.getMsg());
            }
        }
        return (ProjectRegisterVO)BeanMapper.map((Object)((Object)saveEntity), ProjectRegisterVO.class);
    }
}

