/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.market.controller.api;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.market.bean.ProjectRegisterEntity;
import com.ejianc.business.market.service.IProjectRegisterService;
import com.ejianc.business.market.vo.FilterOrgIdVo;
import com.ejianc.business.market.vo.ProjectRegisterVO;
import com.ejianc.business.market.vo.SupplierCooperateVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/project/"})
public class ProjectApi {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private IProjectRegisterService projectRegisterService;
    @Autowired
    private SessionManager sessionManager;
    private static final String INDEX_NAME_PAY_CONTRACT = "pay_contract";
    @Autowired(required=false)
    private RestHighLevelClient client;
    private static final Integer QUERY_TIMEOUT = 60;

    @GetMapping(value={"queryProjectBySourceId"})
    public CommonResponse<ProjectRegisterVO> queryProjectBySourceId(@RequestParam(value="sourceId") String sourceId) {
        ProjectRegisterVO vo = new ProjectRegisterVO();
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"dr", (Object)0);
        queryWrapper.eq((Object)"source_id", (Object)sourceId);
        ProjectRegisterEntity entity = (ProjectRegisterEntity)((Object)this.projectRegisterService.getOne((Wrapper)queryWrapper));
        if (entity != null) {
            vo = (ProjectRegisterVO)BeanMapper.map((Object)((Object)entity), ProjectRegisterVO.class);
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)vo);
    }

    @GetMapping(value={"queryProjectDetail"})
    public CommonResponse<ProjectRegisterVO> queryProjectDetail(@RequestParam(value="projectId") Long projectId) {
        ProjectRegisterVO vo = new ProjectRegisterVO();
        ProjectRegisterEntity entity = (ProjectRegisterEntity)((Object)this.projectRegisterService.selectById(projectId));
        if (entity != null) {
            vo = (ProjectRegisterVO)BeanMapper.map((Object)((Object)entity), ProjectRegisterVO.class);
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)vo);
    }

    @GetMapping(value={"queryProjectByProjectDepartmentId"})
    public CommonResponse<ProjectRegisterVO> queryProjectByProjectDepartmentId(@RequestParam(value="projectDepartmentId") Long projectDepartmentId) {
        ProjectRegisterVO vo = new ProjectRegisterVO();
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"project_department_id", (Object)projectDepartmentId);
        ProjectRegisterEntity entity = (ProjectRegisterEntity)((Object)this.projectRegisterService.getOne((Wrapper)queryWrapper));
        if (entity != null) {
            vo = (ProjectRegisterVO)BeanMapper.map((Object)((Object)entity), ProjectRegisterVO.class);
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)vo);
    }

    @GetMapping(value={"queryProjectByIds"})
    public CommonResponse<List<ProjectRegisterVO>> queryProjectByIds(@RequestParam(value="ids") List<Long> ids) {
        List vos = new ArrayList();
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"dr", (Object)0);
        queryWrapper.in((Object)"id", ids);
        List entitys = this.projectRegisterService.list((Wrapper)queryWrapper);
        if (entitys != null) {
            vos = BeanMapper.mapList((Iterable)entitys, ProjectRegisterVO.class);
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", vos);
    }

    @GetMapping(value={"getProjectIdsByProperties"})
    CommonResponse<List<Long>> getProjectIdsByProperties(@RequestParam(value="projectRange") int projectRange) {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        queryParam.getParams().put("validStatus", new Parameter("eq", (Object)0));
        boolean queryNewSigned = false;
        if (projectRange == 2 || projectRange == 3) {
            queryParam.getParams().put("status", new Parameter("eq", (Object)projectRange));
        } else if (projectRange == 4) {
            queryNewSigned = true;
        }
        return CommonResponse.success(this.projectRegisterService.queryProIdsByProperties(queryParam, queryNewSigned));
    }

    @GetMapping(value={"getProjectIdsByEngineeringType"})
    CommonResponse<List<Long>> getProjectIdsByEngineeringType(@RequestParam(value="projectRange") int projectRange, @RequestParam(value="engineeringType", required=false) Long engineeringType) {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        queryParam.getParams().put("validStatus", new Parameter("eq", (Object)0));
        boolean queryNewSigned = false;
        if (projectRange == 2 || projectRange == 3) {
            queryParam.getParams().put("status", new Parameter("eq", (Object)projectRange));
        } else if (projectRange == 4) {
            queryNewSigned = true;
        }
        if (null != engineeringType) {
            queryParam.getParams().put("engineeringType", new Parameter("eq", (Object)engineeringType));
        }
        return CommonResponse.success(this.projectRegisterService.queryProIdsByProperties(queryParam, queryNewSigned));
    }

    @GetMapping(value={"queryProjectByUserId"})
    public CommonResponse<List<ProjectRegisterVO>> queryProjectByUserId(@RequestParam(value="userId") Long userId) {
        return this.projectRegisterService.queryProjectByUserId(userId);
    }

    @GetMapping(value={"queryProjectList"})
    public CommonResponse<List<ProjectRegisterVO>> queryProjectList(@RequestParam(value="num", defaultValue="10") int num) {
        QueryParam queryParam = new QueryParam();
        queryParam.setPageSize(num);
        queryParam.setPageIndex(1);
        queryParam.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        CommonResponse response = this.orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId());
        List orgVOList = (List)response.getData();
        if (!response.isSuccess()) {
            return CommonResponse.error((String)"\u672c\u4e0b\u7ec4\u7ec7\u67e5\u8be2\u5931\u8d25\uff01");
        }
        queryParam.getParams().put("projectDepartmentId", new Parameter("in", orgVOList.stream().map(BaseVO::getId).collect(Collectors.toList())));
        queryParam.getParams().put("validStatus", new Parameter("eq", (Object)0));
        queryParam.getOrderMap().put("createTime", "desc");
        IPage page = this.projectRegisterService.queryPage(queryParam, false);
        System.out.println("\u67e5\u8be2\u672c\u4e0b\u542f\u7528\u7684\u9879\u76ee\uff0c\u53c2\u6570\u4e3a\u9700\u8981\u67e5\u8be2\u7684\u6761\u6570\uff0c\u9ed8\u8ba4\u5341\u6761 page.getTotal = " + page.getTotal());
        List res = BeanMapper.mapList((Iterable)page.getRecords(), ProjectRegisterVO.class);
        System.out.println("\u67e5\u8be2\u672c\u4e0b\u542f\u7528\u7684\u9879\u76ee\uff0c\u53c2\u6570\u4e3a\u9700\u8981\u67e5\u8be2\u7684\u6761\u6570\uff0c\u9ed8\u8ba4\u5341\u6761 res.size = " + res.size());
        return CommonResponse.success((Object)res);
    }

    @PostMapping(value={"queryProjectPage"})
    public CommonResponse<Page<ProjectRegisterVO>> queryProjectPage(@RequestBody QueryParam queryParam) {
        queryParam.getFuzzyFields().add("name");
        queryParam.getFuzzyFields().add("projectManagerName");
        queryParam.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        UserContext userContext = this.sessionManager.getUserContext();
        String authOrgIds = userContext.getAuthOrgIds();
        this.logger.info(">>>>>>>>>>>>>>>>>>>>>>>>>>>>queryProjectPage>>>>>>>>>>>>>>>>>>>>>>>>>");
        this.logger.info("authOrgIds:{}", (Object)authOrgIds);
        if (StringUtils.isNotEmpty((CharSequence)authOrgIds)) {
            CommonResponse authResponse = this.orgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList()));
            this.logger.info("authResponse.getData().size():{}", (Object)authOrgIds, authResponse.getData() == null ? null : Integer.valueOf(((List)authResponse.getData()).size()));
            queryParam.getParams().put("projectDepartmentId", new Parameter("in", ((List)authResponse.getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        } else {
            queryParam.getParams().put("projectDepartmentId", new Parameter("in", ((List)this.orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        }
        this.logger.info("<<<<<<<<<<<<<<<<<<<<<<<<<<<<queryProjectPage<<<<<<<<<<<<<<<<<<<<<<<<<");
        queryParam.getParams().put("validStatus", new Parameter("eq", (Object)0));
        queryParam.getOrderMap().putIfAbsent("createTime", "desc");
        IPage pageData = this.projectRegisterService.queryPage(queryParam, false);
        Page result = new Page(pageData.getCurrent(), pageData.getSize(), pageData.getTotal());
        if (pageData.getTotal() > 0L) {
            List list = BeanMapper.mapList((Iterable)pageData.getRecords(), ProjectRegisterVO.class);
            result.setRecords(list);
        }
        return CommonResponse.success((Object)result);
    }

    @PostMapping(value={"queryProjectListByStatus"})
    public CommonResponse<List<Long>> queryProjectListByStatus(@RequestBody ProjectRegisterVO vo) {
        QueryParam queryParam = new QueryParam();
        List orgIds = ((List)this.orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList());
        queryParam.getParams().put("orgId", new Parameter("in", orgIds));
        queryParam.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        queryParam.getParams().put("status", new Parameter("eq", (Object)vo.getStatus()));
        List projectRegisterEntities = this.projectRegisterService.queryList(queryParam);
        List<Object> collect = new ArrayList();
        if (CollectionUtils.isNotEmpty((Collection)projectRegisterEntities)) {
            collect = projectRegisterEntities.stream().map(i -> i.getId()).collect(Collectors.toList());
        }
        return CommonResponse.success(collect);
    }

    @PostMapping(value={"queryFilterProjects"})
    public CommonResponse<List<ProjectRegisterVO>> queryFilterProjects(@RequestBody FilterOrgIdVo filterOrgVo) {
        List projectRegisterEntities;
        List resp = new ArrayList();
        Long orgId = filterOrgVo.getOrgId() == null ? InvocationInfoProxy.getOrgId() : filterOrgVo.getOrgId();
        ArrayList orgIds = new ArrayList();
        QueryParam queryParam = new QueryParam();
        CommonResponse orgResp = this.orgApi.getOneById(orgId);
        if (!orgResp.isSuccess()) {
            return CommonResponse.error((String)"\u83b7\u53d6\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
        }
        if (OrgVO.ORG_TYPE_DEPARTMENT.equals(((OrgVO)orgResp.getData()).getOrgType())) {
            queryParam.getParams().put("projectDepartmentId", new Parameter("eq", (Object)orgId));
        } else {
            CommonResponse withoutProjectDeptRes = this.orgApi.findChildrenByParentIdWithoutProjectDept(orgId);
            if (withoutProjectDeptRes.isSuccess() && CollectionUtils.isNotEmpty((Collection)((Collection)withoutProjectDeptRes.getData()))) {
                orgIds.addAll(((List)withoutProjectDeptRes.getData()).stream().map(BaseVO::getId).collect(Collectors.toList()));
            }
            queryParam.getParams().put("orgId", new Parameter("in", orgIds));
        }
        queryParam.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (filterOrgVo.getProjectStatus() != null) {
            if (filterOrgVo.getProjectStatus().contains(",")) {
                queryParam.getParams().put("status", new Parameter("in", (Object)filterOrgVo.getProjectStatus()));
            } else {
                queryParam.getParams().put("status", new Parameter("eq", (Object)filterOrgVo.getProjectStatus()));
            }
        }
        if (filterOrgVo.getDateIn() != null) {
            String dateIn = filterOrgVo.getDateIn();
            if (dateIn.equals("near4Year")) {
                queryParam.getParams().put("", new Parameter("sql", (Object)" year(sign_date)>year(now())-3"));
            } else if (!dateIn.equals("all")) {
                queryParam.getParams().put("", new Parameter("sql", (Object)(" year(sign_date)=" + filterOrgVo.getDateIn())));
            }
        }
        if (StringUtils.isNotBlank((CharSequence)filterOrgVo.getSearchText())) {
            queryParam.setSearchText(filterOrgVo.getSearchText());
            if (CollectionUtils.isNotEmpty((Collection)filterOrgVo.getSearchFields())) {
                queryParam.getFuzzyFields().addAll(filterOrgVo.getSearchFields());
            } else {
                queryParam.getFuzzyFields().add("name");
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)(projectRegisterEntities = this.projectRegisterService.queryList(queryParam)))) {
            resp = BeanMapper.mapList((Iterable)projectRegisterEntities, ProjectRegisterVO.class);
        }
        return CommonResponse.success(resp);
    }

    @PostMapping(value={"queryFilterOrgIds"})
    public CommonResponse<List<Long>> queryFilterOrgIds(@RequestBody FilterOrgIdVo filterOrgVo) {
        Long orgId = filterOrgVo.getOrgId() == null ? InvocationInfoProxy.getOrgId() : filterOrgVo.getOrgId();
        ArrayList<Object> orgIds = new ArrayList<Object>();
        CommonResponse withoutProjectDeptRes = this.orgApi.findChildrenByParentIdWithoutProjectDept(orgId);
        if (withoutProjectDeptRes.isSuccess() && CollectionUtils.isNotEmpty((Collection)((Collection)withoutProjectDeptRes.getData()))) {
            orgIds.addAll(((List)withoutProjectDeptRes.getData()).stream().map(BaseVO::getId).collect(Collectors.toList()));
        }
        QueryParam queryParam = new QueryParam();
        CommonResponse response = this.orgApi.findChildrenByParentId(orgId);
        List orgVOList = (List)response.getData();
        if (!response.isSuccess()) {
            return CommonResponse.error((String)"\u672c\u4e0b\u7ec4\u7ec7\u67e5\u8be2\u5931\u8d25\uff01");
        }
        queryParam.getParams().put("projectDepartmentId", new Parameter("in", orgVOList.stream().map(BaseVO::getId).collect(Collectors.toList())));
        queryParam.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        queryParam.getParams().put("valid_status", new Parameter("eq", (Object)0));
        if (filterOrgVo.getProjectStatus() != null) {
            String projectStatus = filterOrgVo.getProjectStatus();
            if (!projectStatus.equals("all")) {
                queryParam.getParams().put("status", new Parameter("eq", (Object)filterOrgVo.getProjectStatus()));
            }
        } else {
            queryParam.getParams().put("status", new Parameter("eq", (Object)2));
        }
        if (filterOrgVo.getDateIn() != null) {
            String dateIn = filterOrgVo.getDateIn();
            if (dateIn.equals("near4Year")) {
                queryParam.getParams().put("", new Parameter("sql", (Object)" year(sign_date)>year(now())-3"));
            } else if (!dateIn.equals("all")) {
                queryParam.getParams().put("", new Parameter("sql", (Object)(" year(sign_date)=" + filterOrgVo.getDateIn())));
            }
        } else {
            queryParam.getParams().put("", new Parameter("sql", (Object)" year(sign_date)>year(now())"));
        }
        List projectRegisterEntities = this.projectRegisterService.queryList(queryParam);
        List projectDepartmentIds = projectRegisterEntities.stream().map(i -> i.getProjectDepartmentId()).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(projectDepartmentIds)) {
            orgIds.addAll(projectDepartmentIds);
        }
        if (CollectionUtils.isEmpty(orgIds)) {
            orgIds.add(1L);
        }
        return CommonResponse.success(orgIds);
    }

    @GetMapping(value={"queryChildrenProjectByOrgId"})
    CommonResponse<List<ProjectRegisterVO>> queryChildrenProjectByOrgId(@RequestParam(value="orgId") Long orgId) {
        ArrayList<Long> departmentIdList = new ArrayList<Long>();
        List result = new ArrayList();
        CommonResponse childOrgResp = this.orgApi.findChildrenByParentId(orgId);
        if (childOrgResp.isSuccess() && CollectionUtils.isNotEmpty((Collection)((Collection)childOrgResp.getData()))) {
            for (OrgVO orgVO : (List)childOrgResp.getData()) {
                if (null == orgVO.getOrgType() || orgVO.getOrgType() != 5) continue;
                departmentIdList.add(orgVO.getId());
            }
        }
        if (CollectionUtils.isNotEmpty(departmentIdList)) {
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            queryWrapper.in(ProjectRegisterEntity::getProjectDepartmentId, departmentIdList);
            List list = this.projectRegisterService.list((Wrapper)queryWrapper);
            if (CollectionUtils.isNotEmpty((Collection)list)) {
                result = BeanMapper.mapList((Iterable)list, ProjectRegisterVO.class);
            }
        }
        return CommonResponse.success(result);
    }

    @PostMapping(value={"queryFilterOrgIdsBuStatus"})
    public CommonResponse<List<Long>> queryFilterOrgIdsBuStatus(@RequestParam(value="status") String status) {
        Long orgId = InvocationInfoProxy.getOrgId();
        ArrayList<Object> orgIds = new ArrayList<Object>();
        CommonResponse withoutProjectDeptRes = this.orgApi.findChildrenByParentIdWithoutProjectDept(orgId);
        if (withoutProjectDeptRes.isSuccess() && CollectionUtils.isNotEmpty((Collection)((Collection)withoutProjectDeptRes.getData()))) {
            orgIds.addAll(((List)withoutProjectDeptRes.getData()).stream().map(BaseVO::getId).collect(Collectors.toList()));
        }
        QueryParam queryParam = new QueryParam();
        CommonResponse response = this.orgApi.findChildrenByParentId(orgId);
        List orgVOList = (List)response.getData();
        if (!response.isSuccess()) {
            return CommonResponse.error((String)"\u672c\u4e0b\u7ec4\u7ec7\u67e5\u8be2\u5931\u8d25\uff01");
        }
        queryParam.getParams().put("projectDepartmentId", new Parameter("in", orgVOList.stream().map(BaseVO::getId).collect(Collectors.toList())));
        queryParam.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        queryParam.getParams().put("status", new Parameter("eq", (Object)status));
        List projectRegisterEntities = this.projectRegisterService.queryList(queryParam);
        List projectDepartmentIds = projectRegisterEntities.stream().map(i -> i.getProjectDepartmentId()).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(projectDepartmentIds)) {
            orgIds.addAll(projectDepartmentIds);
        }
        if (CollectionUtils.isEmpty(orgIds)) {
            orgIds.add(1L);
        }
        return CommonResponse.success(orgIds);
    }

    @GetMapping(value={"queryProjects"})
    CommonResponse<List<Map>> queryProjects(@RequestParam(value="orgId") Long orgId, @RequestParam(value="statusList", required=false) List<String> statusList, @RequestParam(value="focusTypeList", required=false) List<String> focusTypeList, @RequestParam(value="engineeringTypeList", required=false) List<Long> engineeringTypeList, @RequestParam(value="searchText", required=false) String searchText) {
        ArrayList<Long> departmentIdList = new ArrayList<Long>();
        ArrayList result = new ArrayList();
        CommonResponse childOrgResp = this.orgApi.findChildrenByParentId(orgId);
        if (childOrgResp.isSuccess() && CollectionUtils.isNotEmpty((Collection)((Collection)childOrgResp.getData()))) {
            for (OrgVO orgVO : (List)childOrgResp.getData()) {
                if (null == orgVO.getOrgType() || orgVO.getOrgType() != 5) continue;
                departmentIdList.add(orgVO.getId());
            }
        }
        if (CollectionUtils.isNotEmpty(departmentIdList)) {
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("dr", new Parameter("eq", (Object)0));
            queryParam.getParams().put("projectDepartmentId", new Parameter("in", departmentIdList));
            if (statusList != null && statusList.size() > 0) {
                queryParam.getParams().put("status", new Parameter("in", statusList));
            }
            if (focusTypeList != null && focusTypeList.size() > 0) {
                queryParam.getParams().put("focusType", new Parameter("in", focusTypeList));
            }
            if (engineeringTypeList != null && engineeringTypeList.size() > 0) {
                queryParam.getParams().put("engineeringType", new Parameter("in", engineeringTypeList));
            }
            if (StringUtils.isNotBlank((CharSequence)searchText)) {
                queryParam.setSearchText(searchText);
                queryParam.getFuzzyFields().add("name");
                queryParam.getFuzzyFields().add("projectManagerName");
            }
            queryParam.getOrderMap().put("createTime", "desc");
            List list = this.projectRegisterService.queryList(queryParam);
            if (CollectionUtils.isNotEmpty((Collection)list)) {
                for (ProjectRegisterEntity entity : list) {
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    map.put("id", entity.getId());
                    map.put("name", entity.getName());
                    map.put("lat", entity.getLat());
                    map.put("lng", entity.getLng());
                    map.put("focusType", entity.getFocusType());
                    map.put("projectDepartmentId", entity.getProjectDepartmentId());
                    map.put("engineeringTypeName", entity.getEngineeringTypeName());
                    map.put("projectManagerName", entity.getProjectManagerName());
                    result.add(map);
                }
            }
        }
        return CommonResponse.success(result);
    }

    @PostMapping(value={"querySupplierCooperate"})
    public CommonResponse<Map<Long, List<SupplierCooperateVO>>> querySupplierCooperate(@RequestBody List<Long> supplierIds) {
        BoolQueryBuilder boolQuery = QueryBuilders.boolQuery();
        boolQuery.must((QueryBuilder)QueryBuilders.termQuery((String)"tenantId", (String)InvocationInfoProxy.getTenantid().toString()));
        boolQuery.must((QueryBuilder)QueryBuilders.termsQuery((String)"supplierId", supplierIds));
        SearchRequest searchRequest = new SearchRequest(new String[]{INDEX_NAME_PAY_CONTRACT});
        SearchSourceBuilder sourceBuilder = new SearchSourceBuilder();
        sourceBuilder.query((QueryBuilder)boolQuery);
        sourceBuilder.trackTotalHits(true);
        sourceBuilder.timeout(new TimeValue((long)QUERY_TIMEOUT.intValue(), TimeUnit.SECONDS));
        searchRequest.source(sourceBuilder);
        ArrayList<Object> list = new ArrayList<Object>();
        Map<Long, List<SupplierCooperateVO>> map = null;
        SearchResponse response = null;
        try {
            response = this.client.search(searchRequest, RequestOptions.DEFAULT);
            SearchHits hits = response.getHits();
            for (SearchHit hit : hits) {
                String sourceAsString = hit.getSourceAsString();
                list.add(JSON.parseObject((String)sourceAsString, SupplierCooperateVO.class));
            }
            map = list.stream().collect(Collectors.groupingBy(SupplierCooperateVO::getSupplierId));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return CommonResponse.success(map);
    }

    @PostMapping(value={"queryAllProj"})
    public CommonResponse<List<ProjectRegisterVO>> queryAllProj(@RequestBody QueryParam queryParam) {
        Parameter tenantIdListPram = (Parameter)queryParam.getParams().get("tenantIdList");
        if (null != tenantIdListPram && null != tenantIdListPram.getValue()) {
            queryParam.getParams().put("tenantId", new Parameter("in", tenantIdListPram.getValue()));
        } else {
            queryParam.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        }
        queryParam.getParams().remove("tenantIdList");
        Parameter withoutOrgFlag = (Parameter)queryParam.getParams().get("withoutOrgFlag");
        if (null == withoutOrgFlag || BooleanUtils.isFalse((Boolean)((Boolean)withoutOrgFlag.getValue()))) {
            UserContext userContext = this.sessionManager.getUserContext();
            String authOrgIds = userContext.getAuthOrgIds();
            this.logger.info(">>>>>>>>>>>>>>>>>>>>>>>>>>>>queryProjectPage>>>>>>>>>>>>>>>>>>>>>>>>>");
            this.logger.info("authOrgIds:{}", (Object)authOrgIds);
            if (StringUtils.isNotEmpty((CharSequence)authOrgIds)) {
                CommonResponse authResponse = this.orgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList()));
                this.logger.info("authResponse.getData().size():{}", (Object)authOrgIds, authResponse.getData() == null ? null : Integer.valueOf(((List)authResponse.getData()).size()));
                queryParam.getParams().put("projectDepartmentId", new Parameter("in", ((List)authResponse.getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
            } else {
                queryParam.getParams().put("projectDepartmentId", new Parameter("in", ((List)this.orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
            }
            this.logger.info("<<<<<<<<<<<<<<<<<<<<<<<<<<<<queryProjectPage<<<<<<<<<<<<<<<<<<<<<<<<<");
        }
        queryParam.getParams().remove("withoutOrgFlag");
        List projList = this.projectRegisterService.queryList(queryParam, false);
        return CommonResponse.success(CollectionUtils.isNotEmpty((Collection)projList) ? BeanMapper.mapList((Iterable)projList, ProjectRegisterVO.class) : null);
    }

    @PostMapping(value={"getProjectMapByCodes"})
    CommonResponse<Map<String, ProjectRegisterVO>> getProjectMapByCodes(@RequestBody List<String> codes) {
        Map<Object, Object> map = new HashMap();
        if (CollectionUtils.isNotEmpty(codes)) {
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            queryWrapper.eq(BaseEntity::getTenantId, (Object)InvocationInfoProxy.getTenantid());
            queryWrapper.in(ProjectRegisterEntity::getCode, codes);
            List list = this.projectRegisterService.list((Wrapper)queryWrapper);
            List projectRegisterVOS = BeanMapper.mapList((Iterable)list, ProjectRegisterVO.class);
            if (CollectionUtils.isNotEmpty((Collection)projectRegisterVOS)) {
                map = projectRegisterVOS.stream().collect(Collectors.toMap(ProjectRegisterVO::getCode, Function.identity(), (p1, p2) -> p1));
            }
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", map);
    }

    @GetMapping(value={"changeProjectStage"})
    CommonResponse<String> changeProjectStage(@RequestParam(value="projectId") Long projectId, @RequestParam(value="projectStage") String projectStage) {
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.eq(BaseEntity::getId, (Object)projectId);
        updateWrapper.set(ProjectRegisterEntity::getProjectStage, (Object)projectStage);
        if ("\u5b8c\u5de5".equals(projectStage)) {
            updateWrapper.set(ProjectRegisterEntity::getStatus, (Object)"3");
        }
        this.projectRegisterService.update((Wrapper)updateWrapper);
        return CommonResponse.success((String)"\u64cd\u4f5c\u6210\u529f\uff01");
    }
}

