package com.ejianc.business.market.bean;

import java.util.List;
import java.util.ArrayList;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

/**
 * 投标评审
 * 
 * @author generator
 * 
 */
 @TableName("ejc_bid_review")
public class BidReviewEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="bill_code")
    private String billCode; // 单据编号
    @TableField(value="create_user_name")
    private String createUserName; // 创建人名称
    @TableField(value="project_id")
    private Long projectId; // 工程id
    @TableField(value="project_name")
    private String projectName; // 工程名称
    @TableField(value="org_id")
    private Long orgId; // 投标单位
    @TableField(value="org_name")
    private String orgName; // 投标单位名称
    @TableField(value="manager_id")
    private Long managerId; // 拟用项目经理Id
    @TableField(value="manager_name")
    private String managerName; // 拟用项目经理
    @TableField(value="bid_price")
    private java.math.BigDecimal bidPrice; // 投标价格
    @TableField(value="bidding_form_name")
    private String biddingFormName; // 招标方式
    @TableField(value="bill_state")
    private Integer billState; // 单据状态
    @TableField(value="review_time")
    private java.util.Date reviewTime; // 评审日期
    @TableField(value="proposer_id")
    private Long proposerId; // 投标申请人id
    @TableField(value="proposer_name")
    private String proposerName; // 投标申请人
    @TableField(value="bidding_form_id")
    private Long biddingFormId; // 招标方式id
    
    
    @TableField(exist=false)
    @SubEntity(serviceName="bidReviewDetailService",pidName = "bidId")
    private List<BidReviewDetailEntity> bidReviewDetailVos = new ArrayList<>(); // 投标评审子表实体
    

    /**
     * 单据编号
     */
    public String getBillCode() {
        return billCode;
    }

    /**
     * 单据编号
     */
    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    /**
     * 创建人名称
     */
    public String getCreateUserName() {
        return createUserName;
    }

    /**
     * 创建人名称
     */
    public void setCreateUserName(String createUserName) {
        this.createUserName = createUserName;
    }
    /**
     * 工程id
     */
    public Long getProjectId() {
        return projectId;
    }

    /**
     * 工程id
     */
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    /**
     * 工程名称
     */
    public String getProjectName() {
        return projectName;
    }

    /**
     * 工程名称
     */
    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    /**
     * 投标单位
     */
    public Long getOrgId() {
        return orgId;
    }

    /**
     * 投标单位
     */
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    /**
     * 投标单位名称
     */
    public String getOrgName() {
        return orgName;
    }

    /**
     * 投标单位名称
     */
    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    /**
     * 拟用项目经理Id
     */
    public Long getManagerId() {
        return managerId;
    }

    /**
     * 拟用项目经理Id
     */
    public void setManagerId(Long managerId) {
        this.managerId = managerId;
    }
    /**
     * 拟用项目经理
     */
    public String getManagerName() {
        return managerName;
    }

    /**
     * 拟用项目经理
     */
    public void setManagerName(String managerName) {
        this.managerName = managerName;
    }
    /**
     * 投标价格
     */
    public java.math.BigDecimal getBidPrice() {
        return bidPrice;
    }

    /**
     * 投标价格
     */
    public void setBidPrice(java.math.BigDecimal bidPrice) {
        this.bidPrice = bidPrice;
    }

    public String getBiddingFormName() {
        return biddingFormName;
    }

    public void setBiddingFormName(String biddingFormName) {
        this.biddingFormName = biddingFormName;
    }

    public Long getBiddingFormId() {
        return biddingFormId;
    }

    public void setBiddingFormId(Long biddingFormId) {
        this.biddingFormId = biddingFormId;
    }

    /**
     * 单据状态
     */
    public Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态
     */
    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    /**
     * 评审日期
     */
    public java.util.Date getReviewTime() {
        return reviewTime;
    }

    /**
     * 评审日期
     */
    public void setReviewTime(java.util.Date reviewTime) {
        this.reviewTime = reviewTime;
    }
    /**
     * 投标申请人id
     */
    public Long getProposerId() {
        return proposerId;
    }

    /**
     * 投标申请人id
     */
    public void setProposerId(Long proposerId) {
        this.proposerId = proposerId;
    }
    /**
     * 投标申请人
     */
    public String getProposerName() {
        return proposerName;
    }

    /**
     * 投标申请人
     */
    public void setProposerName(String proposerName) {
        this.proposerName = proposerName;
    }


    public List<BidReviewDetailEntity> getBidReviewDetailVos() {
        return bidReviewDetailVos;
    }

    public void setBidReviewDetailVos(List<BidReviewDetailEntity> bidReviewDetailVos) {
        this.bidReviewDetailVos = bidReviewDetailVos;
    }
}
