package com.ejianc.business.market.bean;

import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.business.market.vo.PlanIndexDeteailVO;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

/**
 * 年度经营指标下达实体
 * 
 * @author generator
 * 
 */
 @TableName("ejc_market_plan_index")
public class PlanIndexEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="bill_code")
    private java.lang.String billCode; // 单据编号
    @TableField(value="year")
    private java.lang.String year; // 年度
    @TableField(value="management_index_mny")
    private java.math.BigDecimal managementIndexMny; // 经营指标（万元）
    @TableField(value="employee_id")
    private java.lang.Long employeeId; // 下达人
    @TableField(value="employee_name")
    private java.lang.String employeeName; // 下达人名称
    @TableField(value="assign_date")
    private java.util.Date assignDate; // 下达日期
    @TableField(value="bill_state")
    private java.lang.Integer billState; // 单据状态（审批必须字段）
    @TableField(value="create_user_name")
    private java.lang.String createUserName; // 创建人名称

    @TableField(exist=false)
    @SubEntity(serviceName="planIndexDeteailService",pidName = "indexId")
    private List<PlanIndexDeteailEntity> indexList = new ArrayList<>(); // 投标评审子表实体

    public List<PlanIndexDeteailEntity> getIndexList() {
        return indexList;
    }

    public void setIndexList(List<PlanIndexDeteailEntity> indexList) {
        this.indexList = indexList;
    }

    /**
     * 单据编号
     */
    public java.lang.String getBillCode() {
        return billCode;
    }

    /**
     * 单据编号
     */
    public void setBillCode(java.lang.String billCode) {
        this.billCode = billCode;
    }
    /**
     * 年度
     */
    public java.lang.String getYear() {
        return year;
    }

    /**
     * 年度
     */
    public void setYear(java.lang.String year) {
        this.year = year;
    }
    /**
     * 经营指标（万元）
     */
    public java.math.BigDecimal getManagementIndexMny() {
        return managementIndexMny;
    }

    /**
     * 经营指标（万元）
     */
    public void setManagementIndexMny(java.math.BigDecimal managementIndexMny) {
        this.managementIndexMny = managementIndexMny;
    }
    /**
     * 下达人
     */
    public java.lang.Long getEmployeeId() {
        return employeeId;
    }

    /**
     * 下达人
     */
    public void setEmployeeId(java.lang.Long employeeId) {
        this.employeeId = employeeId;
    }
    /**
     * 下达人名称
     */
    public java.lang.String getEmployeeName() {
        return employeeName;
    }

    /**
     * 下达人名称
     */
    public void setEmployeeName(java.lang.String employeeName) {
        this.employeeName = employeeName;
    }
    /**
     * 下达日期
     */
    public java.util.Date getAssignDate() {
        return assignDate;
    }

    /**
     * 下达日期
     */
    public void setAssignDate(java.util.Date assignDate) {
        this.assignDate = assignDate;
    }
    /**
     * 单据状态（审批必须字段）
     */
    public java.lang.Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态（审批必须字段）
     */
    public void setBillState(java.lang.Integer billState) {
        this.billState = billState;
    }
    /**
     * 创建人名称
     */
    public java.lang.String getCreateUserName() {
        return createUserName;
    }

    /**
     * 创建人名称
     */
    public void setCreateUserName(java.lang.String createUserName) {
        this.createUserName = createUserName;
    }
    
}
