package com.ejianc.business.market.controller;

import java.io.Serializable;

import com.ejianc.business.market.vo.PlanIndexDeteailVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.elasticsearch.search.DocValueFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import com.ejianc.business.market.utils.ComputeUtil;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.market.bean.PlanIndexEntity;
import com.ejianc.business.market.service.IPlanIndexService;
import com.ejianc.business.market.vo.PlanIndexVO;

/**
 * 年度经营指标下达实体
 * 
 * @author generator
 * 
 */
@Controller
@RequestMapping("planIndex")
public class PlanIndexController implements Serializable {
	private static final long serialVersionUID = 1L;
	
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "Plan_Index_Code";//此处需要根据实际修改
    
    @Autowired
    private IPlanIndexService service; 
    
    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<PlanIndexVO> saveOrUpdate(@RequestBody PlanIndexVO saveorUpdateVO) {
    	PlanIndexEntity entity = BeanMapper.map(saveorUpdateVO, PlanIndexEntity.class);
    	if(entity.getId() == null || entity.getId() == 0){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        List<PlanIndexDeteailVO> indexList = saveorUpdateVO.getIndexList();
        BigDecimal totalMny = BigDecimal.ZERO;//总合同额
        for (PlanIndexDeteailVO vo : indexList){
            totalMny = ComputeUtil.safeAdd(totalMny,vo.getCompanyIndexMny());
        }
        entity.setManagementIndexMny(totalMny);
    	service.saveOrUpdate(entity, false);
    	PlanIndexVO vo = BeanMapper.map(entity, PlanIndexVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }
    
    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<PlanIndexVO> queryDetail(Long id) {
    	PlanIndexEntity entity = service.selectById(id);
    	PlanIndexVO vo = BeanMapper.map(entity, PlanIndexVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }
    
    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody PlanIndexVO vos) {
        List<Long> ids = vos.getIds();
        service.removeByIds(ids, true);
        return CommonResponse.success("删除成功！");
    }
    
    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<PlanIndexVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("createTime");
        fuzzyFields.add("billState");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        //param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));

        IPage<PlanIndexEntity> page = service.queryPage(param,false);
        IPage<PlanIndexVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), PlanIndexVO.class));
        
        return CommonResponse.success("查询列表数据成功！",pageData);
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        //param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<PlanIndexEntity> list = service.queryList(param);
        List<PlanIndexVO> vos = new ArrayList<>();
        for(PlanIndexEntity entity : list){
            PlanIndexVO vo = BeanMapper.map(entity, PlanIndexVO.class);
            //变更状态 0未变更 1 已变更
            if(vo.getBillState()!=null){
                if(vo.getBillState()==0){
                    vo.setBillStateName("自由态");
                }
                if(vo.getBillState()==1){
                    vo.setBillStateName("已提交");
                }
                if(vo.getBillState()==2){
                    vo.setBillStateName("审批中");
                }
                if(vo.getBillState()==3){
                    vo.setBillStateName("已通过");
                }
                if(vo.getBillState()==4){
                    vo.setBillStateName("已驳回");
                }
                if(vo.getBillState()==5){
                    vo.setBillStateName("审批中");
                }
            }
            vos.add(vo);
        }
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", vos);
        ExcelExport.getInstance().export("PlanIndex-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refPlanIndexData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<PlanIndexVO>> refPlanIndexData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<PlanIndexEntity> page = service.queryPage(param,false);
        IPage<PlanIndexVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), PlanIndexVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }
}
