package com.ejianc.business.market.vo;

import java.util.Date;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;

import com.ejianc.business.market.vo.BidReviewDetailVO;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 投标评审
 * 
 * @author generator
 * 
 */
public class BidReviewVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private String billCode; // 单据编号
    private Long projectId; // 工程id
    private String projectName; // 工程名称
    private Long orgId; // 投标单位
    private String orgName; // 投标单位名称
    private Long managerId; // 拟用项目经理Id
    private String managerName; // 拟用项目经理
    private java.math.BigDecimal bidPrice; // 投标价格
    private String biddingFormName; // 招标方式
    private Integer billState; // 单据状态
    @JsonFormat(
            shape = JsonFormat.Shape.STRING,
            pattern = "yyyy-MM-dd HH:mm:ss",
            timezone = "GMT+8"
    )
    private Date reviewTime; // 评审日期
    private Long proposerId; // 投标申请人id
    private String proposerName; // 投标申请人
    private Long biddingFormId; // 招标方式id
    
    private List<BidReviewDetailVO> bidReviewDetailVos = new ArrayList<>(); // 投标评审子表实体

    /**
     * 单据编号
     */
    public String getBillCode() {
        return billCode;
    }

    /**
     * 单据编号
     */
    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    /**
     * 工程id
     */
    @ReferSerialTransfer(referCode="market-project")
    public Long getProjectId() {
        return projectId;
    }

    /**
     * 工程id
     */
    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    /**
     * 工程名称
     */
    public String getProjectName() {
        return projectName;
    }

    /**
     * 工程名称
     */
    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    /**
     * 投标单位
     */
    public Long getOrgId() {
        return orgId;
    }

    /**
     * 投标单位
     */
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    /**
     * 投标单位名称
     */
    public String getOrgName() {
        return orgName;
    }

    /**
     * 投标单位名称
     */
    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    /**
     * 拟用项目经理Id
     */
    @ReferSerialTransfer(referCode="idm-employee")
    public Long getManagerId() {
        return managerId;
    }

    /**
     * 拟用项目经理Id
     */
    @ReferDeserialTransfer
    public void setManagerId(Long managerId) {
        this.managerId = managerId;
    }
    /**
     * 拟用项目经理
     */

    public String getManagerName() {
        return managerName;
    }

    /**
     * 拟用项目经理
     */

    public void setManagerName(String managerName) {
        this.managerName = managerName;
    }
    /**
     * 投标价格
     */
    public java.math.BigDecimal getBidPrice() {
        return bidPrice;
    }

    /**
     * 投标价格
     */
    public void setBidPrice(java.math.BigDecimal bidPrice) {
        this.bidPrice = bidPrice;
    }

    /**
     * 单据状态
     */
    public Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态
     */
    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    /**
     * 评审日期
     */
    public java.util.Date getReviewTime() {
        return reviewTime;
    }

    /**
     * 评审日期
     */
    public void setReviewTime(java.util.Date reviewTime) {
        this.reviewTime = reviewTime;
    }
    /**
     * 投标申请人id
     */
    @ReferSerialTransfer(referCode="idm-employee")
    public Long getProposerId() {
        return proposerId;
    }

    /**
     * 投标申请人id
     */
    @ReferDeserialTransfer
    public void setProposerId(Long proposerId) {
        this.proposerId = proposerId;
    }
    /**
     * 投标申请人
     */
    public String getProposerName() {
        return proposerName;
    }

    /**
     * 投标申请人
     */
    public void setProposerName(String proposerName) {
        this.proposerName = proposerName;
    }

    public String getBiddingFormName() {
        return biddingFormName;
    }

    public void setBiddingFormName(String biddingFormName) {
        this.biddingFormName = biddingFormName;
    }

    public Long getBiddingFormId() {
        return biddingFormId;
    }

    public void setBiddingFormId(Long biddingFormId) {
        this.biddingFormId = biddingFormId;
    }

    /**
      * 投标评审子表实体
      */
     public List<BidReviewDetailVO> getBidReviewDetailVos() {
        return bidReviewDetailVos;
     }

     /**
      * 投标评审子表实体
      */
     public void setBidReviewDetailVos(List<BidReviewDetailVO> bidReviewDetailVos) {
        this.bidReviewDetailVos = bidReviewDetailVos;
     }
}
