package com.ejianc.business.market.vo;

import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;


/**
 * 年度经营指标下达实体
 * 
 * @author generator
 * 
 */
public class PlanIndexVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private java.lang.String billCode; // 单据编号
    private java.lang.String year; // 年度
    private java.lang.String managementIndexMny; // 经营指标（万元）
    private java.lang.Long employeeId; // 下达人
    private java.lang.String employeeName; // 下达人名称
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private java.util.Date assignDate; // 下达日期
    private java.lang.Integer billState; // 单据状态（审批必须字段）
    private java.lang.String billStateName;//启用状态名称
    private java.lang.String createUserName; // 创建人名称

    private Long orgId; // 组织
    private String orgName; // 组织名称


    private List<PlanIndexDeteailVO> indexList;
    private List<Long> ids;

    public List<PlanIndexDeteailVO> getIndexList() {
        return indexList;
    }

    public void setIndexList(List<PlanIndexDeteailVO> indexList) {
        this.indexList = indexList;
    }

    public List<Long> getIds() {
        return ids;
    }

    public void setIds(List<Long> ids) {
        this.ids = ids;
    }

    public String getBillStateName() {
        return billStateName;
    }

    public void setBillStateName(String billStateName) {
        this.billStateName = billStateName;
    }

    /**
     * 单据编号
     */
    public java.lang.String getBillCode() {
        return billCode;
    }

    /**
     * 单据编号
     */
    public void setBillCode(java.lang.String billCode) {
        this.billCode = billCode;
    }
    /**
     * 年度
     */
    public java.lang.String getYear() {
        return year;
    }

    /**
     * 年度
     */
    public void setYear(java.lang.String year) {
        this.year = year;
    }
    /**
     * 经营指标（万元）
     */
    public java.lang.String getManagementIndexMny() {
        return managementIndexMny;
    }

    /**
     * 经营指标（万元）
     */
    public void setManagementIndexMny(java.lang.String managementIndexMny) {
        this.managementIndexMny = managementIndexMny;
    }
    /**
     * 下达人
     */
    @ReferSerialTransfer(referCode="idm-employee")
    public java.lang.Long getEmployeeId() {
        return employeeId;
    }

    /**
     * 下达人
     */
    @ReferDeserialTransfer
    public void setEmployeeId(java.lang.Long employeeId) {
        this.employeeId = employeeId;
    }
    /**
     * 下达人名称
     */
    public java.lang.String getEmployeeName() {
        return employeeName;
    }

    /**
     * 下达人名称
     */
    public void setEmployeeName(java.lang.String employeeName) {
        this.employeeName = employeeName;
    }
    /**
     * 下达日期
     */
    public java.util.Date getAssignDate() {
        return assignDate;
    }

    /**
     * 下达日期
     */
    public void setAssignDate(java.util.Date assignDate) {
        this.assignDate = assignDate;
    }
    /**
     * 单据状态（审批必须字段）
     */
    public java.lang.Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态（审批必须字段）
     */
    public void setBillState(java.lang.Integer billState) {
        this.billState = billState;
    }
    /**
     * 创建人名称
     */
    public java.lang.String getCreateUserName() {
        return createUserName;
    }

    /**
     * 创建人名称
     */
    public void setCreateUserName(java.lang.String createUserName) {
        this.createUserName = createUserName;
    }

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
}
