package com.ejianc.business.market.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.Date;

/**
 * @Author mrsir_wxp
 * @Date 2020/5/11 商机登记实体
 * @Description BusinessOpportunityEntity
 */

@TableName("ejc_market_opportunity")
public class BusinessOpportunityEntity  extends BaseEntity {

    private static final long serialVersionUID = 2779265683203439571L;

    /**
     * 单据状态
     */
    @TableField(value = "bill_state")
    private Integer billState;

    /**
     * 工程名称
     */
    @TableField(value = "engineering_name")
    private String engineeringName;

    /**
     * 所属组织
     */
    @TableField(value = "org_id")
    private Long orgId;

    /**
     * 工程编码
     */
    @TableField(value = "bill_code")
    private String billCode;

    /**
     * 工程类型id
     */
    @TableField(value = "engineering_type")
    private Long engineeringType;

    /**
     * 工程类型名称
     */
    @TableField(value = "engineering_type_name")
    private String engineeringTypeName;

    /**
     * 信息来源
     */
    @TableField(value = "info_source")
    private Long infoSource;

    /**
     * 信息来源名称
     */
    @TableField(value = "info_source_name")
    private String infoSourceName;

    /**
     * 跟踪人
     */
    @TableField(value = "follow_person")
    private Long followPerson;

    /**
     * 跟踪人名称
     */
    @TableField(value = "follow_person_name")
    private String followPersonName;

    /**
     * 跟踪人电话
     */
    @TableField(value = "follow_person_phone")
    private String followPersonPhone;

    /**
     * 项目阶段
     */
    @TableField(value = "engineering_stage")
    private Long engineeringStage;

    /**
     * 项目阶段名称
     */
    @TableField(value = "engineering_stage_name")
    private String engineeringStageName;

    /**
     * 地区
     */
    @TableField(value = "area")
    private String area;

    /**
     * 详细地址
     */
    @TableField(value = "address")
    private String address;

    /**
     * 建设单位
     */
    @TableField(value = "construction_unit")
    private Long constructionUnit;

    /**
     * 建设单位名称
     */
    @TableField(value = "construction_unit_name")
    private String constructionUnitName;

    /**
     * 联系人
     */
    @TableField(value = "connect_person")
    private String connectPerson;

    /**
     * 联系电话
     */
    @TableField(value = "connect_phone")
    private String connectPhone;

    /**
     * 投资主体
     */
    @TableField(value = "investor")
    private Long investor;

    /**
     * 资金来源
     */
    @TableField(value = "funds_source")
    private String fundsSource;

    /**
     * 总造价(万元)
     */
    @TableField(value = "cost_total")
    private BigDecimal costTotal;

    /**
     * 招标形式
     */
    @TableField(value = "bidding_form")
    private Long biddingForm;

    /**
     * 招标形式名称
     */
    @TableField(value = "bidding_form_name")
    private String biddingFormName;

    /**
     * 预计招标日期
     */
    @TableField(value = "estimated_bidding_date")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date estimatedBiddingDate;

    /**
     * 计划开工日期
     */
    @TableField(value = "planned_commencement_date")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date plannedCommencementDate;

    /**
     * 计划竣工日期
     */
    @TableField(value = "planned_finish_date")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date plannedFinishDate;

    /**
     * 工程概况
     */
    @TableField(value = "project_overview")
    private String projectOverview;

    /**
     * 建筑面积(㎡)
     */
    @TableField(value = "built_area")
    private BigDecimal builtArea;

    /**
     * 结构类型
     */
    @TableField(value = "structure_type")
    private Long structureType;

    /**
     * 工程用途
     */
    @TableField(value = "engineering_purpose")
    private Long engineeringPurpose;

    /**
     * 质量等级
     */
    @TableField(value = "quality_leave")
    private Long qualityLeave;

    /**
     * 是否立项
     */
    @TableField(value = "project_is_set")
    private Boolean projectIsSet;

    /**
     * 项目立项单据id
     */
    @TableField(value = "project_set_id")
    private Long projectSetId;

    @TableField(value="provinces")
    private java.lang.String provinces; // 省市区
    @TableField(value="jan_an_mny")
    private java.math.BigDecimal janAnMny; // 建安费用（亿元）
    @TableField(value="duty_org_id")
    private java.lang.Long dutyOrgId; // 责任单位id
    @TableField(value="duty_org_name")
    private java.lang.String dutyOrgName; // 责任单位
    @TableField(value="is_flag")
    private java.lang.String isFlag; // 是否需要集团牵头推进
    @TableField(value="key_personnel")
    private java.lang.String keyPersonnel; // 需要协调的关键人员
    @TableField(value="competitor")
    private java.lang.String competitor; // 潜在竞争对手
    @TableField(value="business_model")
    private java.lang.String businessModel; // 经营模式
    @TableField(value="capital")
    private java.math.BigDecimal capital; // 所需集团提供资金
    @TableField(value="start_date")
    private java.util.Date startDate; // 预计启动时间
    @TableField(value="project_type_id")
    private java.lang.Long projectTypeId; // 项目类别id
    @TableField(value="project_type_name")
    private java.lang.String projectTypeName; // 项目类别
    @TableField(value="significance")
    private java.lang.String significance; // 重要性

    public String getProvinces() {
        return provinces;
    }

    public void setProvinces(String provinces) {
        this.provinces = provinces;
    }

    public BigDecimal getJanAnMny() {
        return janAnMny;
    }

    public void setJanAnMny(BigDecimal janAnMny) {
        this.janAnMny = janAnMny;
    }

    public Long getDutyOrgId() {
        return dutyOrgId;
    }

    public void setDutyOrgId(Long dutyOrgId) {
        this.dutyOrgId = dutyOrgId;
    }

    public String getDutyOrgName() {
        return dutyOrgName;
    }

    public void setDutyOrgName(String dutyOrgName) {
        this.dutyOrgName = dutyOrgName;
    }

    public String getIsFlag() {
        return isFlag;
    }

    public void setIsFlag(String isFlag) {
        this.isFlag = isFlag;
    }

    public String getKeyPersonnel() {
        return keyPersonnel;
    }

    public void setKeyPersonnel(String keyPersonnel) {
        this.keyPersonnel = keyPersonnel;
    }

    public String getCompetitor() {
        return competitor;
    }

    public void setCompetitor(String competitor) {
        this.competitor = competitor;
    }

    public String getBusinessModel() {
        return businessModel;
    }

    public void setBusinessModel(String businessModel) {
        this.businessModel = businessModel;
    }

    public BigDecimal getCapital() {
        return capital;
    }

    public void setCapital(BigDecimal capital) {
        this.capital = capital;
    }

    public Date getStartDate() {
        return startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public Long getProjectTypeId() {
        return projectTypeId;
    }

    public void setProjectTypeId(Long projectTypeId) {
        this.projectTypeId = projectTypeId;
    }

    public String getProjectTypeName() {
        return projectTypeName;
    }

    public void setProjectTypeName(String projectTypeName) {
        this.projectTypeName = projectTypeName;
    }

    public String getSignificance() {
        return significance;
    }

    public void setSignificance(String significance) {
        this.significance = significance;
    }

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billType) {
        this.billState = billType;
    }

    public String getEngineeringName() {
        return engineeringName;
    }

    public void setEngineeringName(String engineeringName) {
        this.engineeringName = engineeringName;
    }

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    public Long getEngineeringType() {
        return engineeringType;
    }

    public void setEngineeringType(Long engineeringType) {
        this.engineeringType = engineeringType;
    }

    public Long getInfoSource() {
        return infoSource;
    }

    public void setInfoSource(Long infoSource) {
        this.infoSource = infoSource;
    }

    public Long getFollowPerson() {
        return followPerson;
    }

    public void setFollowPerson(Long followPerson) {
        this.followPerson = followPerson;
    }

    public String getFollowPersonPhone() {
        return followPersonPhone;
    }

    public void setFollowPersonPhone(String followPersonPhone) {
        this.followPersonPhone = followPersonPhone;
    }

    public Long getEngineeringStage() {
        return engineeringStage;
    }

    public void setEngineeringStage(Long engineeringStage) {
        this.engineeringStage = engineeringStage;
    }

    public String getEngineeringStageName() {
        return engineeringStageName;
    }

    public void setEngineeringStageName(String engineeringStageName) {
        this.engineeringStageName = engineeringStageName;
    }

    public String getArea() {
        return area;
    }

    public void setArea(String area) {
        this.area = area;
    }

    public String getAddress() {
        return address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public Long getConstructionUnit() {
        return constructionUnit;
    }

    public void setConstructionUnit(Long constructionUnit) {
        this.constructionUnit = constructionUnit;
    }

    public String getConnectPerson() {
        return connectPerson;
    }

    public void setConnectPerson(String connectPerson) {
        this.connectPerson = connectPerson;
    }

    public String getConnectPhone() {
        return connectPhone;
    }

    public void setConnectPhone(String connectPhone) {
        this.connectPhone = connectPhone;
    }

    public Long getInvestor() {
        return investor;
    }

    public void setInvestor(Long investor) {
        this.investor = investor;
    }

    public String getFundsSource() {
        return fundsSource;
    }

    public void setFundsSource(String fundsSource) {
        this.fundsSource = fundsSource;
    }

    public BigDecimal getCostTotal() {
        return costTotal;
    }

    public void setCostTotal(BigDecimal costTotal) {
        this.costTotal = costTotal;
    }

    public Long getBiddingForm() {
        return biddingForm;
    }

    public void setBiddingForm(Long biddingForm) {
        this.biddingForm = biddingForm;
    }

    public Date getEstimatedBiddingDate() {
        return estimatedBiddingDate;
    }

    public void setEstimatedBiddingDate(Date estimatedBiddingDate) {
        this.estimatedBiddingDate = estimatedBiddingDate;
    }

    public Date getPlannedCommencementDate() {
        return plannedCommencementDate;
    }

    public void setPlannedCommencementDate(Date plannedCommencementDate) {
        this.plannedCommencementDate = plannedCommencementDate;
    }

    public Date getPlannedFinishDate() {
        return plannedFinishDate;
    }

    public void setPlannedFinishDate(Date plannedFinishDate) {
        this.plannedFinishDate = plannedFinishDate;
    }

    public String getProjectOverview() {
        return projectOverview;
    }

    public void setProjectOverview(String projectOverview) {
        this.projectOverview = projectOverview;
    }

    public BigDecimal getBuiltArea() {
        return builtArea;
    }

    public void setBuiltArea(BigDecimal builtArea) {
        this.builtArea = builtArea;
    }

    public Long getStructureType() {
        return structureType;
    }

    public void setStructureType(Long structureType) {
        this.structureType = structureType;
    }

    public Long getEngineeringPurpose() {
        return engineeringPurpose;
    }

    public void setEngineeringPurpose(Long engineeringPurpose) {
        this.engineeringPurpose = engineeringPurpose;
    }

    public Long getQualityLeave() {
        return qualityLeave;
    }

    public void setQualityLeave(Long qualityLeave) {
        this.qualityLeave = qualityLeave;
    }

    public String getEngineeringTypeName() {
        return engineeringTypeName;
    }

    public void setEngineeringTypeName(String engineeringTypeName) {
        this.engineeringTypeName = engineeringTypeName;
    }

    public String getInfoSourceName() {
        return infoSourceName;
    }

    public void setInfoSourceName(String infoSourceName) {
        this.infoSourceName = infoSourceName;
    }

    public String getFollowPersonName() {
        return followPersonName;
    }

    public void setFollowPersonName(String followPersonName) {
        this.followPersonName = followPersonName;
    }

    public String getConstructionUnitName() {
        return constructionUnitName;
    }

    public void setConstructionUnitName(String constructionUnitName) {
        this.constructionUnitName = constructionUnitName;
    }

    public String getBiddingFormName() {
        return biddingFormName;
    }

    public void setBiddingFormName(String biddingFormName) {
        this.biddingFormName = biddingFormName;
    }

    public Boolean getProjectIsSet() {
        return projectIsSet;
    }

    public void setProjectIsSet(Boolean projectIsSet) {
        this.projectIsSet = projectIsSet;
    }

    public Long getProjectSetId() {
        return projectSetId;
    }

    public void setProjectSetId(Long projectSetId) {
        this.projectSetId = projectSetId;
    }
}
