package com.ejianc.business.market.controller;

import java.io.Serializable;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.market.bean.BidReviewDetailEntity;
import com.ejianc.business.market.bean.BidReviewEntity;
import com.ejianc.business.market.service.IBidReviewDetailService;
import com.ejianc.business.market.utils.TreeNodeBUtil;
import com.ejianc.business.market.vo.BidReviewVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ResultAsTree;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.market.service.IBidReviewService;

/**
 * 投标评审
 * 
 * @author generator
 * 
 */
@Controller
@RequestMapping("bidReview")
public class BidReviewController implements Serializable {
	private static final long serialVersionUID = 1L;
	
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "MARKET_BIDREVIEW";//此处需要根据实际修改
    
    @Autowired
    private IBidReviewService service;

    @Autowired
    private IBidReviewDetailService bidReviewDetailService;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<BidReviewVO> saveOrUpdate(@RequestBody BidReviewVO saveorUpdateVO) {
    	BidReviewEntity entity = BeanMapper.map(saveorUpdateVO, BidReviewEntity.class);

        LambdaQueryWrapper<BidReviewEntity> query = new LambdaQueryWrapper<>();
        // 区别新增、修改，查询的时候排除自己
        if (saveorUpdateVO.getId()!=null){
            query.ne(BidReviewEntity::getId, saveorUpdateVO.getId());
        }
        // 校验相同合同下是否已存在自由态或审批中
        query.eq(BidReviewEntity::getProjectId, saveorUpdateVO.getProjectId());
        query.in(BidReviewEntity::getBillState,0,1,2,3,5);
        query.eq(BidReviewEntity::getDr,0);
        List<BidReviewEntity> entities =  service.list(query);
        if (CollectionUtils.isNotEmpty(entities)){
            throw new BusinessException("一个商机只能做一次投标评审！");
        }
    	if(entity.getId() == null || entity.getId() == 0){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
    	service.saveOrUpdate(entity, false);
        //明细列表
        List<BidReviewDetailEntity> bidReviewDetailEntityList = entity.getBidReviewDetailVos();
        //编码对应主键
        Map<String, Long> map = new HashMap<>();
        //遍历获取真实主键
        for (BidReviewDetailEntity bidReviewDetailEntity : bidReviewDetailEntityList) {
            map.put(bidReviewDetailEntity.getTid(), bidReviewDetailEntity.getId());
        }
        //设置子节点parentId
        for (BidReviewDetailEntity bidReviewDetailEntity : bidReviewDetailEntityList) {
            bidReviewDetailEntity.setParentId(map.get(bidReviewDetailEntity.getTpid()));
            bidReviewDetailService.saveOrUpdate(bidReviewDetailEntity);
        }
    	BidReviewVO vo = BeanMapper.map(entity, BidReviewVO.class);
        vo.setBidReviewDetailVos(TreeNodeBUtil.buildTree(vo.getBidReviewDetailVos()));
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }
    
    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<BidReviewVO> queryDetail(Long id) {
    	BidReviewEntity entity = service.selectById(id);
    	BidReviewVO vo = BeanMapper.map(entity, BidReviewVO.class);
        vo.setBidReviewDetailVos(TreeNodeBUtil.buildTree(vo.getBidReviewDetailVos()));
        return CommonResponse.success("查询详情数据成功！",vo);
    }
    
    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<BidReviewVO> vos) {
        service.removeByIds(vos.stream().map(BidReviewVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }
    
    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("proposerName");
        fuzzyFields.add("reviewTime");
        fuzzyFields.add("billState");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));

        IPage<BidReviewEntity> page = service.queryPage(param,false);
        IPage<BidReviewVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), BidReviewVO.class));

        List<BidReviewEntity> bidReviewEntityList = service.queryList(param,false);
        List<Map> resultMapList = BeanMapper.mapList(bidReviewEntityList, Map.class);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("records", ResultAsTree.createTreeData(resultMapList));
        return CommonResponse.success("查询列表数据成功！",jsonObject);
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<BidReviewEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("BidReview-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refBidReviewData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<BidReviewVO>> refBidReviewData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<BidReviewEntity> page = service.queryPage(param,false);
        IPage<BidReviewVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), BidReviewVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }
}
