package com.ejianc.business.market.service;

import com.ejianc.business.market.bean.BusinessOpportunityEntity;
import com.ejianc.business.market.vo.BusinessOpportunityExportVO;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.IBaseService;

import java.util.List;

public interface IBusinessOpportunityService extends IBaseService<BusinessOpportunityEntity> {
    BusinessOpportunityEntity insertOrUpdate(BusinessOpportunityEntity entity);
    BusinessOpportunityEntity queryDetail(Long id);
    List<BusinessOpportunityExportVO> queryExportList(QueryParam param);

    /**
     * 根据项目Id查询对应的商机详情
     *
     * @param projectId
     * @return
     */
    BusinessOpportunityEntity selectByProjectId(Long projectId);
}
