/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.market.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.market.bean.BidReviewDetailEntity;
import com.ejianc.business.market.bean.BidReviewEntity;
import com.ejianc.business.market.service.IBidReviewDetailService;
import com.ejianc.business.market.service.IBidReviewService;
import com.ejianc.business.market.utils.TreeNodeBUtil;
import com.ejianc.business.market.vo.BidReviewVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ResultAsTree;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"bidReview"})
public class BidReviewController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "MARKET_BIDREVIEW";
    @Autowired
    private IBidReviewService service;
    @Autowired
    private IBidReviewDetailService bidReviewDetailService;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<BidReviewVO> saveOrUpdate(@RequestBody BidReviewVO saveorUpdateVO) {
        BidReviewEntity entity = (BidReviewEntity)((Object)BeanMapper.map((Object)((Object)saveorUpdateVO), BidReviewEntity.class));
        LambdaQueryWrapper query = new LambdaQueryWrapper();
        if (saveorUpdateVO.getId() != null) {
            query.ne(BaseEntity::getId, (Object)saveorUpdateVO.getId());
        }
        query.eq(BidReviewEntity::getProjectId, (Object)saveorUpdateVO.getProjectId());
        query.in(BidReviewEntity::getBillState, new Object[]{0, 1, 2, 3, 5});
        query.eq(BaseEntity::getDr, (Object)0);
        List entities = this.service.list((Wrapper)query);
        if (CollectionUtils.isNotEmpty((Collection)entities)) {
            throw new BusinessException("\u4e00\u4e2a\u5546\u673a\u53ea\u80fd\u505a\u4e00\u6b21\u6295\u6807\u8bc4\u5ba1\uff01");
        }
        if (entity.getId() == null || entity.getId() == 0L) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        this.service.saveOrUpdate((Object)entity, false);
        List<BidReviewDetailEntity> bidReviewDetailEntityList = entity.getBidReviewDetailVos();
        HashMap<String, Long> map = new HashMap<String, Long>();
        for (BidReviewDetailEntity bidReviewDetailEntity : bidReviewDetailEntityList) {
            map.put(bidReviewDetailEntity.getTid(), bidReviewDetailEntity.getId());
        }
        for (BidReviewDetailEntity bidReviewDetailEntity : bidReviewDetailEntityList) {
            bidReviewDetailEntity.setParentId((Long)map.get(bidReviewDetailEntity.getTpid()));
            this.bidReviewDetailService.saveOrUpdate((Object)bidReviewDetailEntity);
        }
        BidReviewVO vo = (BidReviewVO)((Object)BeanMapper.map((Object)((Object)entity), BidReviewVO.class));
        vo.setBidReviewDetailVos(TreeNodeBUtil.buildTree(vo.getBidReviewDetailVos()));
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<BidReviewVO> queryDetail(Long id) {
        BidReviewEntity entity = (BidReviewEntity)((Object)this.service.selectById(id));
        BidReviewVO vo = (BidReviewVO)((Object)BeanMapper.map((Object)((Object)entity), BidReviewVO.class));
        vo.setBidReviewDetailVos(TreeNodeBUtil.buildTree(vo.getBidReviewDetailVos()));
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<BidReviewVO> vos) {
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("orgName");
        fuzzyFields.add("managerName");
        fuzzyFields.add("bidPrice");
        fuzzyFields.add("biddingFormName");
        fuzzyFields.add("proposerName");
        fuzzyFields.add("reviewTime");
        fuzzyFields.add("billState");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), BidReviewVO.class));
        List bidReviewEntityList = this.service.queryList(param, false);
        List resultMapList = BeanMapper.mapList((Iterable)bidReviewEntityList, Map.class);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("records", (Object)ResultAsTree.createTreeData((List)resultMapList));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)jsonObject);
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("BidReview-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refBidReviewData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<BidReviewVO>> refBidReviewData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), BidReviewVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }
}

