/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.market.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.market.bean.ProjectPlanEntity;
import com.ejianc.business.market.service.IProjectPlanService;
import com.ejianc.business.market.vo.ProjectPlanVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"projectPlan"})
public class ProjectPlanController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IAttachmentApi iAttachmentApi;
    private static final String BILL_CODE = "Project_Plan_Code";
    @Autowired
    private IProjectPlanService service;
    @Autowired
    private SessionManager sessionManager;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<ProjectPlanVO> saveOrUpdate(@RequestBody ProjectPlanVO saveorUpdateVO) {
        ProjectPlanEntity entity = (ProjectPlanEntity)((Object)BeanMapper.map((Object)((Object)saveorUpdateVO), ProjectPlanEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        if (entity.getStatus() == null) {
            entity.setStatus("\u5426");
        }
        this.service.saveOrUpdate((Object)entity, false);
        ProjectPlanVO vo = (ProjectPlanVO)((Object)BeanMapper.map((Object)((Object)entity), ProjectPlanVO.class));
        if (saveorUpdateVO.getOldId() != null) {
            ProjectPlanEntity oldEntity = (ProjectPlanEntity)((Object)this.service.selectById(saveorUpdateVO.getOldId()));
            oldEntity.setStatus("\u662f");
            if (oldEntity.getNewId() == null) {
                oldEntity.setNewId(vo.getId());
            }
            this.service.saveOrUpdate((Object)oldEntity, false);
        }
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @GetMapping(value={"/getValidate"})
    @ResponseBody
    public CommonResponse<List> getValidate(@RequestParam(value="id", required=false) Long id, @RequestParam(value="projectId") Long projectId) {
        LambdaQueryWrapper query = new LambdaQueryWrapper();
        if (id != null) {
            query.ne(BaseEntity::getId, (Object)id);
        }
        query.eq(ProjectPlanEntity::getProjectId, (Object)projectId);
        query.in(ProjectPlanEntity::getBillState, new Object[]{0, 2, 5});
        query.eq(BaseEntity::getDr, (Object)0);
        List entities = this.service.list((Wrapper)query);
        if (CollectionUtils.isNotEmpty((Collection)entities)) {
            throw new BusinessException("\u4e00\u4e2a\u9879\u76ee\u53ea\u80fd\u5b58\u5728\u4e00\u4e2a\u81ea\u7531\u6001\u6216\u5ba1\u6279\u4e2d\u7684\u5355\u636e\uff01");
        }
        LambdaQueryWrapper query1 = new LambdaQueryWrapper();
        query1.eq(ProjectPlanEntity::getProjectId, (Object)projectId);
        query1.in(ProjectPlanEntity::getBillState, new Object[]{1, 3});
        query1.eq(BaseEntity::getDr, (Object)0);
        List entities1 = this.service.list((Wrapper)query1);
        for (int i = 0; i < entities1.size(); ++i) {
            ProjectPlanEntity entities2 = (ProjectPlanEntity)((Object)entities1.get(i));
            if (((ProjectPlanEntity)((Object)entities1.get(i))).getPlanSummary().equals("\u7ae3\u5de5\u603b\u7ed3")) {
                throw new BusinessException("\u8be5\u9879\u76ee\u5df2\u7ae3\u5de5\uff01");
            }
            if (entities2.getPlanSummary().equals("\u4e00\u6708")) {
                entities2.setPlanSummary("1");
                continue;
            }
            if (entities2.getPlanSummary().equals("\u4e8c\u6708")) {
                entities2.setPlanSummary("2");
                continue;
            }
            if (entities2.getPlanSummary().equals("\u4e09\u6708(\u4e00\u5b63\u5ea6)")) {
                entities2.setPlanSummary("3");
                continue;
            }
            if (entities2.getPlanSummary().equals("\u56db\u6708")) {
                entities2.setPlanSummary("4");
                continue;
            }
            if (entities2.getPlanSummary().equals("\u4e94\u6708")) {
                entities2.setPlanSummary("5");
                continue;
            }
            if (entities2.getPlanSummary().equals("\u516d\u6708(\u4e8c\u5b63\u5ea6)")) {
                entities2.setPlanSummary("6");
                continue;
            }
            if (entities2.getPlanSummary().equals("\u4e03\u6708")) {
                entities2.setPlanSummary("7");
                continue;
            }
            if (entities2.getPlanSummary().equals("\u516b\u6708")) {
                entities2.setPlanSummary("8");
                continue;
            }
            if (entities2.getPlanSummary().equals("\u4e5d\u6708(\u4e09\u5b63\u5ea6)")) {
                entities2.setPlanSummary("9");
                continue;
            }
            if (entities2.getPlanSummary().equals("\u5341\u6708")) {
                entities2.setPlanSummary("10");
                continue;
            }
            if (entities2.getPlanSummary().equals("\u5341\u4e00\u6708")) {
                entities2.setPlanSummary("11");
                continue;
            }
            if (entities2.getPlanSummary().equals("\u5341\u4e8c\u6708")) {
                entities2.setPlanSummary("12");
                continue;
            }
            if (!entities2.getPlanSummary().equals("\u5e74\u5ea6\u603b\u7ed3")) continue;
            entities2.setPlanSummary("13");
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u6570\u636e\u6210\u529f\uff01", (Object)entities1);
    }

    @RequestMapping(value={"/queryCopyDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<ProjectPlanVO> queryCopyDetail(Long id) {
        ProjectPlanEntity entity = (ProjectPlanEntity)((Object)this.service.selectById(id));
        ProjectPlanVO vo = (ProjectPlanVO)((Object)BeanMapper.map((Object)((Object)entity), ProjectPlanVO.class));
        vo.setBillCode(null);
        vo.setCreateTime(null);
        vo.setCreateUserCode(null);
        vo.setUpdateTime(null);
        vo.setUpdateUserCode(null);
        vo.setBillState(null);
        vo.setDr(null);
        vo.setId(IdWorker.getId());
        vo.setOldId(id);
        vo.setYear(null);
        vo.setPlanSummaryId(null);
        vo.setStatus(null);
        vo.setNewId(null);
        CommonResponse response = this.iAttachmentApi.copyFilesFromSourceBillToTargetBill(id.toString(), "BT220304000000001", "imgUpload", vo.getId().toString(), "BT220304000000001", "imgUpload");
        if (!response.isSuccess()) {
            return CommonResponse.error((String)response.getMsg());
        }
        vo.setId(null);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<ProjectPlanVO> queryDetail(Long id) {
        ProjectPlanEntity entity = (ProjectPlanEntity)((Object)this.service.selectById(id));
        ProjectPlanVO vo = (ProjectPlanVO)((Object)BeanMapper.map((Object)((Object)entity), ProjectPlanVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ProjectPlanVO> vos) {
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<ProjectPlanVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("orgName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("peojectPlanProgress");
        fuzzyFields.add("signDate");
        fuzzyFields.add("createTime");
        fuzzyFields.add("billState");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        UserContext userContextCache = this.sessionManager.getUserContext();
        String authOrgIds = userContextCache.getAuthOrgIds();
        List orgVOList = null;
        orgVOList = StringUtils.isNotBlank((CharSequence)authOrgIds) ? (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        ArrayList commonOrgIds = new ArrayList();
        ArrayList departmentIds = new ArrayList();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                departmentIds.add(org.getId());
            } else {
                commonOrgIds.add(org.getId());
            }
        });
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("orgId", new Parameter("in", commonOrgIds));
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            param.getParams().put("projectDepartmentId", new Parameter("in", departmentIds));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), ProjectPlanVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("ProjectPlan-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refProjectPlanData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<ProjectPlanVO>> refProjectPlanData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), ProjectPlanVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }
}

