/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.market.utils;

import com.ejianc.business.utils.ITreeNodeB;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TreeNodeBUtil {
    public static <T extends ITreeNodeB> List<T> buildTree(List<T> values) {
        ITreeNodeB parentNode;
        HashMap<Long, ITreeNodeB> nodeMap = new HashMap<Long, ITreeNodeB>();
        ArrayList<ITreeNodeB> result = new ArrayList<ITreeNodeB>();
        ArrayList<ITreeNodeB> emptyValueList = new ArrayList<ITreeNodeB>();
        for (ITreeNodeB value : values) {
            if (null == value.getParentID() || value.getParentID() == 0L) {
                result.add(value);
            } else {
                parentNode = (ITreeNodeB)nodeMap.get(value.getParentID());
                if (parentNode == null) {
                    emptyValueList.add(value);
                } else {
                    parentNode.getChildren().add(value);
                }
            }
            nodeMap.put(value.getNodeID(), value);
        }
        if (!emptyValueList.isEmpty()) {
            for (ITreeNodeB value : emptyValueList) {
                parentNode = (ITreeNodeB)nodeMap.get(value.getParentID());
                if (parentNode == null) {
                    result.add(value);
                    continue;
                }
                parentNode.getChildren().add(value);
            }
        }
        return result;
    }

    public static List<Map<String, Object>> createTreeData(List<Map> list) {
        ArrayList<Map<String, Object>> resp = new ArrayList<Map<String, Object>>();
        ArrayList<String> rootItems = new ArrayList<String>();
        HashMap<String, Map> listMap = new HashMap<String, Map>();
        for (Map item : list) {
            listMap.put(item.get("dutyDetailId").toString(), item);
        }
        for (int i = 0; i < list.size(); ++i) {
            Map item;
            item = list.get(i);
            String parentId = item.get("parentId") != null ? item.get("parentId").toString() : "";
            Map parent = (Map)listMap.get(parentId);
            if (parent != null) {
                List child = (List)parent.get("children");
                if (child != null) {
                    child.add(item);
                    continue;
                }
                ArrayList<Map> children = new ArrayList<Map>();
                children.add(item);
                parent.put("children", children);
                continue;
            }
            rootItems.add(item.get("dutyDetailId").toString());
        }
        for (String rootId : rootItems) {
            resp.add((Map<String, Object>)listMap.get(rootId));
        }
        return resp;
    }
}

