package com.ejianc.business.market.service.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.framework.skeleton.billState.service.CommonUpdateBillStateService;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.market.bean.BusinessOpportunityEntity;
import com.ejianc.business.market.bean.ProjectRegisterEntity;
import com.ejianc.business.market.mapper.ProjectRegisterMapper;
import com.ejianc.business.market.service.IBusinessOpportunityService;
import com.ejianc.business.market.service.IProjectRegisterService;
import com.ejianc.business.market.vo.ProjectRegisterVO;
import com.ejianc.business.material.api.IStoreApi;
import com.ejianc.business.material.vo.StoreVO;
import com.ejianc.foundation.orgcenter.api.IEmployeeApi;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.permission.vo.RoleUserRelationVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.wzxtUserProject.api.IWzxtUserProjectRelationApi;
import com.ejianc.foundation.wzxtUserProject.vo.WzxtUserProjectRelationVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.ComplexParam;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.support.idworker.util.IdWorker;
import org.springframework.transaction.annotation.Transactional;

@Service("projectRegisterService")
public class ProjectRegisterServiceImpl extends BaseServiceImpl<ProjectRegisterMapper, ProjectRegisterEntity> implements IProjectRegisterService {

    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private final String DEFAULT_RULE_CODE = "marketProjectRegister";

    @Autowired
    private ProjectRegisterMapper projectRegisterMapper;

    @Autowired
    private IOrgApi orgApi;

    @Autowired
    private IBusinessOpportunityService businessOpportunityService;

    @Autowired
    private IWzxtUserProjectRelationApi wzxtUserProjectRelationApi;

    @Autowired
    private IBillCodeApi billCodeApi;

    @Autowired
    private IEmployeeApi employeeApi;

    @Autowired
    private SessionManager sessionManager;

    @Autowired
    private IStoreApi storeApi;
    @Autowired
    private CommonUpdateBillStateService commonUpdateBillStateService;

    @Override
    public ProjectRegisterEntity queryById(Long id) {
        return projectRegisterMapper.selectById(id);
    }

    @Override
    public ProjectRegisterVO saveProject(ProjectRegisterVO projectRegisterVO) {
        ProjectRegisterEntity saveEntity = BeanMapper.map(projectRegisterVO, ProjectRegisterEntity.class);
        //处理项目地区，转为省市区
        if(StringUtils.isNotBlank(saveEntity.getArea())){
            String regex = "((?<provinceAndCity>[^市]+市|.*?自治州|.*?区|.*县)(?<town>[^区]+区|.*?市|.*?县|.*?路|.*?街|.*?道|.*?镇|.*?旗)(?<detailAddress>.*))";
            Matcher matcher = Pattern.compile(regex).matcher(saveEntity.getArea());
            while(matcher.find()){
                saveEntity.setRegion(matcher.group("town"));
                String regex2 = "((?<province>[^省]+省|.+自治区|上海市|北京市|天津市|重庆市|上海|北京|天津|重庆|香港特别行政区|澳门特别行政区)(?<city>.*))";
                Matcher matcher2 = Pattern.compile(regex2).matcher(matcher.group("provinceAndCity"));
                while (matcher2.find()){
                    saveEntity.setProvince(matcher2.group("province"));
                    String city = matcher2.group("city");
                    if(StringUtils.isBlank(city)){
                        saveEntity.setCity(saveEntity.getProvince());
                    }else{
                        saveEntity.setCity(matcher2.group("city"));
                    }
                }
            }
        }
        //项目部
        OrgVO projectDepartment = null;
        BusinessOpportunityEntity buOpr = null;
        boolean storeFlag = false;
        boolean add = false;
        if(null != projectRegisterVO.getId()) {
            ProjectRegisterEntity dbEntity = queryById(projectRegisterVO.getId());
            saveEntity.setManageChargeRatio(dbEntity.getManageChargeRatio());
            saveEntity.setCode(dbEntity.getCode());
            saveEntity.setTenantId(dbEntity.getTenantId());
            saveEntity.setCreateTime(dbEntity.getCreateTime());
            saveEntity.setCreateUserCode(dbEntity.getCreateUserCode());
            saveEntity.setSyncEsFlag(dbEntity.getSyncEsFlag());
            saveEntity.setDr(dbEntity.getDr());

            if(!projectRegisterVO.getOrgId().equals(dbEntity.getOrgId())) {
                //项目所属组织修改
                projectDepartment = (OrgVO) getRespData(orgApi.getOneById(dbEntity.getProjectDepartmentId()), true, "保存失败，查询所属组织信息失败。");
                projectDepartment.setParentId(projectRegisterVO.getOrgId());
            }
            if(!projectRegisterVO.getName().equals(dbEntity.getName())) {
                if(null == projectDepartment) {
                    projectDepartment = (OrgVO) getRespData(orgApi.getOneById(dbEntity.getProjectDepartmentId()), true, "保存失败，查询所属组织信息失败。");
                }
                projectDepartment.setName(projectRegisterVO.getName());
                projectDepartment.setShortName(projectRegisterVO.getShortName());
            }

            if(!projectRegisterVO.getStatus().equals(dbEntity.getStatus())) {
                if(null == projectDepartment) {
                    projectDepartment = (OrgVO) getRespData(orgApi.getOneById(dbEntity.getProjectDepartmentId()), true, "保存失败，查询所属组织信息失败。");
                }
            }
        } else {
        	storeFlag = true;
            add = true;
            //创建项目部
            projectDepartment = generateProjectDepartment(projectRegisterVO, false);
            saveEntity.setProjectDepartmentId(projectDepartment.getId());
            UserContext userContext = sessionManager.getUserContext();
            //创建人信息
            saveEntity.setCreateUserName(userContext.getUserName());

            //启用状态
            saveEntity.setValidStatus("0");
            //项目状态-在建
            saveEntity.setStatus("2");

            if(null != projectRegisterVO.getBusOpprId()) {
                //复制商机信息
                buOpr = businessOpportunityService.queryDetail(projectRegisterVO.getBusOpprId());
                if(null != buOpr.getProjectIsSet() && buOpr.getProjectIsSet()) {
                    throw new BusinessException("新增失败，该商机已立项！");
                }
                saveEntity.setArea(buOpr.getArea());
                saveEntity.setAddress(buOpr.getAddress());
                saveEntity.setInvestor(buOpr.getInvestor());
                saveEntity.setFundsSource(buOpr.getFundsSource());
                saveEntity.setCostTotal(buOpr.getCostTotal());
                saveEntity.setBiddingForm(buOpr.getBiddingForm());
                saveEntity.setBiddingFormName(buOpr.getBiddingFormName());
                saveEntity.setPlannedCommencementDate(buOpr.getPlannedCommencementDate());
                saveEntity.setPlannedFinishDate(buOpr.getPlannedFinishDate());
                saveEntity.setBuiltArea(buOpr.getBuiltArea());
                saveEntity.setStructureType(buOpr.getStructureType());
                saveEntity.setProjectOverview(buOpr.getProjectOverview());
                //发包单位
                saveEntity.setPubUnitName(buOpr.getConstructionUnitName());
                saveEntity.setPubUnit(buOpr.getConstructionUnit());
                //工程用途
                saveEntity.setEngineeringPurpose(buOpr.getEngineeringPurpose());
                //工程类型
                saveEntity.setEngineeringType(buOpr.getEngineeringType());
                saveEntity.setEngineeringTypeName(buOpr.getEngineeringTypeName());
            }
            if(StringUtils.isBlank(projectRegisterVO.getCode())) {
                saveEntity.setCode(getAutoCode());
            }
        }

        //保存更新项目部信息
        if(null != projectDepartment) {
            projectDepartment.setSourceId(projectRegisterVO.getSourceId());
            if("2".equals(saveEntity.getStatus())){
                projectDepartment.setProjectState(1);
            }else{
                projectDepartment.setProjectState(2);
            }
            logger.info("项目状态：{}，项目部状态：{}",saveEntity.getStatus(),projectDepartment.getProjectState());
            CommonResponse<OrgVO> resp = orgApi.saveOrgInfo(projectDepartment);
            if(!resp.isSuccess()) {
                throw new BusinessException("保存失败，保存项目部信息出错: " + resp.getMsg());
            }
        }

        Map<String, Object> memberMap = getMemberMap(projectRegisterVO);
        if(!memberMap.isEmpty()) {
            //保存新增的成员信息
            CommonResponse<String> resp = employeeApi.manageProjectMembers(memberMap);
            if(!resp.isSuccess()) {
                throw new BusinessException("保存失败，新增成员出错: " + resp.getMsg());
            }
        }
        Map<String, Object> memberUpdateMap = getMemberUpdateMap(projectRegisterVO);
        if(!memberUpdateMap.isEmpty()) {
            //保存新增的成员信息
            CommonResponse<String> resp = employeeApi.manageUpdateProjectMembers(memberUpdateMap);
            if(!resp.isSuccess()) {
                throw new BusinessException("保存失败，新增成员出错: " + resp.getMsg());
            }
        }

        super.saveOrUpdate(saveEntity, false);

        //更新对应商机
        if(null != buOpr) {
            buOpr.setProjectIsSet(true);
            buOpr.setProjectSetId(saveEntity.getId());
            businessOpportunityService.saveOrUpdate(buOpr, false);
        }

        if(storeFlag){
            //创建仓库
            generateStore(saveEntity);
        }
        if(!add){
            //更新下游数据
            commonUpdateBillStateService.updateQuoteData(saveEntity.getId(), "BT200519000000002");
        }
        return BeanMapper.map(saveEntity, ProjectRegisterVO.class);
    }

    /**
     * 获取自动生成编码变校验重复
     *
     * @return
     */
    private String getAutoCode() {
        ProjectRegisterVO project = new ProjectRegisterVO();

        while (null == project.getCode()) {
            String code = getRespData(billCodeApi.getCodeBatchByRuleCode(DEFAULT_RULE_CODE, InvocationInfoProxy.getTenantid()),
                    true, "保存失败，自动生成编码失败！").toString();
            project.setCode(code);
            boolean checkResult = codeUsedCheck(project);
            if(checkResult) {
                project.setCode(null);
            }
        }

        return project.getCode();
    }

    //创建仓库
    private void generateStore(ProjectRegisterEntity saveEntity) {
        StoreVO storeVO = new StoreVO();
        storeVO.setName(saveEntity.getName());
        storeVO.setProjectType("1");
        storeVO.setProjectId(saveEntity.getId());
        storeVO.setProjectName(saveEntity.getName());
        storeVO.setProjectCode(saveEntity.getCode());
        storeVO.setOrgId(saveEntity.getProjectDepartmentId());
        storeVO.setOrgName(saveEntity.getName());
        storeVO.setState("1");
        storeApi.saveOrUpdate(storeVO);
	}

	@Override
    public void saveImportProject(List<ProjectRegisterVO> proList) {
        List<ProjectRegisterEntity> saveProList = new ArrayList<>();
        List<OrgVO> saveDepartmentList = new ArrayList<>();
        ProjectRegisterEntity saveEntity = null;
        OrgVO projectDepartment = null;


        if(CollectionUtils.isNotEmpty(proList)) {
            //批量获取编码
            Long codeCount = proList.stream().filter(item -> StringUtils.isBlank(item.getCode())).count();
            List<String> billCode = (List<String>) getRespData(billCodeApi.getCodeBatchByRuleCode(DEFAULT_RULE_CODE, InvocationInfoProxy.getTenantid(), codeCount.intValue()), true, "导入数据保存失败，自动生成编码失败！");
            int i = 0;

            for(ProjectRegisterVO pro : proList) {
                saveEntity = BeanMapper.map(pro, ProjectRegisterEntity.class);

                //创建项目部
                projectDepartment = generateProjectDepartment(pro, false);
                saveEntity.setProjectDepartmentId(projectDepartment.getId());
                UserContext userContext = sessionManager.getUserContext();
                //创建人信息
                saveEntity.setCreateUserName(userContext.getUserName());
                //启用状态
                saveEntity.setValidStatus("0");
                //默认承包单位为所属组织
                saveEntity.setContractorUnit(saveEntity.getOrgId());
                saveEntity.setContractorUnitName(saveEntity.getOrgName());
                //编码自动生成
                if(StringUtils.isBlank(saveEntity.getCode())) {
                    saveEntity.setCode(billCode.get(i++));
                }

                saveDepartmentList.add(projectDepartment);
                saveProList.add(saveEntity);
            }

            CommonResponse<String> saveResp = orgApi.saveProOrgList(saveDepartmentList);
            if(!saveResp.isSuccess()) {
                logger.error("导入数据保存失败，保存项目部信息失败："  + saveResp.getMsg());
                throw new BusinessException("导入数据保存失败，保存项目部信息失败！");
            }
            super.saveBatch(saveProList);

            for(ProjectRegisterEntity entity : saveProList){
                //创建仓库
                generateStore(entity);
            }
        }
    }

    @Override
    public Map<String, Integer> countProjectNum(QueryParam queryParam) {
        Map<String, Integer> resp = new HashMap<>();
        QueryWrapper<ProjectRegisterEntity> queryWrapper = null;
        ComplexParam c1 = new ComplexParam();
        c1.setLogic(ComplexParam.AND);
        c1.getParams().put("status", new Parameter(QueryParam.EQ, "2"));
        queryParam.getComplexParams().add(c1);
        queryWrapper = changeToQueryWrapper(queryParam);
        resp.put("buildingNum", super.count(queryWrapper));

        queryParam.getComplexParams().remove(c1);
        c1.getParams().put("status", new Parameter(QueryParam.EQ, "3"));
        queryParam.getComplexParams().add(c1);
        queryWrapper = changeToQueryWrapper(queryParam);
        resp.put("finishNum", super.count(queryWrapper));

        return resp;
    }

    @Override
    public boolean codeUsedCheck(ProjectRegisterVO project) {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        queryParam.getParams().put("code", new Parameter(QueryParam.EQ, project.getCode()));
        queryParam.getParams().put("id", new Parameter(QueryParam.NE, project.getId()));

        List<ProjectRegisterEntity> proList = super.queryList(queryParam, false);
        if(CollectionUtils.isNotEmpty(proList)) {
            return true;
        }
        return false;
    }

    @Override
    public void changeValidStatus(ProjectRegisterVO projectRegisterVO) {
        ProjectRegisterEntity e = super.selectById(projectRegisterVO.getId());
        CommonResponse<OrgVO> orgResp = orgApi.getOneById(e.getProjectDepartmentId());
        if(!orgResp.isSuccess()) {
            throw new BusinessException("更改项目状态失败，获取项目部信息失败！");
        }
        OrgVO department = orgResp.getData();
        if("1".equals(projectRegisterVO.getValidStatus())) {
            //停用
            department.setState(0);
            e.setValidStatus(projectRegisterVO.getValidStatus());
        } else if("0".equals(projectRegisterVO.getValidStatus())) {
            //启用
            department.setState(1);
            e.setValidStatus(projectRegisterVO.getValidStatus());
        } else {
            throw new BusinessException("更改项目状态失败，非法的项目状态！");
        }
        CommonResponse<OrgVO> resp = orgApi.saveOrgInfo(department);
        if(!resp.isSuccess()) {
            throw new BusinessException("更改项目状态失败失败，更新项目部信息出错: " + resp.getMsg());
        }
        super.saveOrUpdate(e);
    }

    @Override
    public List<Long> queryProIdsByProperties(QueryParam queryParam, boolean queryNewSignedCurYear) {
        QueryWrapper<ProjectRegisterEntity> queryWrapper = changeToQueryWrapper(queryParam);
        queryWrapper.select("id");
        queryWrapper.eq("dr", 0);
        queryWrapper.apply(queryNewSignedCurYear, " date_format(sign_date, '%Y') = date_format(now(), '%Y')");

        List<Object> result = baseMapper.selectObjs(queryWrapper);
        List<Long> ids = new ArrayList<>();
        result.forEach(obj -> ids.add(Long.valueOf(obj.toString())));
        return ids;
    }

    /**
     * 生成项目对应的项目部信息
     *
     * @param projectRegisterVO
     * @return
     */
    private OrgVO generateProjectDepartment(ProjectRegisterVO projectRegisterVO, boolean isSyncProject) {
        CommonResponse<OrgVO> response = orgApi.getOneById(projectRegisterVO.getOrgId());
        OrgVO parentOrg = null;
        if(response.isSuccess()) {
            parentOrg = response.getData();
        } else {
            throw new BusinessException("保存项目信息失败，查询项目所属组织信息失败: " + response.getMsg() );
        }
        if(null == parentOrg) {
            throw new BusinessException("保存项目信息失败，项目所属组织信息不存在。");
        }
        OrgVO projectDepartment = new OrgVO();
        projectDepartment.setId(IdWorker.getId());
        projectDepartment.setParentId(projectRegisterVO.getOrgId());
        projectDepartment.setTenantId(parentOrg.getTenantId());
        projectDepartment.setEnterpriseId(parentOrg.getEnterpriseId());
        projectDepartment.setIsParent(false);
        projectDepartment.setName(projectRegisterVO.getName());
        projectDepartment.setShortName(projectRegisterVO.getName());
        projectDepartment.setSourceId(projectRegisterVO.getSourceId());
        projectDepartment.setState(1);
        //项目部类型
        projectDepartment.setOrgType(OrgVO.ORG_TYPE_DEPARTMENT);
        if(isSyncProject) {
            //同步的项目，其对应项目部的sourceId保存项目的sourceId
            projectDepartment.setSourceId(projectRegisterVO.getSourceId());
        }

        return projectDepartment;
    }

    private Object getRespData(CommonResponse resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }
    private Map<String, Object> getMemberMap(ProjectRegisterVO projectRegisterVO) {
        Map<String, Object> dataMap = new HashMap<>();
        if(CollectionUtils.isNotEmpty(projectRegisterVO.getMembersList())) {
            //保存项目成员
            Map<String, Object> moveMap = new HashMap<>(), parttimeMap = new HashMap<>();

            List<RoleUserRelationVO> relationList = null;
            RoleUserRelationVO tmp = null;
            for(Map<String, Object> member :  projectRegisterVO.getMembersList()) {
                //过滤掉非新增的成员
                if(null != member.get("isAdd") && "true".equals(member.get("isAdd"))) {
                    tmp = new RoleUserRelationVO();
                    tmp.setUserId(null != member.get("userId") ? Long.valueOf(member.get("userId").toString()) : null);
                    tmp.setJobId(null != member.get("jobId") ? Long.valueOf(member.get("jobId").toString()) : null);
                    tmp.setAuthOrgId(projectRegisterVO.getProjectDepartmentId());
                    tmp.setEmployeeId(null != member.get("employeeId") ? Long.valueOf(member.get("employeeId").toString()) : null);
                    tmp.setRoleId(null != member.get("roleId") ? Long.valueOf(member.get("roleId").toString()) : null);
                    if(member.get("postId") != null){
                        JSONObject jsonObject = (JSONObject) JSONObject.toJSON(member.get("postId"));
                        if(jsonObject.get("id") != null){
                            tmp.setPostId(Long.parseLong(jsonObject.get("id").toString()));
                        }
                    }
                    if("move".equals(member.get("type").toString())) {
                        relationList = (List<RoleUserRelationVO>) moveMap.get(tmp.getEmployeeId());
                        if(null == relationList) {
                            relationList = new ArrayList<>();
                        }
                        relationList.add(tmp);
                        moveMap.put(tmp.getEmployeeId().toString(), relationList);
                    } else {
                        relationList = (List<RoleUserRelationVO>) parttimeMap.get(tmp.getEmployeeId());
                        if(null == relationList) {
                            relationList = new ArrayList<>();
                        }
                        relationList.add(tmp);
                        parttimeMap.put(tmp.getEmployeeId().toString(), relationList);
                    }
                }

            }
            if(!moveMap.isEmpty()) {
                Map<String, Object> moveData = new HashMap<>();
                if(moveData.get("postId") != null){
                    JSONObject jsonObject = new JSONObject();
                    jsonObject =(JSONObject) moveMap.get("postId");
                    if(jsonObject.get("id") != null){
                        moveData.put("postId",jsonObject.get("id"));
                    }
                }
                moveData.put("orgId", projectRegisterVO.getProjectDepartmentId());
                moveData.put("detail", moveMap);

                dataMap.put("moveMembers", moveData);
            }
            if(!parttimeMap.isEmpty()) {
                Map<String, Object> parttimeData = new HashMap<>();
                parttimeData.put("orgId", projectRegisterVO.getProjectDepartmentId());
                if(parttimeData.get("postId") != null){
                    JSONObject jsonObject = new JSONObject();
                    jsonObject =(JSONObject) moveMap.get("postId");
                    if(jsonObject.get("id") != null){
                        parttimeData.put("postId",jsonObject.get("id"));
                    }
                }
                parttimeData.put("detail", parttimeMap);

                dataMap.put("parttimeMembers", parttimeData);
            }
        }

        return dataMap;
    }
    private Map<String, Object> getMemberUpdateMap(ProjectRegisterVO projectRegisterVO) {
        Map<String, Object> dataMap = new HashMap<>();
        if(CollectionUtils.isNotEmpty(projectRegisterVO.getMembersList())) {
            //保存项目成员
            Map<String, Object> moveMap = new HashMap<>(),
            parttimeMap = new HashMap<>();

            List<RoleUserRelationVO> relationList = null;
            RoleUserRelationVO tmp = null;
            for(Map<String, Object> member :  projectRegisterVO.getMembersList()) {
                //过滤掉非新增的成员
                if(null != member.get("rowState") && "edit".equals(member.get("rowState"))) {
                    tmp = new RoleUserRelationVO();
                    tmp.setJobId(null != member.get("jobId") ? Long.valueOf(member.get("jobId").toString()) : null);
                    tmp.setEmployeeId(null != member.get("employeeId") ? Long.valueOf(member.get("employeeId").toString()) : null);
                    JSONObject jsonObject = new JSONObject();
                    if(member.get("postId")  != null){
                        jsonObject= (JSONObject) JSONObject.toJSON(member.get("postId"));
                        if(jsonObject.get("id") !=null){
                            tmp.setPostId(Long.parseLong(jsonObject.get("id").toString()));
                        }
                    }

                    relationList = (List<RoleUserRelationVO>) parttimeMap.get(tmp.getEmployeeId());
                    if(null == relationList) {
                        relationList = new ArrayList<>();
                    }
                    relationList.add(tmp);
                    parttimeMap.put(tmp.getEmployeeId().toString(), relationList);
                }
            }

            if(!parttimeMap.isEmpty()) {
                dataMap.put("detail", parttimeMap);
            }
        }

        return dataMap;
    }

	@Override
	public CommonResponse<List<ProjectRegisterVO>> queryProjectByUserId(Long userId) {
		CommonResponse<List<WzxtUserProjectRelationVO>> list = wzxtUserProjectRelationApi.queryProjectByUserId(userId);
		if(list.isSuccess()){
			if(list.getData()!=null&&list.getData().size()>0){
				List<Long> projectIds = new ArrayList<>();
				list.getData().forEach(e -> {
					projectIds.add(e.getProjectId());
				});
				List<ProjectRegisterEntity> entitys = (List<ProjectRegisterEntity>) this.listByIds(projectIds);
				if(entitys!=null&&entitys.size()>0){
					return CommonResponse.success(BeanMapper.mapList(entitys, ProjectRegisterVO.class));
				}
			}
		}else{
			return CommonResponse.error(list.getMsg());
		}
		return CommonResponse.success();
	}

    @Override
    public ProjectRegisterVO saveSyncProject(ProjectRegisterVO projectRegisterVO) {
        ProjectRegisterEntity saveEntity = BeanMapper.map(projectRegisterVO, ProjectRegisterEntity.class);
        //处理项目地区，转为省市区
        if(StringUtils.isNotBlank(saveEntity.getArea())){
            String regex = "((?<provinceAndCity>[^市]+市|.*?自治州|.*?区|.*县)(?<town>[^区]+区|.*?市|.*?县|.*?路|.*?街|.*?道|.*?镇|.*?旗)(?<detailAddress>.*))";
            Matcher matcher = Pattern.compile(regex).matcher(saveEntity.getArea());
            while(matcher.find()){
                saveEntity.setRegion(matcher.group("town"));
                String regex2 = "((?<province>[^省]+省|.+自治区|上海市|北京市|天津市|重庆市|上海|北京|天津|重庆|香港特别行政区|澳门特别行政区)(?<city>.*))";
                Matcher matcher2 = Pattern.compile(regex2).matcher(matcher.group("provinceAndCity"));
                while (matcher2.find()){
                    saveEntity.setProvince(matcher2.group("province"));
                    String city = matcher2.group("city");
                    if(StringUtils.isBlank(city)){
                        saveEntity.setCity(saveEntity.getProvince());
                    }else{
                        saveEntity.setCity(matcher2.group("city"));
                    }
                }
            }
        }
        //项目部
        OrgVO projectDepartment = null;
        BusinessOpportunityEntity buOpr = null;
        boolean storeFlag = false;
        if(null != projectRegisterVO.getId()) {
            ProjectRegisterEntity dbEntity = queryById(projectRegisterVO.getId());
            saveEntity.setManageChargeRatio(dbEntity.getManageChargeRatio());
            saveEntity.setCode(dbEntity.getCode());
            saveEntity.setTenantId(dbEntity.getTenantId());
            saveEntity.setCreateTime(dbEntity.getCreateTime());
            saveEntity.setCreateUserCode(dbEntity.getCreateUserCode());
            saveEntity.setSyncEsFlag(dbEntity.getSyncEsFlag());
            saveEntity.setDr(dbEntity.getDr());

            if(!projectRegisterVO.getOrgId().equals(dbEntity.getOrgId())) {
                //项目所属组织修改
                projectDepartment = (OrgVO) getRespData(orgApi.getOneById(dbEntity.getProjectDepartmentId()), true, "保存失败，查询所属组织信息失败。");
                projectDepartment.setParentId(projectRegisterVO.getOrgId());
            }
            if(!projectRegisterVO.getName().equals(dbEntity.getName())) {
                if(null == projectDepartment) {
                    projectDepartment = (OrgVO) getRespData(orgApi.getOneById(dbEntity.getProjectDepartmentId()), true, "保存失败，查询所属组织信息失败。");
                }
                projectDepartment.setName(projectRegisterVO.getName());
                projectDepartment.setShortName(projectRegisterVO.getName());
            }
            if(StringUtils.isNotBlank(projectRegisterVO.getCode()) && !dbEntity.getCode().equals(projectRegisterVO.getCode())) {
                //项目编码修改
                logger.info("项目[id-{}]编码由-{}改为-{}", dbEntity.getId(), dbEntity.getCode(), projectRegisterVO.getCode());
                saveEntity.setCode(projectRegisterVO.getCode());
            }
        } else {
            storeFlag = true;
            //创建项目部
            projectDepartment = generateProjectDepartment(projectRegisterVO, true);
            saveEntity.setProjectDepartmentId(projectDepartment.getId());
            UserContext userContext = sessionManager.getUserContext();
            //创建人信息
            saveEntity.setCreateUserName(userContext.getUserName());

            //启用状态
            saveEntity.setValidStatus("0");
            //项目状态-在建
            saveEntity.setStatus("2");

            if(null != projectRegisterVO.getBusOpprId()) {
                //复制商机信息
                buOpr = businessOpportunityService.queryDetail(projectRegisterVO.getBusOpprId());
                if(null != buOpr.getProjectIsSet() && buOpr.getProjectIsSet()) {
                    throw new BusinessException("新增失败，该商机已立项！");
                }
                saveEntity.setArea(buOpr.getArea());
                saveEntity.setAddress(buOpr.getAddress());
                saveEntity.setInvestor(buOpr.getInvestor());
                saveEntity.setFundsSource(buOpr.getFundsSource());
                saveEntity.setCostTotal(buOpr.getCostTotal());
                saveEntity.setBiddingForm(buOpr.getBiddingForm());
                saveEntity.setBiddingFormName(buOpr.getBiddingFormName());
                saveEntity.setPlannedCommencementDate(buOpr.getPlannedCommencementDate());
                saveEntity.setPlannedFinishDate(buOpr.getPlannedFinishDate());
                saveEntity.setBuiltArea(buOpr.getBuiltArea());
                saveEntity.setStructureType(buOpr.getStructureType());
                saveEntity.setProjectOverview(buOpr.getProjectOverview());
                //发包单位
                saveEntity.setPubUnitName(buOpr.getConstructionUnitName());
                saveEntity.setPubUnit(buOpr.getConstructionUnit());
                //工程用途
                saveEntity.setEngineeringPurpose(buOpr.getEngineeringPurpose());
                //工程类型
                saveEntity.setEngineeringType(buOpr.getEngineeringType());
                saveEntity.setEngineeringTypeName(buOpr.getEngineeringTypeName());
            }
            if(StringUtils.isBlank(projectRegisterVO.getCode())) {
                saveEntity.setCode(getAutoCode());
            }
        }

        //保存更新项目部信息
        if(null != projectDepartment) {
            projectDepartment.setSourceId(projectRegisterVO.getSourceId());
            CommonResponse<OrgVO> resp = orgApi.saveOrgInfo(projectDepartment);
            if(!resp.isSuccess()) {
                throw new BusinessException("保存失败，保存项目部信息出错: " + resp.getMsg());
            }
        }

        Map<String, Object> memberMap = getMemberMap(projectRegisterVO);
        if(!memberMap.isEmpty()) {
            //保存新增的成员信息
            CommonResponse<String> resp = employeeApi.manageProjectMembers(memberMap);
            if(!resp.isSuccess()) {
                throw new BusinessException("保存失败，新增成员出错: " + resp.getMsg());
            }
        }

        super.saveOrUpdate(saveEntity, false);

        //更新对应商机
        if(null != buOpr) {
            buOpr.setProjectIsSet(true);
            buOpr.setProjectSetId(saveEntity.getId());
            businessOpportunityService.saveOrUpdate(buOpr, false);
        }

        if(storeFlag){
            //创建仓库
            generateStore(saveEntity);
        }

        return BeanMapper.map(saveEntity, ProjectRegisterVO.class);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public String delProject(Long projectId) {
        ProjectRegisterEntity entity = super.selectById(projectId);

        if("0".equals(entity.getValidStatus())) {
            throw new BusinessException("删除失败，项目：【"+entity.getName()+"】为启用状态不可删除！");
        }

        //判断是否参照商机，若参照商机则恢复商机对应的引用状态
        BusinessOpportunityEntity buOpr = businessOpportunityService.selectByProjectId(projectId);
        if(null != buOpr) {
            logger.info("项目删除，还原对应商机[id-{}]引用状态", buOpr.getId());
            buOpr.setProjectIsSet(false);
            buOpr.setProjectSetId(null);
            businessOpportunityService.saveOrUpdate(buOpr, false);
        }

        //删除项目
        super.removeById(projectId);

        logger.info("执行项目删部除操作，删除项目部[id-{}]", entity.getProjectDepartmentId());
        //删除对应项目部相关信息
        CommonResponse<String> delResp = orgApi.delByOrgId(entity.getProjectDepartmentId());
        if(!delResp.isSuccess()) {
            logger.error("删除项目[id-{}]对应项目部[id-{}]信息失败，原因：{}", projectId, entity.getProjectDepartmentId(), delResp.getMsg());
            throw new BusinessException("项目删除失败，删除对应项目部信息失败。");
        }

        //删除项目下对应的仓库
        CommonResponse<StoreVO> delStoreResp = storeApi.delByProjectId(projectId);
        if(!delStoreResp.isSuccess()) {
            logger.error("删除项目-【id -{}】对应的仓库失败，原因-{}", projectId, delStoreResp.getMsg());
        }
        return null;
    }

}
