/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.market.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.center.api.IWarnCenterApi;
import com.ejianc.business.center.vo.EarlyWarnTransVO;
import com.ejianc.business.market.vo.ProjectUnpaidUncollectWarnVo;
import com.ejianc.business.market.vo.SqlParam;
import com.ejianc.foundation.tenant.api.ITenantApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import java.io.IOException;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/projectPayWarn/"})
public class ProjectWarnController {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String PC_URL_PROJECT = "/ejc-report-frontend/#/proPeportDetail?id=";
    private static final String INDEX_NAME_PROJECT_FINANCE = "project_finance";
    private static final Integer QUERY_TIMEOUT = 60;
    private static final Integer BATCH_SIZE = 1000;
    @Autowired
    private ITenantApi tenantApi;
    @Autowired
    private IWarnCenterApi warnCenterApi;
    @Autowired(required=false)
    private RestHighLevelClient client;

    @PostMapping(value={"projectMnyWarn"})
    public CommonResponse<String> outIncomeMnyWarn(@RequestBody JSONObject jsonParam) {
        this.logger.info("\u63a5\u6536\u5230Task\u53c2\u6570\uff1a{}", (Object)jsonParam);
        ArrayList ignoreTenantIds = new ArrayList();
        if (StringUtils.isNotBlank((CharSequence)jsonParam.getString("ignoreTenantIds"))) {
            ignoreTenantIds.addAll(JSONArray.parseArray((String)jsonParam.getString("ignoreTenantIds"), Long.class));
        }
        List billParams = JSONArray.parseArray((String)jsonParam.getString("billParams"), JSONObject.class);
        JSONObject defaultWarnInfo = JSON.parseObject((String)jsonParam.getString("defaultParam"));
        CommonResponse tenantResp = this.tenantApi.getAllValidTenantId();
        if (!tenantResp.isSuccess()) {
            return CommonResponse.error((String)"\u83b7\u53d6\u6709\u6548\u7684\u79df\u6237Id\u5217\u8868\u5931\u8d25\uff01");
        }
        List tenantIds = (List)tenantResp.getData();
        if (CollectionUtils.isEmpty((Collection)tenantIds)) {
            return this.sendWarnToTask(new ArrayList<EarlyWarnTransVO>(), defaultWarnInfo.getLong("warnSetId"));
        }
        tenantIds.removeAll(ignoreTenantIds);
        if (CollectionUtils.isNotEmpty(ignoreTenantIds) && CollectionUtils.isEmpty((Collection)tenantIds)) {
            this.logger.error("\u6709\u6548\u7684\u79df\u6237Id\u5217\u8868\u4e3a\u7a7a\uff01", (Object)tenantResp.getMsg());
            return this.sendWarnToTask(new ArrayList<EarlyWarnTransVO>(), defaultWarnInfo.getLong("warnSetId"));
        }
        ArrayList<SqlParam> sqlParamList = new ArrayList<SqlParam>();
        List warnParamList = null;
        ArrayList<Long> customTenantIds = new ArrayList<Long>();
        for (JSONObject param : billParams) {
            warnParamList = BeanMapper.mapList((Iterable)param.getJSONArray("parameters"), SqlParam.class);
            for (SqlParam p : warnParamList) {
                p.setWarnLevel(param.getString("warnLevel"));
                p.setTenantId(Long.valueOf(param.getString("tenantId")));
                p.setValue(p.getValue() / 100.0);
                sqlParamList.add(p);
            }
            customTenantIds.add(Long.valueOf(param.getString("tenantId")));
        }
        tenantIds.removeAll(customTenantIds);
        for (Long tenantId : tenantIds) {
            warnParamList = JSONArray.parseArray((String)defaultWarnInfo.getString("parameters"), SqlParam.class);
            for (SqlParam p : warnParamList) {
                p.setWarnLevel(defaultWarnInfo.getString("warnLevel"));
                p.setTenantId(tenantId);
                p.setValue(p.getValue() / 100.0);
                sqlParamList.add(p);
            }
        }
        List<Long> tids = sqlParamList.stream().map(SqlParam::getTenantId).collect(Collectors.toList());
        ArrayList<Object> list = new ArrayList<Object>();
        Long resultSize = this.queryIndexSize(INDEX_NAME_PROJECT_FINANCE, tids);
        SearchRequest searchRequest = new SearchRequest(new String[]{INDEX_NAME_PROJECT_FINANCE});
        SearchSourceBuilder sourceBuilder = new SearchSourceBuilder();
        BoolQueryBuilder boolQuery = QueryBuilders.boolQuery();
        boolQuery.must((QueryBuilder)QueryBuilders.termsQuery((String)"tenantId", tids));
        sourceBuilder.query((QueryBuilder)boolQuery);
        sourceBuilder.size(resultSize.intValue());
        sourceBuilder.timeout(new TimeValue((long)QUERY_TIMEOUT.intValue(), TimeUnit.SECONDS));
        searchRequest.source(sourceBuilder);
        SearchResponse response = null;
        try {
            response = this.client.search(searchRequest, RequestOptions.DEFAULT);
            SearchHits hits = response.getHits();
            for (SearchHit hit : hits) {
                String string = hit.getSourceAsString();
                list.add(JSON.parseObject((String)string, ProjectUnpaidUncollectWarnVo.class));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (CollectionUtils.isEmpty(list)) {
            this.logger.error("\u67e5\u8be2ES\u9879\u76ee\u7684\u4fe1\u606f\u4e3a\u7a7a\uff01");
            return this.sendWarnToTask(new ArrayList<EarlyWarnTransVO>(), defaultWarnInfo.getLong("warnSetId"));
        }
        HashMap<Long, SqlParam> tenantMap = new HashMap<Long, SqlParam>();
        for (SqlParam sqlVo : sqlParamList) {
            tenantMap.put(sqlVo.getTenantId(), sqlVo);
        }
        ArrayList<ProjectUnpaidUncollectWarnVo> resultList = new ArrayList<ProjectUnpaidUncollectWarnVo>();
        for (ProjectUnpaidUncollectWarnVo projectUnpaidUncollectWarnVo : list) {
            BigDecimal xiangmukeyongzijin;
            BigDecimal ratioTaxMny;
            SqlParam sqlParam = (SqlParam)tenantMap.get(projectUnpaidUncollectWarnVo.getTenantId());
            BigDecimal ratio = new BigDecimal(sqlParam.getValue());
            BigDecimal hetongweishoukuanjine = projectUnpaidUncollectWarnVo.getHetongweishoukuanjine();
            BigDecimal hetongweifukuanjine = projectUnpaidUncollectWarnVo.getHetongweifukuanjine();
            boolean greaterOrEqual = ComputeUtil.isGreaterOrEqual((BigDecimal)hetongweifukuanjine, (BigDecimal)(ratioTaxMny = ComputeUtil.safeMultiply((BigDecimal)ComputeUtil.safeAdd((BigDecimal)hetongweishoukuanjine, (BigDecimal)(xiangmukeyongzijin = projectUnpaidUncollectWarnVo.getXiangmukeyongzijin())), (BigDecimal)ratio)));
            if (!greaterOrEqual) continue;
            projectUnpaidUncollectWarnVo.setHetongweifukuanjine(hetongweifukuanjine);
            projectUnpaidUncollectWarnVo.setHetongweishoukuanjine(hetongweishoukuanjine);
            projectUnpaidUncollectWarnVo.setXiangmukeyongzijin(xiangmukeyongzijin);
            projectUnpaidUncollectWarnVo.setPercent(sqlParam.getValue());
            projectUnpaidUncollectWarnVo.setRatioTaxMny(ratioTaxMny);
            projectUnpaidUncollectWarnVo.setOrgName(projectUnpaidUncollectWarnVo.getName());
            projectUnpaidUncollectWarnVo.setWarnLevel(sqlParam.getWarnLevel());
            resultList.add(projectUnpaidUncollectWarnVo);
        }
        this.logger.info("\u63a8\u9001\u6570\u636e\u4e3a" + JSONObject.toJSONString(resultList));
        if (CollectionUtils.isEmpty(resultList)) {
            this.logger.info("\u63a8\u9001\u6570\u636e\u4e3a\u7a7a");
        }
        return this.sendWarnToTask(this.payTransToWarnVO2(resultList, defaultWarnInfo), defaultWarnInfo.getLong("warnSetId"));
    }

    private CommonResponse<String> sendWarnToTask(List<EarlyWarnTransVO> warnList, Long warnId) {
        CommonResponse warnResp = this.warnCenterApi.sendToWarnCenter(warnList, warnId);
        if (!warnResp.isSuccess()) {
            this.logger.error("\u56de\u8c03\u9884\u8b66\u4efb\u52a1\u670d\u52a1\u5931\u8d25\uff0c{}", (Object)warnResp.getMsg());
            return CommonResponse.error((String)("\u56de\u8c03\u9884\u8b66\u4efb\u52a1\u670d\u52a1\u5931\u8d25" + warnResp.getMsg()));
        }
        return CommonResponse.success((String)"\u4efb\u52a1\u63a5\u53d7\u5904\u7406\u6210\u529f\uff01");
    }

    public static void main(String[] args) {
        Long deleteTimes = 2002L;
        int i1 = deleteTimes.intValue();
        Long i = 2002L % (long)BATCH_SIZE.intValue();
        System.out.println(deleteTimes);
        System.out.println(i);
    }

    private BigDecimal getBigDecimal(Object obj) {
        return null == obj ? BigDecimal.ZERO : new BigDecimal(obj.toString());
    }

    private List<EarlyWarnTransVO> payTransToWarnVO2(List<ProjectUnpaidUncollectWarnVo> result, JSONObject defaultWarnInfo) {
        this.logger.debug("\u4ee5\u9879\u76ee\u7ef4\u5ea6\uff0c\u3010\u9879\u76ee\u672a\u4ed8\u91d1\u989d\uff08\u652f\u51fa\u5408\u540c\u603b\u989d-\u5408\u540c\u5df2\u4ed8\u6b3e\uff09\u3011\u5927\u4e8e\u7b49\u4e8e \u3010\u9879\u76ee\u53ef\u7528\u8d44\u91d1\u3011+\u3010\u65bd\u5de5\u5408\u540c\u672a\u6536\u6b3e\uff08\u65bd\u5de5\u5408\u540c\u91d1\u989d-\u6536\u6b3e\u767b\u8bb0\u91d1\u989d\uff09*X%\u9884\u8b66\u5b8c\u6210\uff0c\u53d1\u9001\u9884\u8b66\uff01");
        ArrayList<EarlyWarnTransVO> resp = new ArrayList<EarlyWarnTransVO>();
        String tmpContent = null;
        DecimalFormat df = new DecimalFormat("###,##0.00");
        for (ProjectUnpaidUncollectWarnVo m : result) {
            EarlyWarnTransVO vo = new EarlyWarnTransVO();
            vo.setBillName((null != defaultWarnInfo.get((Object)"categoryName") ? defaultWarnInfo.get((Object)"categoryName").toString() + " - " : "") + m.getProjectCode());
            vo.setPcTitle("\u9879\u76ee\u672a\u4ed8\u6b3e\u91d1\u989d\u5927\u4e8e\u7b49\u4e8e\u9879\u76ee\u53ef\u7528\u8d44\u91d1+\u65bd\u5de5\u5408\u540c\u672a\u6536\u6b3e");
            vo.setPcUrl(PC_URL_PROJECT + m.getProjectId() + "&orgId=" + m.getOrgId());
            vo.setOrgId(Long.valueOf(m.getProjectDepartmentId()));
            vo.setOrgName(m.getName());
            vo.setSourceId(m.getProjectId().toString());
            vo.setTenantId(Long.valueOf(m.getTenantId().toString()));
            vo.setWarnLevel(m.getWarnLevel());
            vo.setWarnSetId(defaultWarnInfo.getLong("warnSetId"));
            vo.setEarlywarnName(defaultWarnInfo.getString("earlywarnName"));
            m.setPercent(m.getPercent() * 100.0);
            tmpContent = defaultWarnInfo.getString("earlywarnContent");
            vo.setEarlywarnContent(tmpContent.replaceAll("#projectName#", m.getName()).replaceAll("#hetongweishoukuanjine#", df.format(this.getBigDecimal(m.getHetongweishoukuanjine()))).replaceAll("#percent#", m.getPercent().toString()).replaceAll("#hetongweifukuanjine#", df.format(this.getBigDecimal(m.getHetongweifukuanjine()))).replaceAll("#xiangmukeyongzijin#", df.format(this.getBigDecimal(m.getXiangmukeyongzijin()))).replaceAll("#ratioTaxMny#", df.format(this.getBigDecimal(m.getRatioTaxMny()))));
            resp.add(vo);
        }
        this.logger.info("\u53d1\u9001\u9884\u8b66\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString(resp));
        return resp;
    }

    private Long queryIndexSize(String indexName, List<Long> tids) {
        Long resultSize = 0L;
        SearchRequest searchRequest = new SearchRequest(new String[]{indexName});
        SearchSourceBuilder sourceBuilder = new SearchSourceBuilder();
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"tenantId", tids));
        sourceBuilder.trackTotalHits(true);
        sourceBuilder.timeout(new TimeValue((long)QUERY_TIMEOUT.intValue(), TimeUnit.SECONDS));
        searchRequest.source(sourceBuilder);
        try {
            SearchResponse response = this.client.search(searchRequest, RequestOptions.DEFAULT);
            SearchHits hits = response.getHits();
            resultSize = hits.getTotalHits().value;
        }
        catch (IOException e) {
            try {
                SearchResponse response = this.client.search(searchRequest, RequestOptions.DEFAULT);
                SearchHits hits = response.getHits();
                resultSize = hits.getTotalHits().value;
            }
            catch (IOException e1) {
                e1.printStackTrace();
                throw new BusinessException("\u6839\u636e parammap \u6761\u4ef6\uff0c\u67e5\u8be2\u5168\u90e8\u8bb0\u5f55\u7d22\u5f15\u5931\u8d25\uff0cMSG\uff1a" + e1.getMessage());
            }
        }
        return resultSize;
    }
}

