package com.ejianc.business.market.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.apache.xpath.operations.Bool;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 项目登记
 */
@TableName("zydx_market_project")
public class ProjectRegisterEntity extends BaseEntity {

    private static final long serialVersionUID = -7103485558232569473L;

    /**
     * 审批状态
     */
    @TableField(value = "bill_state")
    private Integer billState;
    /**
     * 项目编号
     */
    @TableField(value = "code")
    private String code;

    /**
     * 项目名称
     */
    @TableField(value = "name")
    private String name;

    /**
     * 项目简称
     */
    @TableField(value = "short_name")
    private String shortName;//简称项目名称

    /**
     * 所属组织
     */
    @TableField(value = "org_id")
    private Long orgId;

    /**
     * 冗余所属组织名称
     */
    @TableField(value = "org_name")
    private String orgName;

    /**
     * 所属项目部Id
     */
    @TableField(value = "project_department_id")
    private Long projectDepartmentId;

    /**
     * 项目状态：1-未开工, 2-在建，3-完成
     */
    @TableField(value = "status")
    private String status;

    /**
     * 业务板块
     */
    @TableField(value = "business_sector")
    private Long businessSector;

    /**
     * 业务板块名称
     */
    @TableField(value = "business_sector_name")
    private String businessSectorName;

    /**
     * 项目类型：
     */
    @TableField(value = "project_type")
    private Long projectType;
    /**
     * 项目类型：
     */
    @TableField(value = "project_type_name")
    private String projectTypeName;

    /**
     * 签订日期
     */
    @TableField(value = "sign_date")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date signDate;

    /**
     * 类型：1父项目，2执行项目
     */
    @TableField(value = "type")
    private String type;

    /**
     * 父项目id
     */
    @TableField(value = "parent_id")
    private Long parentId;

    /**
     * 是否有子项目
     */
    @TableField(value = "has_child")
    private Boolean hasChild;

    /**
     * 项目经营合同
     */
    @TableField(value = "contract_id")
    private Long contractId;

    /**
     * 发包单位
     */
    @TableField(value = "pub_unit")
    private Long pubUnit;

    /**
     * 冗余发包单位名称
     */
    @TableField(value = "pub_unit_name")
    private String pubUnitName;

    /**
     * 承包单位
     */
    @TableField(value = "contractor_unit")
    private Long contractorUnit;

    /**
     * 冗余承包单位名称
     */
    @TableField(value = "contractor_unit_name")
    private String contractorUnitName;

    /**
     * 项目地区
     */
    @TableField(value = "area")
    private String area;

    /**
     * 详细地址
     */
    @TableField(value = "address")
    private String address;
    /**
     * 纬度
     */
    @TableField(value = "lat")
    private String lat;
    /**
     * 经度
     */
    @TableField(value = "lng")
    private String lng;

    @TableField(value="area_id")
    private Long areaId; // 区域id
    @TableField(value="area_code")
    private String areaCode; // 区域编码
    @TableField(value="area_name")
    private String areaName; // 区域名称

    /**
     * 省份
     */
    @TableField(value = "province")
    private String province;

    /**
     * 市区
     */
    @TableField(value = "city")
    private String city;

    /**
     * 区县
     */
    @TableField(value = "region")
    private String region;

    /**
     * 信息来源
     */
    @TableField(value = "info_source")
    private Long infoSource;

    /**
     * 信息来源名称
     */
    @TableField(value = "info_source_name")
    private String infoSourceName;

    /**
     * 项目经理
     */
    @TableField(value = "project_manager")
    private Long projectManager;

    /**
     * 项目经理名称
     */
    @TableField(value = "project_manager_name")
    private String projectManagerName;

    /**
     * 投资主体
     */
    @TableField(value = "investor")
    private Long investor;

    /**
     * 投资主体
     */
    @TableField(value = "investor_name")
    private String investorName;

    /**
     * 总造价(万元)
     */
    @TableField(value = "cost_total")
    private BigDecimal costTotal;

    /**
     * 合同开工日期
     */
    @TableField(value = "start_date")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date startDate;

    /**
     * 合同完工日期
     */
    @TableField(value = "finish_date")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date finishDate;

    /**
     * 计划工期
     */
    @TableField(value = "plan_duration")
    private String planDuration;

    /**
     * 监理单位人员
     */
    @TableField(value="supervisor")
    private String supervisor;

    /**
     * 设计单位人员
     */
    @TableField(value="designer")
    private String designer;

    /**
     * 技术负责人
     */
    @TableField(value="technology_id")
    private Long technologyId;

    /**
     * 技术负责人
     */
    @TableField(value="technology_name")
    private String technologyName;

    /**
     * 安全员
     */
    @TableField(value="security_id")
    private Long securityId;

    /**
     * 安全员
     */
    @TableField(value="security_name")
    private String securityName;

    /**
     * 工程概况
     */
    @TableField(value = "project_overview")
    private String projectOverview;

    //数据同步字段
    /**
     * 数据在第三方系统中主键值
     */
    @TableField(value = "source_id")
    private String sourceId;
    @TableField(value = "system_code")
    private String sourceCode;
    /**
     * 数据来源系统Id
     */
    @TableField(value = "system_id")
    private String systemId;

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getShortName() {
        return shortName;
    }

    public void setShortName(String shortName) {
        this.shortName = shortName;
    }

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public Long getProjectDepartmentId() {
        return projectDepartmentId;
    }

    public void setProjectDepartmentId(Long projectDepartmentId) {
        this.projectDepartmentId = projectDepartmentId;
    }

    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public Long getBusinessSector() {
        return businessSector;
    }

    public void setBusinessSector(Long businessSector) {
        this.businessSector = businessSector;
    }

    public String getBusinessSectorName() {
        return businessSectorName;
    }

    public void setBusinessSectorName(String businessSectorName) {
        this.businessSectorName = businessSectorName;
    }

    public Long getProjectType() {
        return projectType;
    }

    public void setProjectType(Long projectType) {
        this.projectType = projectType;
    }

    public String getProjectTypeName() {
        return projectTypeName;
    }

    public void setProjectTypeName(String projectTypeName) {
        this.projectTypeName = projectTypeName;
    }

    public Date getSignDate() {
        return signDate;
    }

    public void setSignDate(Date signDate) {
        this.signDate = signDate;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public Long getParentId() {
        return parentId;
    }

    public void setParentId(Long parentId) {
        this.parentId = parentId;
    }

    public Long getContractId() {
        return contractId;
    }

    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }

    public Long getPubUnit() {
        return pubUnit;
    }

    public void setPubUnit(Long pubUnit) {
        this.pubUnit = pubUnit;
    }

    public String getPubUnitName() {
        return pubUnitName;
    }

    public void setPubUnitName(String pubUnitName) {
        this.pubUnitName = pubUnitName;
    }

    public Long getContractorUnit() {
        return contractorUnit;
    }

    public void setContractorUnit(Long contractorUnit) {
        this.contractorUnit = contractorUnit;
    }

    public String getContractorUnitName() {
        return contractorUnitName;
    }

    public void setContractorUnitName(String contractorUnitName) {
        this.contractorUnitName = contractorUnitName;
    }

    public String getArea() {
        return area;
    }

    public void setArea(String area) {
        this.area = area;
    }

    public String getAddress() {
        return address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public String getLat() {
        return lat;
    }

    public void setLat(String lat) {
        this.lat = lat;
    }

    public String getLng() {
        return lng;
    }

    public void setLng(String lng) {
        this.lng = lng;
    }

    public Long getAreaId() {
        return areaId;
    }

    public void setAreaId(Long areaId) {
        this.areaId = areaId;
    }

    public String getAreaCode() {
        return areaCode;
    }

    public void setAreaCode(String areaCode) {
        this.areaCode = areaCode;
    }

    public String getAreaName() {
        return areaName;
    }

    public void setAreaName(String areaName) {
        this.areaName = areaName;
    }

    public String getProvince() {
        return province;
    }

    public void setProvince(String province) {
        this.province = province;
    }

    public String getCity() {
        return city;
    }

    public void setCity(String city) {
        this.city = city;
    }

    public String getRegion() {
        return region;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public Long getInfoSource() {
        return infoSource;
    }

    public void setInfoSource(Long infoSource) {
        this.infoSource = infoSource;
    }

    public String getInfoSourceName() {
        return infoSourceName;
    }

    public void setInfoSourceName(String infoSourceName) {
        this.infoSourceName = infoSourceName;
    }

    public Long getProjectManager() {
        return projectManager;
    }

    public void setProjectManager(Long projectManager) {
        this.projectManager = projectManager;
    }

    public String getProjectManagerName() {
        return projectManagerName;
    }

    public void setProjectManagerName(String projectManagerName) {
        this.projectManagerName = projectManagerName;
    }

    public Long getInvestor() {
        return investor;
    }

    public void setInvestor(Long investor) {
        this.investor = investor;
    }

    public String getInvestorName() {
        return investorName;
    }

    public void setInvestorName(String investorName) {
        this.investorName = investorName;
    }

    public BigDecimal getCostTotal() {
        return costTotal;
    }

    public void setCostTotal(BigDecimal costTotal) {
        this.costTotal = costTotal;
    }

    public Date getStartDate() {
        return startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public Date getFinishDate() {
        return finishDate;
    }

    public void setFinishDate(Date finishDate) {
        this.finishDate = finishDate;
    }

    public String getPlanDuration() {
        return planDuration;
    }

    public void setPlanDuration(String planDuration) {
        this.planDuration = planDuration;
    }

    public String getSupervisor() {
        return supervisor;
    }

    public void setSupervisor(String supervisor) {
        this.supervisor = supervisor;
    }

    public String getDesigner() {
        return designer;
    }

    public void setDesigner(String designer) {
        this.designer = designer;
    }

    public Long getTechnologyId() {
        return technologyId;
    }

    public void setTechnologyId(Long technologyId) {
        this.technologyId = technologyId;
    }

    public String getTechnologyName() {
        return technologyName;
    }

    public void setTechnologyName(String technologyName) {
        this.technologyName = technologyName;
    }

    public Long getSecurityId() {
        return securityId;
    }

    public void setSecurityId(Long securityId) {
        this.securityId = securityId;
    }

    public String getSecurityName() {
        return securityName;
    }

    public void setSecurityName(String securityName) {
        this.securityName = securityName;
    }

    public String getProjectOverview() {
        return projectOverview;
    }

    public void setProjectOverview(String projectOverview) {
        this.projectOverview = projectOverview;
    }

    public String getSourceId() {
        return sourceId;
    }

    public void setSourceId(String sourceId) {
        this.sourceId = sourceId;
    }

    public String getSourceCode() {
        return sourceCode;
    }

    public void setSourceCode(String sourceCode) {
        this.sourceCode = sourceCode;
    }

    public String getSystemId() {
        return systemId;
    }

    public void setSystemId(String systemId) {
        this.systemId = systemId;
    }

    public Boolean getHasChild() {
        return hasChild;
    }

    public void setHasChild(Boolean hasChild) {
        this.hasChild = hasChild;
    }
}
