package com.ejianc.business.market.controller.api;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.market.bean.ProjectRegisterEntity;
import com.ejianc.business.market.service.IProjectRegisterService;
import com.ejianc.business.market.vo.ProjectRegisterVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

@RestController
@RequestMapping("/api/project/")
public class ProjectApi {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IProjectRegisterService projectRegisterService;

    @GetMapping("queryProjectBySourceId")
    public CommonResponse<ProjectRegisterVO> queryProjectBySourceId(@RequestParam(value = "sourceId") String sourceId) {
        ProjectRegisterVO vo = new ProjectRegisterVO();
        QueryWrapper<ProjectRegisterEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("dr", 0);
        queryWrapper.eq("source_id", sourceId);
        ProjectRegisterEntity entity = projectRegisterService.getOne(queryWrapper);
        if (entity != null) {
            vo = BeanMapper.map(entity, ProjectRegisterVO.class);
        }
        return CommonResponse.success("查询成功！", vo);
    }

    @GetMapping("queryProjectDetail")
    public CommonResponse<ProjectRegisterVO> queryProjectDetail(@RequestParam(value = "projectId") Long projectId) {
        ProjectRegisterVO vo = new ProjectRegisterVO();
        ProjectRegisterEntity entity = projectRegisterService.selectById(projectId);
        if (entity != null) {
            vo = BeanMapper.map(entity, ProjectRegisterVO.class);
        }
        return CommonResponse.success("查询成功！", vo);
    }


    /**
     * @Author mrsir_wxp
     * @Date 2020/8/21 根据项目部id查询项目信息
     * @Description queryProjectByProjectDepartmentId
     * @Param [sourceId]
     * @Return com.ejianc.framework.core.response.CommonResponse<com.ejianc.business.market.vo.ProjectRegisterVO>
     */
    @GetMapping("queryProjectByProjectDepartmentId")
    public CommonResponse<ProjectRegisterVO> queryProjectByProjectDepartmentId(@RequestParam(value = "projectDepartmentId") Long projectDepartmentId) {
        ProjectRegisterVO vo = new ProjectRegisterVO();
        QueryWrapper<ProjectRegisterEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("project_department_id", projectDepartmentId);
        ProjectRegisterEntity entity = projectRegisterService.getOne(queryWrapper);
        if (entity != null) {
            vo = BeanMapper.map(entity, ProjectRegisterVO.class);
        }
        return CommonResponse.success("查询成功！", vo);
    }

    /**
     * 根据项目ID查询项目列表
     *
     * @param
     * @return
     */
    @GetMapping("queryProjectByIds")
    public CommonResponse<List<ProjectRegisterVO>> queryProjectByIds(@RequestParam(value = "ids") List<Long> ids) {
        List<ProjectRegisterVO> vos = new ArrayList<>();
        QueryWrapper<ProjectRegisterEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("dr", 0);
        queryWrapper.in("id", ids);
        List<ProjectRegisterEntity> entitys = projectRegisterService.list(queryWrapper);
        if (entitys != null) {
            vos = BeanMapper.mapList(entitys, ProjectRegisterVO.class);
        }
        return CommonResponse.success("查询成功！", vos);
    }

    /**
     * 根据条件查询对应项目ID列表
     *
     * @param projectRange 1-全部项目，2-在建项目，3-完工项目，4-本年新签项目
     * @return
     */
    @GetMapping(value = "getProjectIdsByProperties")
    CommonResponse<List<Long>> getProjectIdsByProperties(@RequestParam(value = "projectRange") int projectRange) {
        QueryParam queryParam = new QueryParam();
        //查询本租户的项目
        queryParam.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        boolean queryNewSigned = false;
        if (projectRange == 2 || projectRange == 3) {
            queryParam.getParams().put("status", new Parameter(QueryParam.EQ, projectRange));
        } else if (projectRange == 4) {
            queryNewSigned = true;
        }
        return CommonResponse.success(projectRegisterService.queryProIdsByProperties(queryParam, queryNewSigned));
    }

    /**
     * 根据条件查询对应项目ID列表
     *
     * @param projectRange 1-全部项目，2-在建项目，3-完工项目，4-本年新签项目
     * @return
     */
    @GetMapping(value = "getProjectIdsByEngineeringType")
    CommonResponse<List<Long>> getProjectIdsByEngineeringType(@RequestParam(value = "projectRange") int projectRange, @RequestParam(value = "engineeringType", required = false) Long engineeringType) {
        QueryParam queryParam = new QueryParam();
        //查询本租户的项目
        queryParam.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        boolean queryNewSigned = false;
        if (projectRange == 2 || projectRange == 3) {
            queryParam.getParams().put("status", new Parameter(QueryParam.EQ, projectRange));
        } else if (projectRange == 4) {
            queryNewSigned = true;
        }
        if (null != engineeringType) {
            queryParam.getParams().put("engineeringType", new Parameter(QueryParam.EQ, engineeringType));
        }
        return CommonResponse.success(projectRegisterService.queryProIdsByProperties(queryParam, queryNewSigned));
    }
    @GetMapping(value = "getDataByName")
    public CommonResponse<ProjectRegisterVO> getDataByName(@RequestParam("projectName") String projectName){
        ProjectRegisterVO vo = projectRegisterService.getDataByName(projectName);
        return CommonResponse.success(vo);
    }

    @GetMapping(value = "saveContractMny")
    public CommonResponse<ProjectRegisterVO> saveContractMny(@RequestParam("id") Long id,
        @RequestParam("contractTaxMny") BigDecimal contractTaxMny,@RequestParam("contractMny") BigDecimal contractMny){
        return projectRegisterService.saveContractMny(id,contractTaxMny,contractMny);
    }
}
