/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.market.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.market.bean.ProjectRegisterEntity;
import com.ejianc.business.market.service.IProjectRegisterService;
import com.ejianc.business.market.vo.ProjectRegisterVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.api.IUserApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.ComplexParam;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"projectRegister"})
public class ProjectResigerController {
    private final String PROJECT_BILL_TYPE_CODE = "BT200519000000002";
    private static final Random random = new Random();
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IProjectRegisterService projectRegisterService;
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private IUserApi userApi;
    @Autowired
    private IBillTypeApi billTypeApi;

    @PostMapping(value={"saveProject"})
    public CommonResponse<ProjectRegisterVO> saveProject(@RequestBody ProjectRegisterVO projectRegisterVO) {
        return this.projectRegisterService.saveProject(projectRegisterVO);
    }

    private Object getRespData(CommonResponse resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @PostMapping(value={"page"})
    public CommonResponse<IPage<ProjectRegisterVO>> queryPageList(@RequestBody QueryParam queryParam) {
        queryParam.getFuzzyFields().add("name");
        queryParam.getFuzzyFields().add("code");
        queryParam.getFuzzyFields().add("orgName");
        queryParam.getFuzzyFields().add("shortName");
        queryParam.getFuzzyFields().add("contractorUnitName");
        queryParam.getFuzzyFields().add("projectManagerName");
        queryParam.getFuzzyFields().add("pubUnitName");
        Page pageData = null;
        List orgVOList = (List)this.getRespData(this.orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        if (CollectionUtils.isEmpty((Collection)orgVOList)) {
            pageData = new Page();
            pageData.setRecords(new ArrayList());
            pageData.setTotal(0L);
            pageData.setSize((long)queryParam.getPageSize());
            pageData.setCurrent((long)queryParam.getPageIndex());
            pageData.setPages(0L);
        } else {
            ArrayList commonOrgIds = new ArrayList();
            orgVOList.stream().forEach(org -> commonOrgIds.add(org.getId()));
            queryParam.getParams().put("projectDepartmentId", new Parameter("in", commonOrgIds));
            queryParam.getParams().put("parentId", new Parameter("eq", null));
            pageData = this.projectRegisterService.queryPage(queryParam, false);
        }
        Page result = new Page(pageData.getCurrent(), pageData.getSize(), pageData.getTotal());
        result.setRecords(BeanMapper.mapList((Iterable)pageData.getRecords(), ProjectRegisterVO.class));
        for (ProjectRegisterVO vo : result.getRecords()) {
            if (vo.getHasChild() == null || !vo.getHasChild().booleanValue()) continue;
            QueryWrapper wrapper = new QueryWrapper();
            wrapper.eq((Object)"parent_id", (Object)vo.getId());
            List plist = this.projectRegisterService.list((Wrapper)wrapper);
            if (plist == null || plist.size() <= 0) continue;
            vo.setChildren(BeanMapper.mapList((Iterable)plist, ProjectRegisterVO.class));
        }
        return CommonResponse.success((String)"\u5206\u9875\u67e5\u8be2\u767b\u8bb0\u9879\u76ee\u5217\u8868\u6210\u529f\uff01", (Object)result);
    }

    @GetMapping(value={"detail"})
    public CommonResponse<ProjectRegisterVO> detail(@RequestParam Long id) {
        ProjectRegisterVO resp = (ProjectRegisterVO)BeanMapper.map((Object)((Object)this.projectRegisterService.queryById(id)), ProjectRegisterVO.class);
        CommonResponse membersResp = this.userApi.getEmployeeList(resp.getProjectDepartmentId());
        if (!membersResp.isSuccess()) {
            return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u9879\u76ee\u6210\u5458\u5931\u8d25\u3002");
        }
        QueryParam queryParam = new QueryParam();
        resp.setMembersList((List)membersResp.getData());
        for (Map map : resp.getMembersList()) {
            JSONObject jsonObj = new JSONObject();
            jsonObj.put("id", map.get("postId"));
            jsonObj.put("name", map.get("postName"));
            map.put("postId", jsonObj);
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u9879\u76ee\u767b\u8bb0\u8be6\u60c5\u6210\u529f\uff01", (Object)resp);
    }

    @PostMapping(value={"delProjectList"})
    public CommonResponse<JSONObject> delProjectList(@RequestBody List<ProjectRegisterVO> vos) {
        JSONObject json = new JSONObject();
        String userType = InvocationInfoProxy.getUserType();
        if (!"1".equals(userType) && !"3".equals(userType)) {
            return CommonResponse.error((String)"\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u6267\u884c\u9879\u76ee\u5220\u9664\u64cd\u4f5c\u3002");
        }
        for (ProjectRegisterVO vo : vos) {
            CommonResponse resp = this.billTypeApi.checkQuote("BT200519000000002", vo.getId());
            if (resp.isSuccess()) continue;
            this.logger.info("\u9879\u76ee\u7acb\u9879\u3010Id-{}\u3011\u65e0\u6cd5\u8fdb\u884c\u5220\u9664\u64cd\u4f5c\uff0c\u539f\u56e0\uff1a{}", (Object)vo.getId(), (Object)resp.getMsg());
            return CommonResponse.error((String)("\u9879\u76ee\uff1a\u3010" + vo.getName() + "\u3011\u5b58\u5728\u5f15\u7528\u6570\u636e" + resp.getMsg()));
        }
        ArrayList<String> errorMag = new ArrayList<String>();
        String successName = "";
        for (ProjectRegisterVO vo : vos) {
            try {
                ProjectRegisterEntity entity = (ProjectRegisterEntity)((Object)this.projectRegisterService.selectById(vo.getId()));
                String result = this.projectRegisterService.delProject(entity);
                if (StringUtils.isNotBlank((CharSequence)result)) {
                    errorMag.add(result);
                    continue;
                }
                successName = successName + vo.getName() + ",";
            }
            catch (Exception e) {
                errorMag.add("\u9879\u76ee\uff1a\u3010" + vo.getName() + "\u3011\u5220\u9664\u5931\u8d25");
            }
        }
        json.put("successName", (Object)successName);
        if (errorMag != null && errorMag.size() > 0) {
            json.put("errorMag", errorMag);
        }
        return CommonResponse.success((Object)json);
    }

    /*
     * Enabled aggressive block sorting
     */
    @GetMapping(value={"/projectListRefer"})
    public CommonResponse<IPage<ProjectRegisterVO>> projectListRefe(@RequestParam(defaultValue="1") Integer pageNumber, @RequestParam(defaultValue="10") Integer pageSize, @RequestParam(value="condition", required=false) String condition, @RequestParam(value="searchText", required=false) String searchText) {
        QueryParam queryParam;
        block21: {
            Page pageData;
            queryParam = new QueryParam();
            queryParam.setPageIndex(pageNumber.intValue());
            queryParam.setPageSize(pageSize.intValue());
            queryParam.setSearchText(searchText);
            queryParam.getFuzzyFields().add("code");
            queryParam.getFuzzyFields().add("name");
            queryParam.getFuzzyFields().add("orgName");
            queryParam.getFuzzyFields().add("shortName");
            queryParam.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
            queryParam.getParams().put("billState", new Parameter("in", (Object)"1,3"));
            queryParam.getOrderMap().put("createTime", "desc");
            ArrayList commonOrgIds = new ArrayList();
            ArrayList departmentIds = new ArrayList();
            Long orgId = InvocationInfoProxy.getOrgId();
            Boolean tenantLeave = false;
            Boolean mobileLeave = false;
            if (StringUtils.isNotBlank((CharSequence)condition)) {
                Map conditionMap = (Map)JSONObject.parseObject((String)condition, Map.class);
                if (null != conditionMap.get("orgId")) {
                    orgId = Long.valueOf(conditionMap.get("orgId").toString());
                }
                if (null != conditionMap.get("tenantLeave")) {
                    tenantLeave = true;
                }
                if (null != conditionMap.get("mobileLeave")) {
                    mobileLeave = true;
                }
                if (null != conditionMap.get("province")) {
                    queryParam.getParams().put("province", new Parameter("eq", conditionMap.get("province")));
                }
                if (null != conditionMap.get("city")) {
                    queryParam.getParams().put("city", new Parameter("eq", conditionMap.get("city")));
                }
                if (null != conditionMap.get("region")) {
                    queryParam.getParams().put("region", new Parameter("eq", conditionMap.get("region")));
                }
                if (null != conditionMap.get("parentId")) {
                    queryParam.getParams().put("parentId", new Parameter("eq", conditionMap.get("parentId")));
                }
                if (null != conditionMap.get("projectId")) {
                    queryParam.getParams().put("id", new Parameter("ne", conditionMap.get("projectId")));
                }
                if (null != conditionMap.get("type")) {
                    if ("1".equals(conditionMap.get("type").toString())) {
                        queryParam.getParams().put("type", new Parameter("eq", (Object)"1"));
                    } else if ("2".equals(conditionMap.get("type").toString())) {
                        queryParam.getParams().put("type", new Parameter("eq", (Object)"2"));
                    } else if ("3".equals(conditionMap.get("type").toString())) {
                        ComplexParam c1 = new ComplexParam();
                        c1.setLogic("and");
                        ComplexParam c2 = new ComplexParam();
                        c2.setLogic("or");
                        c2.getParams().put("type", new Parameter("eq", (Object)"1"));
                        c1.getComplexParams().add(c2);
                        ComplexParam c3 = new ComplexParam();
                        c3.setLogic("or");
                        c3.getParams().put("type", new Parameter("eq", (Object)"2"));
                        c3.getParams().put("parentId", new Parameter("eq", null));
                        c1.getComplexParams().add(c3);
                        queryParam.getComplexParams().add(c1);
                    }
                }
            }
            if (mobileLeave.booleanValue()) {
                CommonResponse response = this.orgApi.findProjectOrgsByUserId(InvocationInfoProxy.getUserid());
                if (response.isSuccess() && ListUtil.isNotEmpty((List)((List)response.getData()))) {
                    queryParam.getParams().put("projectDepartmentId", new Parameter("in", ((List)response.getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
                    break block21;
                } else {
                    pageData = new Page((long)pageNumber.intValue(), (long)pageSize.intValue(), 0L);
                    return CommonResponse.success((String)"\u8be5\u7528\u6237\u6ca1\u6709\u4efb\u4f55\u9879\u76ee\u6743\u9650\uff01", (Object)pageData);
                }
            }
            if (!tenantLeave.booleanValue()) {
                CommonResponse orgListResp = this.orgApi.findChildrenByParentId(orgId);
                if (!orgListResp.isSuccess()) {
                    pageData = new Page((long)pageNumber.intValue(), (long)pageSize.intValue(), 0L);
                    return CommonResponse.success((String)"\u67e5\u8be2\u6570\u8868\u53c2\u7167\u5931\u8d25\uff0c\u9879\u76ee\u7ec4\u7ec7\u4fe1\u606f\u67e5\u8be2\u5931\u8d25\uff01", (Object)pageData);
                }
                List orgList = (List)orgListResp.getData();
                if (CollectionUtils.isNotEmpty((Collection)orgList)) {
                    orgList.forEach(orgVO -> commonOrgIds.add(orgVO.getId()));
                    queryParam.getParams().put("projectDepartmentId", new Parameter("in", commonOrgIds));
                }
            }
        }
        IPage pageData = this.projectRegisterService.queryPage(queryParam, false);
        Page result = new Page(pageData.getCurrent(), pageData.getSize(), pageData.getTotal());
        result.setRecords(BeanMapper.mapList((Iterable)pageData.getRecords(), ProjectRegisterVO.class));
        return CommonResponse.success((String)"\u9879\u76ee\u53c2\u7167\u67e5\u8be2\u6210\u529f\uff01", (Object)result);
    }

    @GetMapping(value={"getProjectByCurrentOrg"})
    public CommonResponse<ProjectRegisterVO> getProjectByCurrentOrg() {
        QueryParam param = new QueryParam();
        param.getParams().put("projectDepartmentId", new Parameter("eq", (Object)InvocationInfoProxy.getOrgId()));
        List entities = this.projectRegisterService.queryList(param, false);
        if (ListUtil.isNotEmpty((List)entities)) {
            // empty if block
        }
        return CommonResponse.error((String)"\u6ca1\u6709\u67e5\u5230\u9879\u76ee");
    }

    @PostMapping(value={"changeStatus"})
    public CommonResponse<ProjectRegisterVO> changeStatus(@RequestBody ProjectRegisterVO projectRegisterVO) {
        ProjectRegisterVO resp = this.projectRegisterService.changeStatus(projectRegisterVO);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6210\u529f\uff01", (Object)resp);
    }

    public static void main(String[] args) {
        System.out.println("INIT-PRO-" + DateFormatUtil.formatDate((String)"yyyyMMddHHmmsss", (long)(System.currentTimeMillis() + (long)random.nextInt(3000000))));
        System.out.println("INIT-PRO-" + DateFormatUtil.formatDate((String)"yyyyMMddHHmmsss", (long)(System.currentTimeMillis() + (long)random.nextInt(300000))));
        System.out.println("INIT-PRO-" + DateFormatUtil.formatDate((String)"yyyyMMddHHmmsss", (long)(System.currentTimeMillis() + (long)random.nextInt(300000))));
        System.out.println("INIT-PRO-" + DateFormatUtil.formatDate((String)"yyyyMMddHHmmsss", (long)(System.currentTimeMillis() + (long)random.nextInt(300000))));
    }
}

