package com.ejianc.business.market.service;

import com.ejianc.business.market.bean.ProjectRegisterEntity;
import com.ejianc.business.market.vo.ProjectRegisterVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.IBaseService;

import java.util.List;
import java.util.Map;

public interface IProjectRegisterService extends IBaseService<ProjectRegisterEntity> {

    /**
     * 根据主键Id查询项目详情
     *
     * @param id
     * @return
     */
    ProjectRegisterEntity queryById(Long id);

    /**
     * 保存项目信息
     *
     * @param projectRegisterVO
     * @return
     */
    ProjectRegisterVO saveProject(ProjectRegisterVO projectRegisterVO);

    /**
     * 保存导入数据
     *
     * @param proList
     */
    void saveImportProject(List<ProjectRegisterVO> proList);

    /**
     * 统计项目总数、在建项目数和已完工项目数量
     *
     * @param queryParam
     * @return
     */
    Map<String, Integer> countProjectNum(QueryParam queryParam);

    /**
     * 编码重复校验
     *
     * @param project
     * @return
     */
    boolean codeUsedCheck(ProjectRegisterVO project);

    /**
     * 项目停启用状态修改
     *
     * @param projectRegisterVO
     */
    void changeValidStatus(ProjectRegisterVO projectRegisterVO);

    /**
     * 根据条件查询对应的项目Id列表
     *
     * @param queryParam
     * @param queryNewSignedCurYear
     * @return
     */
    List<Long> queryProIdsByProperties(QueryParam queryParam, boolean queryNewSignedCurYear);

	/**
	 * 供方协同---用户获取有权限的项目，为空代表全部项目的权限
	 * 
	 * @return
	 */
	CommonResponse<List<ProjectRegisterVO>> queryProjectByUserId(Long userId);

    /**
     * 项目同步信息保存方法
     *
     * @param project
     * @return
     */
    ProjectRegisterVO saveSyncProject(ProjectRegisterVO project);

    /**
     * 根据项目Id删除对应项目
     *
     * @param projectId
     */
    String delProject(Long projectId);
}
