package com.ejianc.business.material.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.Date;


/**
 * 采购订单子表
 *
 * @author generator
 *
 */
public class PurchaseOrderDetailVO extends BaseVO {
    private static final long serialVersionUID = 1L;

    private Long pid; // 主表id
    private Long materialTypeId; // 物资分类id
    private String materialTypeName; // 物资分类名称
    private Long materialId; // 物资id
    private String materialName; // 物资名称
    private String model; // 规格型号
    private String unit; // 计量单位
    private Long supplierId; // 供应商品牌id
    private String supplierName; // 品牌
    private BigDecimal orderNum; // 订货量
    private BigDecimal price; // 单价
    private String memo; // 备注
    private Integer sourceType; // 物资来源类型：1-物资档案，2-用料申请，3-合同清单，4-导入
    private Long sourceId; // 物资来源单据Id
    private BigDecimal taxMny; // 金额


    //唯一的key需要使用方自己构建
    public String onlyKey;
    //匹配状态
    public String matchStatus;
    //匹配数量
    public String matchNumber;
    //描述
    public String matchStatusDescription;

    /**
     * 导入失败原因
     */
    private String errorMessage;

    private BigDecimal surplusNum; // 剩余数量\参照用


    /**
     * 物资编码
     */
    private String materialCode;

    private Long sourceDetailId; // 来源单据明细Id
    private BigDecimal receiveNum; // 接收数量
    private BigDecimal sumSendNum; // 供应商累计发货量
    private Long purchaseContractId; // 采购合同
    private String purchaseContractName; // 采购合同
    private BigDecimal purchaseContractPrice; // 合同单价
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date expectArriveDate; // 预计到货日期

    public Date getExpectArriveDate() {
        return expectArriveDate;
    }

    public void setExpectArriveDate(Date expectArriveDate) {
        this.expectArriveDate = expectArriveDate;
    }

    public BigDecimal getReceiveNum() {
        return receiveNum;
    }

    public void setReceiveNum(BigDecimal receiveNum) {
        this.receiveNum = receiveNum;
    }

    public Long getSourceDetailId() {
        return sourceDetailId;
    }

    public void setSourceDetailId(Long sourceDetailId) {
        this.sourceDetailId = sourceDetailId;
    }

    public BigDecimal getSumSendNum() {
        return sumSendNum;
    }

    public void setSumSendNum(BigDecimal sumSendNum) {
        this.sumSendNum = sumSendNum;
    }

    @ReferSerialTransfer(referCode="materialContract")
    public Long getPurchaseContractId() {
        return purchaseContractId;
    }

    @ReferDeserialTransfer
    public void setPurchaseContractId(Long purchaseContractId) {
        this.purchaseContractId = purchaseContractId;
    }

    public String getPurchaseContractName() {
        return purchaseContractName;
    }

    public void setPurchaseContractName(String purchaseContractName) {
        this.purchaseContractName = purchaseContractName;
    }

    public BigDecimal getPurchaseContractPrice() {
        return purchaseContractPrice;
    }

    public void setPurchaseContractPrice(BigDecimal purchaseContractPrice) {
        this.purchaseContractPrice = purchaseContractPrice;
    }

    public BigDecimal getTaxMny() {
        return taxMny;
    }

    public void setTaxMny(BigDecimal taxMny) {
        this.taxMny = taxMny;
    }

    public String getMaterialCode() {
        return materialCode;
    }

    public void setMaterialCode(String materialCode) {
        this.materialCode = materialCode;
    }

    public BigDecimal getSurplusNum() {
        return surplusNum;
    }

    public void setSurplusNum(BigDecimal surplusNum) {
        this.surplusNum = surplusNum;
    }

    public String getOnlyKey() {
        return onlyKey;
    }

    public void setOnlyKey(String onlyKey) {
        this.onlyKey = onlyKey;
    }

    public String getMatchStatus() {
        return matchStatus;
    }

    public void setMatchStatus(String matchStatus) {
        this.matchStatus = matchStatus;
    }

    public String getMatchNumber() {
        return matchNumber;
    }

    public void setMatchNumber(String matchNumber) {
        this.matchNumber = matchNumber;
    }

    public String getMatchStatusDescription() {
        return matchStatusDescription;
    }

    public void setMatchStatusDescription(String matchStatusDescription) {
        this.matchStatusDescription = matchStatusDescription;
    }

    public String getErrorMessage() {
        return errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public Long getPid() {
        return pid;
    }

    public void setPid(Long pid) {
        this.pid = pid;
    }

    public Long getMaterialTypeId() {
        return materialTypeId;
    }

    public void setMaterialTypeId(Long materialTypeId) {
        this.materialTypeId = materialTypeId;
    }

    public String getMaterialTypeName() {
        return materialTypeName;
    }

    public void setMaterialTypeName(String materialTypeName) {
        this.materialTypeName = materialTypeName;
    }

    public Long getMaterialId() {
        return materialId;
    }

    public void setMaterialId(Long materialId) {
        this.materialId = materialId;
    }

    public String getMaterialName() {
        return materialName;
    }

    public void setMaterialName(String materialName) {
        this.materialName = materialName;
    }

    public String getModel() {
        return model;
    }

    public void setModel(String model) {
        this.model = model;
    }

    public String getUnit() {
        return unit;
    }

    public void setUnit(String unit) {
        this.unit = unit;
    }

    @ReferSerialTransfer(referCode = "support-brand")
    public Long getSupplierId() {
        return supplierId;
    }

    @ReferDeserialTransfer
    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }

    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }

    public BigDecimal getOrderNum() {
        return orderNum;
    }

    public void setOrderNum(BigDecimal orderNum) {
        this.orderNum = orderNum;
    }

    public BigDecimal getPrice() {
        return price;
    }

    public void setPrice(BigDecimal price) {
        this.price = price;
    }

    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public Integer getSourceType() {
        return sourceType;
    }

    public void setSourceType(Integer sourceType) {
        this.sourceType = sourceType;
    }

    public Long getSourceId() {
        return sourceId;
    }

    public void setSourceId(Long sourceId) {
        this.sourceId = sourceId;
    }

}
