package com.ejianc.business.plan.vo;

import com.baomidou.mybatisplus.annotation.TableField;
import com.ejianc.framework.skeleton.template.BaseVO;

import java.math.BigDecimal;

/**
 * 物资材料VO
 *
 * @author CJ
 * @Description: 物资材料VO
 * @date 2021/3/2 17:15
 */
public class MaterialMasterPlanSubVO extends BaseVO {

    private static final long serialVersionUID = 8353772883057677653L;

    /**
     * 所属总计划Id
     */
    private Long materialMasterPlanId;
    /**
     * 编码
     */
    private String billCode;

    /**
     * 物资分类Id
     */
    private Long materialCategoryId;
    /**
     * 物资分类名称
     */
    private String materialCategoryName;
    /**
     * 物资Id
     */
    private Long materialId;
    /**
     * 物资名称
     */
    private String materialName;
    /**
     * 规格型号
     */
    private String spec;
    /**
     * 计量单位
     */
    private String unit;

    private java.lang.Long supplierId; // 供应商品牌id

    /**
     * 品牌
     */
    private java.lang.String supplierName;

    /**
     * 数量
     */
    private Double num;
    /**
     *
     */
    private BigDecimal price;
    /**
     * 金额
     */
    private BigDecimal amount;

    /**
     * 物资来源：1-物料档案，2-导入，3-预算引入，4-项目预算
     */
    private String sourceType;

    /**
     * 物资来源出业务Id
     */
    private String sourceId;

    /**
     * 备注
     */
    private String remark;
    //唯一的key需要使用方自己构建
    public String onlyKey;
    private Integer matchStatus; // 匹配状态：0-未匹配，1-已匹配，2-模糊匹配，
    private String matchStatusDescription;
    /**
     * 物资编码
     */
    private String materialCode;

    public Long getSupplierId() {
        return supplierId;
    }

    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    public String getMaterialCode() {
        return materialCode;
    }

    public void setMaterialCode(String materialCode) {
        this.materialCode = materialCode;
    }
    public String getSourceType() {
        return sourceType;
    }

    public void setSourceType(String sourceType) {
        this.sourceType = sourceType;
    }

    public String getSourceId() {
        return sourceId;
    }

    public void setSourceId(String sourceId) {
        this.sourceId = sourceId;
    }

    public Long getMaterialMasterPlanId() {
        return materialMasterPlanId;
    }

    public void setMaterialMasterPlanId(Long materialMasterPlanId) {
        this.materialMasterPlanId = materialMasterPlanId;
    }

    public Long getMaterialCategoryId() {
        return materialCategoryId;
    }

    public void setMaterialCategoryId(Long materialCategoryId) {
        this.materialCategoryId = materialCategoryId;
    }

    public String getMaterialCategoryName() {
        return materialCategoryName;
    }

    public void setMaterialCategoryName(String materialCategoryName) {
        this.materialCategoryName = materialCategoryName;
    }

    public Long getMaterialId() {
        return materialId;
    }

    public void setMaterialId(Long materialId) {
        this.materialId = materialId;
    }

    public String getMaterialName() {
        return materialName;
    }

    public void setMaterialName(String materialName) {
        this.materialName = materialName;
    }

    public String getSpec() {
        return spec;
    }

    public void setSpec(String spec) {
        this.spec = spec;
    }

    public String getUnit() {
        return unit;
    }

    public void setUnit(String unit) {
        this.unit = unit;
    }

    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }

    public Double getNum() {
        return num;
    }

    public void setNum(Double num) {
        this.num = num;
    }

    public BigDecimal getPrice() {
        return price;
    }

    public void setPrice(BigDecimal price) {
        this.price = price;
    }

    public BigDecimal getAmount() {
        return amount;
    }

    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public String getOnlyKey() {
        return onlyKey;
    }

    public void setOnlyKey(String onlyKey) {
        this.onlyKey = onlyKey;
    }

    public Integer getMatchStatus() {
        return matchStatus;
    }

    public void setMatchStatus(Integer matchStatus) {
        this.matchStatus = matchStatus;
    }

    public String getMatchStatusDescription() {
        return matchStatusDescription;
    }

    public void setMatchStatusDescription(String matchStatusDescription) {
        this.matchStatusDescription = matchStatusDescription;
    }
}
