package com.ejianc.business.material.pub;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;

/**
 * @description: 合同状态
 * @author songlx
 * @date 2024/6/12
 * @version 1.0
 */
public enum ContractStateEnum {

    未签订("1", "未签订"),
    履约中("2", "履约中"),
    已封账("3", "已封账"),
    已作废("4", "已作废");


    private static Map<String, String> enumMap;

    static {
        enumMap = new HashMap<>();
        for (ContractStateEnum enumVal : ContractStateEnum.values()) {
            enumMap.put(enumVal.getCode(), enumVal.getName());
        }
    }

    public static String getNameByCode(String code) {
        return enumMap.get(code);
    }


    public static String getCodeByName(String name) {
        Set<String> keySet = enumMap.keySet();
        for (String key : keySet) {
            String val = enumMap.get(key);
            if (val.equals(name)) {
                return key;
            }
        }
        return null;
    }


    private String code;

    private String name;


    ContractStateEnum(String code, String name) {
        this.code = code;
        this.name = name;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }
}
