package com.ejianc.business.plan.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;

import com.ejianc.business.plan.vo.BatchPlanSubVO;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 批次计划主实体
 * 
 * @author generator
 * 
 */
public class BatchPlanVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private Long projectId; // 所属项目Id
    private String projectName; // 所属项目名称
    private String billCode; // 计划编码
    private BigDecimal totalPlanMny; // 批次计划金额
    private Long employeeId; // 经办人id
    private String employeeName; // 经办人
    private String memo; // 备注
    private Long orgId; // 所属项目部Id
    private String orgName; // 所属项目部名称
    private Integer billState; // 单据状态
    private String createUserName; // 创建人名称
    private String modifyUserName; // 修改人名称
    @JsonFormat(
            shape = JsonFormat.Shape.STRING,
            pattern = "yyyy-MM-dd HH:mm:ss",
            timezone = "GMT+8"
    )
    private Date commitDate; // 提交日期
    private String commitUserName; // 提交人名称
    private String commitUserCode; // 提交人账号

    private String billStateName; //单据类型名称
    private String partName; //部位

    private List<BatchPlanSubVO> batchPlanSubList = new ArrayList<>(); // 批次计划物资实体
    @ReferSerialTransfer(referCode="market-project")
    public Long getProjectId() {
        return projectId;
    }
    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public BigDecimal getTotalPlanMny() {
        return totalPlanMny;
    }

    public void setTotalPlanMny(BigDecimal totalPlanMny) {
        this.totalPlanMny = totalPlanMny;
    }
    @ReferSerialTransfer(referCode="idm-user")
    public Long getEmployeeId() {
        return employeeId;
    }
    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }

    public String getEmployeeName() {
        return employeeName;
    }

    public String getPartName() {
        return partName;
    }

    public void setPartName(String partName) {
        this.partName = partName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }

    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getCreateUserName() {
        return createUserName;
    }

    public void setCreateUserName(String createUserName) {
        this.createUserName = createUserName;
    }
    public String getModifyUserName() {
        return modifyUserName;
    }

    public void setModifyUserName(String modifyUserName) {
        this.modifyUserName = modifyUserName;
    }
    public Date getCommitDate() {
        return commitDate;
    }

    public void setCommitDate(Date commitDate) {
        this.commitDate = commitDate;
    }
    public String getCommitUserName() {
        return commitUserName;
    }

    public void setCommitUserName(String commitUserName) {
        this.commitUserName = commitUserName;
    }
    public String getCommitUserCode() {
        return commitUserCode;
    }

    public void setCommitUserCode(String commitUserCode) {
        this.commitUserCode = commitUserCode;
    }

    public String getBillStateName() {
        return billStateName;
    }

    public void setBillStateName(String billStateName) {
        this.billStateName = billStateName;
    }

    public List<BatchPlanSubVO> getBatchPlanSubList() {
        return batchPlanSubList;
     }

     public void setBatchPlanSubList(List<BatchPlanSubVO> batchPlanSubList) {
        this.batchPlanSubList = batchPlanSubList;
     }
}
