package com.ejianc.business.material.api;

import com.ejianc.business.material.hystrix.MaterialWarnHystrix;
import com.ejianc.business.material.vo.warn.MaterialWarnVo;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

@FeignClient(name= "ejc-material-web", url="${common.env.feign-client-url}", path="ejc-material-web", fallback = MaterialWarnHystrix.class)
public interface IMaterialWarnApi {
    /**
     * 租户下，按照项目分类，支出合同累计金额-物资合同累计
     * @param tenantIds
     * @return
     */
    @PostMapping(value = "/api/materialWarn/materialProjectOutMny")
    CommonResponse<List<MaterialWarnVo>> materialProjectOutMny(@RequestBody List<Long> tenantIds);
}
