package com.ejianc.business.material.vo;

import com.baomidou.mybatisplus.annotation.TableField;
import com.ejianc.business.delivery.vo.MaterialDeliveryVO;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 采购订单
 * 
 * @author generator
 * 
 */
public class PurchaseOrderVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private String billCode; // 申请单号
    private String name; // 申请单名称
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date billDate; // 单据日期
    private Integer billState; // 单据状态
    private Long contractId; // 合同名称
    private String contractName; // 合同
    private Long projectId; // 项目名称
    private String projectName; // 项目
    private Long orgId; // 组织参照
    private String orgName; // 组织名称
    private Long supplierId; // 供应商
    private String supplierName; // 供应商
    private Long purchaseTypeId; // 采购类型id
    private String purchaseTypeName; // 采购类型名称
    /**
     * 合同采购方式：
     * 1、当合同的所属组织类型为：集团、公司、分公司、经理部时，采购方式为公司集采合同（及需求中定义的框架合同）
     * 2、当合同的所属组织类型为项目部时，采购方式为项目自采合同
     */
    private String purchaseMode;
    private Long employeeId; // 联系人
    private String employeeName; // 联系人
    private String employeePhone; // 联系人电话
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date goodsDate; // 要求到货日期
    private String goodsAddress; // 送货地址
    private String goodsRule; // 送货要求
    private Integer instoreOver; //1:已入库完毕  2：未入库完毕
    private BigDecimal totalTaxMny; // 订单金额

    private Long applyId; // 用料申请id
    private Integer sendToSupplier; // 是否发给供应商
    private Integer orderState; // orderState: 0待确认1已确认2已发货(部分发货) 3已发货(全部发货)
    private String supplierLinker; // 供方联系人
    private String supplierLinkerPhone; // 供方联系电话

    /**
     * 税率
     */
    private Double taxRate;

    private List<PurchaseOrderDetailVO> purchaseOrderDetailList = new ArrayList<>(); // 采购订单子表

    private List<MaterialDeliveryVO> deliveryList = new ArrayList<>();  // 送货单列表

    private String billStateName;

    public Double getTaxRate() {
        return taxRate;
    }

    public void setTaxRate(Double taxRate) {
        this.taxRate = taxRate;
    }

    public List<MaterialDeliveryVO> getDeliveryList() {
        return deliveryList;
    }

    public void setDeliveryList(List<MaterialDeliveryVO> deliveryList) {
        this.deliveryList = deliveryList;
    }

    public Long getApplyId() {
        return applyId;
    }
    public void setApplyId(Long applyId) {
        this.applyId = applyId;
    }

    public Integer getSendToSupplier() {
        return sendToSupplier;
    }

    public void setSendToSupplier(Integer sendToSupplier) {
        this.sendToSupplier = sendToSupplier;
    }

    public Integer getOrderState() {
        return orderState;
    }

    public void setOrderState(Integer orderState) {
        this.orderState = orderState;
    }

    public String getSupplierLinker() {
        return supplierLinker;
    }

    public void setSupplierLinker(String supplierLinker) {
        this.supplierLinker = supplierLinker;
    }

    public String getSupplierLinkerPhone() {
        return supplierLinkerPhone;
    }

    public void setSupplierLinkerPhone(String supplierLinkerPhone) {
        this.supplierLinkerPhone = supplierLinkerPhone;
    }

    public BigDecimal getTotalTaxMny() {
        return totalTaxMny;
    }

    public void setTotalTaxMny(BigDecimal totalTaxMny) {
        this.totalTaxMny = totalTaxMny;
    }

    public String getBillStateName() {
        return billStateName;
    }

    public void setBillStateName(String billStateName) {
        this.billStateName = billStateName;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Date getBillDate() {
        return billDate;
    }

    public void setBillDate(Date billDate) {
        this.billDate = billDate;
    }

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    @ReferSerialTransfer(referCode="materialContract")
    public Long getContractId() {
        return contractId;
    }

    @ReferDeserialTransfer
    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }
    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }

    @ReferSerialTransfer(referCode="market-project")
    public Long getProjectId() {
        return projectId;
    }

    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    @ReferSerialTransfer(referCode="support-supplier")
    public Long getSupplierId() {
        return supplierId;
    }

    @ReferDeserialTransfer
    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }

    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }

    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getPurchaseTypeId() {
        return purchaseTypeId;
    }
    @ReferDeserialTransfer
    public void setPurchaseTypeId(Long purchaseTypeId) {
        this.purchaseTypeId = purchaseTypeId;
    }

    public String getPurchaseTypeName() {
        return purchaseTypeName;
    }

    public void setPurchaseTypeName(String purchaseTypeName) {
        this.purchaseTypeName = purchaseTypeName;
    }

    public Integer getInstoreOver() {
        return instoreOver;
    }

    public void setInstoreOver(Integer instoreOver) {
        this.instoreOver = instoreOver;
    }

    public String getPurchaseMode() {
        return purchaseMode;
    }

    public void setPurchaseMode(String purchaseMode) {
        this.purchaseMode = purchaseMode;
    }

    @ReferSerialTransfer(referCode = "idm-employee")
    public Long getEmployeeId() {
        return employeeId;
    }

    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public String getEmployeePhone() {
        return employeePhone;
    }

    public void setEmployeePhone(String employeePhone) {
        this.employeePhone = employeePhone;
    }
    public Date getGoodsDate() {
        return goodsDate;
    }

    public void setGoodsDate(Date goodsDate) {
        this.goodsDate = goodsDate;
    }
    public String getGoodsAddress() {
        return goodsAddress;
    }

    public void setGoodsAddress(String goodsAddress) {
        this.goodsAddress = goodsAddress;
    }
    public String getGoodsRule() {
        return goodsRule;
    }

    public void setGoodsRule(String goodsRule) {
        this.goodsRule = goodsRule;
    }
    
     public List<PurchaseOrderDetailVO> getPurchaseOrderDetailList() {
        return purchaseOrderDetailList;
     }

     public void setPurchaseOrderDetailList(List<PurchaseOrderDetailVO> purchaseOrderDetailList) {
        this.purchaseOrderDetailList = purchaseOrderDetailList;
     }
}
