package com.ejianc.business.material.vo;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import com.baomidou.mybatisplus.annotation.TableField;
import com.ejianc.business.material.pub.MaterialStoreType;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * @Author liyongjia
 * @Date 2020/6/11  采购入库实体
 * @Description InstoreEntity
 */

public class InstoreVO extends BaseVO {

	private static final long serialVersionUID = 1L;

	/**
	 * 调拨入库时候，记录调拨出库主表id
	 */
	private Long outId;

	/**
	 * 调拨入库时候，记录调拨出库主表调出组织
	 */
	private Long outOrgId;

	/**
	 * 调拨入库时候，记录调拨出库主表调出项目id
	 */
	private Long outProjectId;

	/**
	 * 调拨入库时候，记录调拨出库主表调出项目名称
	 */
	private String outProjectName;

	/**
	 * 调拨入库时候，记录调拨出库主表调出仓库id
	 */
	private Long outStoreId;

	/**
	 * 调拨入库时候，记录调拨出库主表调出仓库名称
	 */
	private String outStoreName;

	/**
	 * 调拨入库时候，记录调拨出库主表调出组织
	 */
	private String outOrgName;

	/**
	 * 调拨入库时候，记录收料状态
	 */
	private String receiveState;

	/**
	 * 调拨入库时候，记录收料人
	 */
	private String receivePerson;


	/**
	 * 调拨入库时候，记录收料日期
	 */
	@JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
	private Date receiveDate;

    /**
     * 入库单号
     */
    private String billCode;
	
    /**
     * 单据状态
     */
    private Integer billState;
	
    /**
     * 入库日期
     */
	@JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date instoreDate;
	
    /**
     * 所属组织
     */
    private Long orgId;
	
    /**
     * 所属组织名称
     */
    private String orgName;
	
    /**
     * 是否属于项目
     */
    private String projectFlag;
	
    /**
     * 所属项目
     */
    private Long projectId;
	
    /**
     * 所属项目名称
     */
    private String projectName;
    
    /**
     * 所属项目编码
     */
    private String projectCode;
	
    /**
     * 仓库
     */
    private Long storeId;
	
    /**
     * 仓库名称
     */
    private String storeName;
	
    /**
     * 供应商
     */
    private Long supplierId;
	
    /**
     * 供应商名称
     */
    private String supplierName;
	
    /**
     * 编制人
     */
    private String userName;
	
    /**
     * 合同
     */
    private Long contractId;
	
    /**
     * 合同名称
     */
    private String contractName;
	
    /**
     * 是否有合同入库（hasContract :有合同入库;noContract :无合同入库）
     */
    private String contractType;
	
    /**
     * 入库类型（1:收料入库,2:直接入库,3:调拨入库,4:物资退库,5:盘盈入库）
     */
    private Integer instoreType;
    
    /**
     * 入库类型（1:收料入库,2:直接入库,3:调拨入库,4:物资退库,5:盘盈入库）
     */
    private String instoreTypeName;
	
    /**
     * 备注
     */
    private String note;
	
    /**
     * 用途
     */
    private String purpose;
    
    /**
     * 是否被付款引用（1引用,0未引用）
     */
    private Integer paymentFlag = 0;

	/**
	 * 是否结算（1已结算,0未结算） 收料入库&直入直出使用
	 */
    private Integer settlementFlag = 0;

    /**
     * 子表
     */
    private List<InstoreMaterialVO> instoreMaterialList = new ArrayList<>();
    
    /**
     * 物资种类
     */
    private String materialName;
    
    /**
     * 入库数量
     */
    private BigDecimal totalCount;
    
    /**
     * 入库金额
     */
    private BigDecimal totalAmount;

    /**
     * 入库金额
     */
    private BigDecimal totalAmountNoTax;

    /**
     * 退库人---领料退库
     */
    private String pickReturnPerson;
	
    /**
     * 退库原因---领料退库
     */
    private String pickReturnReason;

    /**
     * 入库金额统计----仅统计
     */
    private BigDecimal allTotalAmount;

	/**
	 * 成本关联科目状态(1:是，0：否)
	 */
	private String relationFlag;

	/**
	 * 成本分摊状态(1:是，0：否)
	 */
	private String proportionFlag;

	/**
	 * 税率
	 */
	private BigDecimal taxRate;

	private Long labourArmyId;

	private String labourArmy;
	//车牌号
	private String carNumber;

	private Long employeeId; // 经办人id
	private String employeeName; // 经办人

	/**
	 * 合同采购方式：
	 * 1公司集采合同
	 * 2项目自采合同
	 */
	private String contractPurchaseMode;


	public String getContractPurchaseMode() {
		return contractPurchaseMode;
	}

	public void setContractPurchaseMode(String contractPurchaseMode) {
		this.contractPurchaseMode = contractPurchaseMode;
	}

	public Long getOutId() {
		return outId;
	}

	public void setOutId(Long outId) {
		this.outId = outId;
	}

	public Long getOutOrgId() {
		return outOrgId;
	}

	public void setOutOrgId(Long outOrgId) {
		this.outOrgId = outOrgId;
	}

	public Long getOutProjectId() {
		return outProjectId;
	}

	public void setOutProjectId(Long outProjectId) {
		this.outProjectId = outProjectId;
	}

	public String getOutProjectName() {
		return outProjectName;
	}

	public void setOutProjectName(String outProjectName) {
		this.outProjectName = outProjectName;
	}

	public Long getOutStoreId() {
		return outStoreId;
	}

	public void setOutStoreId(Long outStoreId) {
		this.outStoreId = outStoreId;
	}

	public String getOutStoreName() {
		return outStoreName;
	}

	public void setOutStoreName(String outStoreName) {
		this.outStoreName = outStoreName;
	}

	public String getOutOrgName() {
		return outOrgName;
	}

	public void setOutOrgName(String outOrgName) {
		this.outOrgName = outOrgName;
	}

	public String getReceiveState() {
		return receiveState;
	}

	public void setReceiveState(String receiveState) {
		this.receiveState = receiveState;
	}

	public String getReceivePerson() {
		return receivePerson;
	}

	public void setReceivePerson(String receivePerson) {
		this.receivePerson = receivePerson;
	}

	public Date getReceiveDate() {
		return receiveDate;
	}

	public void setReceiveDate(Date receiveDate) {
		this.receiveDate = receiveDate;
	}

	public String getBillCode() {
		return billCode;
	}

	public void setBillCode(String billCode) {
		this.billCode = billCode;
	}

	public Integer getBillState() {
		return billState;
	}

	public void setBillState(Integer billState) {
		this.billState = billState;
	}

	public Date getInstoreDate() {
		return instoreDate;
	}

	public void setInstoreDate(Date instoreDate) {
		this.instoreDate = instoreDate;
	}

    @ReferSerialTransfer(referCode="idm-org")
	public Long getOrgId() {
		return orgId;
	}

    @ReferDeserialTransfer
	public void setOrgId(Long orgId) {
		this.orgId = orgId;
	}

	public String getOrgName() {
		return orgName;
	}

	public void setOrgName(String orgName) {
		this.orgName = orgName;
	}

    @ReferSerialTransfer(referCode="material-store")
	public Long getStoreId() {
		return storeId;
	}

    @ReferDeserialTransfer
	public void setStoreId(Long storeId) {
		this.storeId = storeId;
	}

	public String getStoreName() {
		return storeName;
	}

	public void setStoreName(String storeName) {
		this.storeName = storeName;
	}

    @ReferSerialTransfer(referCode="support-supplier")
	public Long getSupplierId() {
		return supplierId;
	}

    @ReferDeserialTransfer
	public void setSupplierId(Long supplierId) {
		this.supplierId = supplierId;
	}

	public String getSupplierName() {
		return supplierName;
	}

	public void setSupplierName(String supplierName) {
		this.supplierName = supplierName;
	}

	public String getUserName() {
		return userName;
	}

	public void setUserName(String userName) {
		this.userName = userName;
	}

    @ReferSerialTransfer(referCode="materialContract")
	public Long getContractId() {
		return contractId;
	}

    @ReferDeserialTransfer
	public void setContractId(Long contractId) {
		this.contractId = contractId;
	}

	public String getContractName() {
		return contractName;
	}

	public void setContractName(String contractName) {
		this.contractName = contractName;
	}

	public String getProjectFlag() {
		return projectFlag;
	}

	public void setProjectFlag(String projectFlag) {
		this.projectFlag = projectFlag;
	}

    @ReferSerialTransfer(referCode="market-project")
	public Long getProjectId() {
		return projectId;
	}

    @ReferDeserialTransfer
	public void setProjectId(Long projectId) {
		this.projectId = projectId;
	}

	public String getProjectName() {
		return projectName;
	}

	public void setProjectName(String projectName) {
		this.projectName = projectName;
	}

	public String getProjectCode() {
		return projectCode;
	}

	public void setProjectCode(String projectCode) {
		this.projectCode = projectCode;
	}

	public String getContractType() {
		return contractType;
	}

	public void setContractType(String contractType) {
		this.contractType = contractType;
	}

	public List<InstoreMaterialVO> getInstoreMaterialList() {
		return instoreMaterialList;
	}

	public void setInstoreMaterialList(List<InstoreMaterialVO> instoreMaterialList) {
		this.instoreMaterialList = instoreMaterialList;
	}

	public String getNote() {
		return note;
	}

	public void setNote(String note) {
		this.note = note;
	}

	public String getMaterialName() {
		return materialName;
	}

	public void setMaterialName(String materialName) {
		this.materialName = materialName;
	}

	public BigDecimal getTotalCount() {
		return totalCount;
	}

	public void setTotalCount(BigDecimal totalCount) {
		this.totalCount = totalCount;
	}

	public BigDecimal getTotalAmount() {
		return totalAmount;
	}

	public void setTotalAmount(BigDecimal totalAmount) {
		this.totalAmount = totalAmount;
	}

	public BigDecimal getTotalAmountNoTax() {
		return totalAmountNoTax;
	}

	public void setTotalAmountNoTax(BigDecimal totalAmountNoTax) {
		this.totalAmountNoTax = totalAmountNoTax;
	}

	public BigDecimal getAllTotalAmount() {
		return allTotalAmount;
	}

	public void setAllTotalAmount(BigDecimal allTotalAmount) {
		this.allTotalAmount = allTotalAmount;
	}

	public Integer getInstoreType() {
		return instoreType;
	}

	public void setInstoreType(Integer instoreType) {
		this.instoreType = instoreType;
	}

	public String getPurpose() {
		return purpose;
	}

	public void setPurpose(String purpose) {
		this.purpose = purpose;
	}

	public String getPickReturnPerson() {
		return pickReturnPerson;
	}

	public void setPickReturnPerson(String pickReturnPerson) {
		this.pickReturnPerson = pickReturnPerson;
	}

	public String getPickReturnReason() {
		return pickReturnReason;
	}

	public void setPickReturnReason(String pickReturnReason) {
		this.pickReturnReason = pickReturnReason;
	}

	public String getInstoreTypeName() {
		return instoreType != null ? MaterialStoreType.getStoreTypeNameByCode(instoreType) : null;
	}

	public void setInstoreTypeName(String instoreTypeName) {
		this.instoreTypeName = instoreTypeName;
	}

	public Integer getPaymentFlag() {
		return paymentFlag;
	}

	public void setPaymentFlag(Integer paymentFlag) {
		this.paymentFlag = paymentFlag;
	}

	public Integer getSettlementFlag() {
		return settlementFlag;
	}

	public void setSettlementFlag(Integer settlementFlag) {
		this.settlementFlag = settlementFlag;
	}

	public String getRelationFlag() {
		return relationFlag;
	}

	public void setRelationFlag(String relationFlag) {
		this.relationFlag = relationFlag;
	}

	public String getProportionFlag() {
		return proportionFlag;
	}

	public void setProportionFlag(String proportionFlag) {
		this.proportionFlag = proportionFlag;
	}

	public BigDecimal getTaxRate() {
		return taxRate;
	}

	public void setTaxRate(BigDecimal taxRate) {
		this.taxRate = taxRate;
	}
	@ReferSerialTransfer(referCode="support-supplier")
	public Long getLabourArmyId() {
		return labourArmyId;
	}
	@ReferDeserialTransfer
	public void setLabourArmyId(Long labourArmyId) {
		this.labourArmyId = labourArmyId;
	}

	public String getLabourArmy() {
		return labourArmy;
	}

	public void setLabourArmy(String labourArmy) {
		this.labourArmy = labourArmy;
	}

	public String getCarNumber() {
		return carNumber;
	}

	public void setCarNumber(String carNumber) {
		this.carNumber = carNumber;
	}
	@ReferSerialTransfer(referCode="idm-employee")
	public Long getEmployeeId() {
		return employeeId;
	}
	@ReferDeserialTransfer
	public void setEmployeeId(Long employeeId) {
		this.employeeId = employeeId;
	}

	public String getEmployeeName() {
		return employeeName;
	}

	public void setEmployeeName(String employeeName) {
		this.employeeName = employeeName;
	}
}
