package com.ejianc.business.material.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.Date;

/**
 * @Description UseApplySubEntity
 */

public class UseApplyFinishVO extends BaseVO {

    private static final long serialVersionUID = 2779265683203439571L;

    /**
     * 主表id
     */
    private Long pid;

    /**
     * 物资分类名称
     */
    private String materialTypeName;


    /**
     * 物资分类id
     */
    private Long materialTypeId;

    /**
     * 物资名称
     */
    private String materialName;

    /**
     * 物资id
     */
    private Long materialId;

    /**
     * 规格型号
     */
    private String model;

    /**
     * 计量单位
     */
    private String unit;

    /**
     * 申请数量
     */
    private BigDecimal applyNum;

    /**
     * 暂估单价
     */
    private BigDecimal estimatePrice;

    /**
     * 暂估金额
     */
    private BigDecimal estimateMoney;

    /**
     * 计划进场日期
     */
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date subPlanEnterDate;

    /**
     * 备注
     */
    private String memo;

    private String materialInfo; // 采购物资名称
    private Long modelId; // 规格型号id
    private String thickness; // 厚度
    private String colour; // 色号/容重
    private BigDecimal orderNum; // 订货量
    private BigDecimal planNum; // 进度量
    private BigDecimal totalNum; // 总量
    private Integer isFinish; // 是否完成1是0否

    private BigDecimal sumApplyNum; // 累计申请量


    public BigDecimal getSumApplyNum() {
        return sumApplyNum;
    }

    public void setSumApplyNum(BigDecimal sumApplyNum) {
        this.sumApplyNum = sumApplyNum;
    }


    public String getMaterialInfo() {
        return materialInfo;
    }

    public void setMaterialInfo(String materialInfo) {
        this.materialInfo = materialInfo;
    }


    @ReferDeserialTransfer@ReferSerialTransfer(referCode = "support-defdoc")
    public Long getModelId() {
        return modelId;
    }
    @ReferDeserialTransfer
    public void setModelId(Long modelId) {
        this.modelId = modelId;
    }

    public String getThickness() {
        return thickness;
    }

    public void setThickness(String thickness) {
        this.thickness = thickness;
    }

    public String getColour() {
        return colour;
    }

    public void setColour(String colour) {
        this.colour = colour;
    }

    public BigDecimal getOrderNum() {
        return orderNum;
    }

    public void setOrderNum(BigDecimal orderNum) {
        this.orderNum = orderNum;
    }

    public BigDecimal getPlanNum() {
        return planNum;
    }

    public void setPlanNum(BigDecimal planNum) {
        this.planNum = planNum;
    }

    public BigDecimal getTotalNum() {
        return totalNum;
    }

    public void setTotalNum(BigDecimal totalNum) {
        this.totalNum = totalNum;
    }

    public Integer getIsFinish() {
        return isFinish;
    }

    public void setIsFinish(Integer isFinish) {
        this.isFinish = isFinish;
    }

    public Long getPid() {
        return pid;
    }

    public void setPid(Long pid) {
        this.pid = pid;
    }

    public String getMaterialTypeName() {
        return materialTypeName;
    }

    public void setMaterialTypeName(String materialTypeName) {
        this.materialTypeName = materialTypeName;
    }

    public Long getMaterialTypeId() {
        return materialTypeId;
    }

    public void setMaterialTypeId(Long materialTypeId) {
        this.materialTypeId = materialTypeId;
    }

    public String getMaterialName() {
        return materialName;
    }

    public void setMaterialName(String materialName) {
        this.materialName = materialName;
    }

    public Long getMaterialId() {
        return materialId;
    }

    public void setMaterialId(Long materialId) {
        this.materialId = materialId;
    }

    public String getModel() {
        return model;
    }

    public void setModel(String model) {
        this.model = model;
    }

    public String getUnit() {
        return unit;
    }

    public void setUnit(String unit) {
        this.unit = unit;
    }

    public BigDecimal getApplyNum() {
        return applyNum;
    }

    public void setApplyNum(BigDecimal applyNum) {
        this.applyNum = applyNum;
    }

    public BigDecimal getEstimatePrice() {
        return estimatePrice;
    }

    public void setEstimatePrice(BigDecimal estimatePrice) {
        this.estimatePrice = estimatePrice;
    }

    public BigDecimal getEstimateMoney() {
        return estimateMoney;
    }

    public void setEstimateMoney(BigDecimal estimateMoney) {
        this.estimateMoney = estimateMoney;
    }

    public Date getSubPlanEnterDate() {
        return subPlanEnterDate;
    }

    public void setSubPlanEnterDate(Date subPlanEnterDate) {
        this.subPlanEnterDate = subPlanEnterDate;
    }

    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
}
