/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.material.api;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.material.hystrix.MaterialContractHystrix;
import com.ejianc.business.material.vo.MaterialContractVO;
import com.ejianc.business.material.vo.MaterialReportVo;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import java.math.BigDecimal;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@FeignClient(name="ejc-material-web", url="${common.env.feign-client-url}", path="ejc-material-web", fallback=MaterialContractHystrix.class)
public interface IMaterialContractApi {
    @PostMapping(value={"/api/materialContract/queryContractList"})
    public CommonResponse<JSONObject> queryContractList(@RequestBody QueryParam var1);

    @GetMapping(value={"/api/materialContract/queryContractById"})
    public CommonResponse<JSONObject> queryContractInfoById(@RequestParam(value="id") Long var1);

    @GetMapping(value={"/api/materialContract/queryContractNumAndMoneyAndSettleMoneyByProjectId"})
    public CommonResponse<JSONObject> queryContractNumAndMoneyAndSettleMoneyByProjectId(@RequestParam(value="projectId") Long var1);

    @RequestMapping(value={"/api/materialContract/getMonthMaterialMny"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<MaterialReportVo>> getMonthMaterialMny(@RequestParam(value="projectId") Long var1, @RequestParam(value="lastDay") Integer var2);

    @RequestMapping(value={"/api/materialContract/getMaterialContract"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<MaterialReportVo> getMaterialContract(@RequestParam(value="projectId") Long var1);

    @GetMapping(value={"/api/materialContract/fetchAmountWithTax"})
    public CommonResponse<BigDecimal> fetchAmountWithTax(@RequestParam(value="projectId") Long var1);

    @PostMapping(value={"/api/materialContract/getContractByCondition"})
    @ResponseBody
    public CommonResponse<List<MaterialContractVO>> getContractByCondition(@RequestBody List<Long> var1);

    @GetMapping(value={"/api/materialContract/fetchSjzcje"})
    public CommonResponse<BigDecimal> fetchSjzcje(@RequestParam(value="projectId") Long var1);
}

