package com.ejianc.business.plan.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * 物资总计划变更-数据载体
 *
 * @author CJ
 * @Description: 物资总计划变更-数据载体
 * @date 2021/3/5 10:01
 */
public class PlanChangeVO extends BaseVO {

    private static final long serialVersionUID = -7588639006180868384L;

    /**
     * 项目Id
     */
    private Long projectId;

    /**
     * 所属项目部Id
     */
    private Long orgId;

    /**
     * 所属项目部名称
     */
    private String orgName;

    /**
     * 项目名称
     */
    private String projectName;
    /**
     * 计划编码
     */
    private String planCode;
    /**
     * 现计划金额
     */
    private BigDecimal totalPlanAmt;
    /**
     * 备注
     */
    private String remark;

    private List<PlanChangeSubVO> materialSubList;

    /**
     * 单据状态
     */
    private Integer billState;

    /**
     * 变更人
     */
    private String changeUserName;

    /**
     * 变更原因
     */
    private String changeReason;

    /**
     * 原计划金额
     */
    private BigDecimal originalPlanAmt;

    /**
     * 源计划数据Id
     */
    private Long sourcePlanId;

    /**
     * 创建人名称
     */
    private String createUserName;

    /**
     * 修改人名称
     */
    private String modifyUserName;

    /**
     * 提交日期
     */
    @JsonFormat(
            shape = JsonFormat.Shape.STRING,
            pattern = "yyyy-MM-dd HH:mm:ss",
            timezone = "GMT+8"
    )
    private Date commitDate;

    /**
     * 提交人名称
     */
    private String commitUserName;

    /**
     * 提交人账号
     */
    private String commitUserCode;

    /**
     * 生效日期
     */
    @JsonFormat(
            shape = JsonFormat.Shape.STRING,
            pattern = "yyyy-MM-dd HH:mm:ss",
            timezone = "GMT+8"
    )
    private Date effectiveDate;

    /**
     * 变更版本
     */
    private Integer changeVersion;

    public Integer getChangeVersion() {
        return changeVersion;
    }

    public void setChangeVersion(Integer changeVersion) {
        this.changeVersion = changeVersion;
    }

    @Override
    public String getCreateUserName() {
        return createUserName;
    }

    public void setCreateUserName(String createUserName) {
        this.createUserName = createUserName;
    }

    public String getModifyUserName() {
        return modifyUserName;
    }

    public void setModifyUserName(String modifyUserName) {
        this.modifyUserName = modifyUserName;
    }

    public Date getCommitDate() {
        return commitDate;
    }

    public void setCommitDate(Date commitDate) {
        this.commitDate = commitDate;
    }

    public String getCommitUserName() {
        return commitUserName;
    }

    public void setCommitUserName(String commitUserName) {
        this.commitUserName = commitUserName;
    }

    public String getCommitUserCode() {
        return commitUserCode;
    }

    public void setCommitUserCode(String commitUserCode) {
        this.commitUserCode = commitUserCode;
    }

    public Date getEffectiveDate() {
        return effectiveDate;
    }

    public void setEffectiveDate(Date effectiveDate) {
        this.effectiveDate = effectiveDate;
    }

    public Long getSourcePlanId() {
        return sourcePlanId;
    }

    public void setSourcePlanId(Long sourcePlanId) {
        this.sourcePlanId = sourcePlanId;
    }

    public Long getProjectId() {
        return projectId;
    }

    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public String getPlanCode() {
        return planCode;
    }

    public void setPlanCode(String planCode) {
        this.planCode = planCode;
    }

    public BigDecimal getTotalPlanAmt() {
        return totalPlanAmt;
    }

    public void setTotalPlanAmt(BigDecimal totalPlanAmt) {
        this.totalPlanAmt = totalPlanAmt;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public List<PlanChangeSubVO> getMaterialSubList() {
        return materialSubList;
    }

    public void setMaterialSubList(List<PlanChangeSubVO> materialSubList) {
        this.materialSubList = materialSubList;
    }

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    public String getChangeUserName() {
        return changeUserName;
    }

    public void setChangeUserName(String changeUserName) {
        this.changeUserName = changeUserName;
    }

    public String getChangeReason() {
        return changeReason;
    }

    public void setChangeReason(String changeReason) {
        this.changeReason = changeReason;
    }

    public BigDecimal getOriginalPlanAmt() {
        return originalPlanAmt;
    }

    public void setOriginalPlanAmt(BigDecimal originalPlanAmt) {
        this.originalPlanAmt = originalPlanAmt;
    }
}
