package com.ejianc.business.material.hystrix;

import com.ejianc.business.material.api.IMaterialSettlementApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.RequestBody;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

@Component
public class MaterialSettlementApiHystrix implements IMaterialSettlementApi {
    /**
     * @param settlementBillId
     * @param currentApplyAmount
     * @Author mrsir_wxp
     * @Date 2020/6/24 更新结算单累计已申请金额，其中currentApplyAmount  本期申请金额  可正可负，正为审批通过后调用，负为逆操作调用
     * @Description updateSettlementBillAlreadyApplyAmount
     * @Param SettlementBillId  结算单id
     * @Param currentApplyAmount  本期申请金额
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @Override
    public CommonResponse<String> updateSettlementBillAlreadyApplyAmount(Long settlementBillId, BigDecimal currentApplyAmount) {
        return CommonResponse.error("网络问题， 查询失败。");
    }

    /**
     * @param settlementBillId
     * @param currentPaidAmount
     * @Author mrsir_wxp
     * @Date 2020/6/24 更新结算单累计已付款金额，currentPaidAmount  本期已付款金额  可正可负，正为审批通过后调用，负为逆操作调用
     * @Description updateSettlementBillAlreadyApplyAmount
     * @Param settlementBillId  结算单id
     * @Param currentPaidAmount  本期已付款金额
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @Override
    public CommonResponse<String> updateSettlementBillAlreadyPaidAmount(Long settlementBillId, BigDecimal currentPaidAmount) {
        return CommonResponse.error("网络问题， 查询失败。");
    }

    /**
     * @param contractId
     * @param orgId
     * @Author mrsir_wxp
     * @Date 2020/7/14 根据合同id和组织id查询累计冲抵金额
     * @Description getTotalOffsetAmountByContractIdAndOrgId
     * @Param [contractId, orgId]
     * @Return com.ejianc.framework.core.response.CommonResponse<java.math.BigDecimal>
     */
    @Override
    public CommonResponse<BigDecimal> getTotalOffsetAmountByContractIdAndOrgId(Long contractId, Long orgId) {
        return CommonResponse.error("网络问题， 查询失败。");
    }

    /*
   【收票登记】审批通过后，回写表体【结算信息】页签对应的【物资合同结算】单据数据，
   更新对应表头字段：累计发票核销金额(无税)、累计发票核销金额(含税)
   */
    @Override
    public CommonResponse<String> updateSettlementtotalInvoiceVerifyMny(@RequestBody List<Map<String,String>> settleList){
        return CommonResponse.error("网络问题， 查询失败。");
    }

    /*
    当【收票登记】从审批通过撤销后，回写表体【结算信息】页签对应的【物资合同结算】单据数据，
    更新对应表头字段：累计发票核销金额(无税)、累计发票核销金额(含税)
     */
    @Override
    public CommonResponse<String> callBackSettlementtotalInvoiceVerify(@RequestBody List<Map<String,String>> settleList){
        return CommonResponse.error("网络问题， 查询失败。");
    }

}
