package com.ejianc.business.material.api;

import com.ejianc.business.material.hystrix.MaterialSettlementApiHystrix;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

/**
 * @Author mrsir_wxp
 * @Date 2020/6/24 物资采购结算api
 * @Description IMaterialSettlement
 */
@FeignClient(name= "ejc-material-web", url="${common.env.feign-client-url}", path="ejc-material-web", fallback = MaterialSettlementApiHystrix.class)
public interface IMaterialSettlementApi {
    /**
     * @Author mrsir_wxp
     * @Date 2020/6/24 更新结算单累计已申请金额，其中currentApplyAmount  本期申请金额  可正可负，正为审批通过后调用，负为逆操作调用
     * @Description updateSettlementBillAlreadyApplyAmount
     * @Param settlementBillId  结算单id
     * @Param currentApplyAmount  本期申请金额
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @GetMapping(value = "/api/purchaseSettlement/updateSettlementBillAlreadyApplyAmount")
    CommonResponse<String> updateSettlementBillAlreadyApplyAmount(@RequestParam("settlementBillId") Long settlementBillId,@RequestParam("currentApplyAmount") BigDecimal currentApplyAmount);
    /**
     * @Author mrsir_wxp
     * @Date 2020/6/24 更新结算单累计已付款金额，currentPaidAmount  本期已付款金额  可正可负，正为审批通过后调用，负为逆操作调用
     * @Description updateSettlementBillAlreadyApplyAmount
     * @Param settlementBillId  结算单id
     * @Param currentPaidAmount  本期已付款金额
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @GetMapping(value = "/api/purchaseSettlement/updateSettlementBillAlreadyPaidAmount")
    CommonResponse<String> updateSettlementBillAlreadyPaidAmount(@RequestParam("settlementBillId") Long settlementBillId, @RequestParam("currentPaidAmount") BigDecimal currentPaidAmount);

    /**
     * @Author mrsir_wxp
     * @Date 2020/7/14 根据合同id和组织id查询累计冲抵金额
     * @Description getTotalOffsetAmountByContractIdAndOrgId
     * @Param [contractId, orgId]
     * @Return com.ejianc.framework.core.response.CommonResponse<java.math.BigDecimal>
     */
    @GetMapping(value = "/api/purchaseSettlement/getTotalOffsetAmountByContractIdAndOrgId")
    CommonResponse<BigDecimal> getTotalOffsetAmountByContractIdAndOrgId(@RequestParam("contractId") Long contractId, @RequestParam("orgId") Long orgId);


    /*
    【收票登记】审批通过后，回写表体【结算信息】页签对应的【物资合同结算】单据数据，
    更新对应表头字段：累计发票核销金额(无税)、累计发票核销金额(含税)
    */
    @PostMapping(value = "/api/purchaseSettlement/updateSettlementtotalInvoiceVerify")
    public CommonResponse<String> updateSettlementtotalInvoiceVerifyMny(@RequestBody List<Map<String,String>> settleList);

    /*
    当【收票登记】从审批通过撤销后，回写表体【结算信息】页签对应的【物资合同结算】单据数据，
    更新对应表头字段：累计发票核销金额(无税)、累计发票核销金额(含税)
     */
    @PostMapping(value = "/api/purchaseSettlement/callBackSettlementtotalInvoiceVerify")
    public CommonResponse<String> callBackSettlementtotalInvoiceVerify(@RequestBody List<Map<String,String>> settleList);

}
