package com.ejianc.business.material.vo;

import com.baomidou.mybatisplus.annotation.TableField;
import com.ejianc.framework.skeleton.template.BaseVO;

import java.math.BigDecimal;

/**
 * @author CJ
 * @Description: 合同变更记录子实体-物资明细
 * @date 2020/6/12 11:18
 */
public class ContractDetailRecordVO extends BaseVO {

    private static final long serialVersionUID = 8745427958787693713L;

    /**
     * 物资分类Id
     */
    private Long materialTypeId;


    /**
     * 物资分类名称
     */
    private String materialTypeName;

    /**
     * 物资名称
     */
    private String materialName;

    /**
     * 规则/型号
     */
    private String spec;

    /**
     * 计量单位
     */
    private String measureUnit;

    /**
     * 数量
     */
    private BigDecimal count;

    /**
     * 单价
     */
    private BigDecimal unitPrice;

    /**
     * 金额
     */
    private BigDecimal totalAmount;

    /**
     * 备注
     */
    private String materialRemark;

    /**
     * 物资来源类型：1-物料档案，2-用料申请，3-询价单
     */
    private String sourceType;

    /**
     * 物资来源单据Id
     */
    private Long sourceId;

    /**
     * 物资Id
     */
    private String materialId;

    /**
     * 物资合同Id
     */
    private Long materialContractId;

    //其他字段
    /**
     * 变更项对应主表主键
     */
    private Long changeId;

    /**
     * 变更项子表主键Id
     */
    private Long changBid;


    /**
     * 对应变更前子表主键
     */
    private Long contractDetailId;

    /**
     * 变更类型
     */
    private String changeType;

    private java.lang.Integer srcSupplementFlag; // 是否来源补充协议(1:是，0：否)
    private java.lang.Long srcSupplementId; // 来源补充协议主表ID
    private java.lang.Long srcSupplementDetailId; // 来源补充协议明细ID
    /**
     * 单价(含税)
     */
    private BigDecimal taxUnitPrice;
    /**
     * 金额(含税)
     */
    private BigDecimal taxTotalAmount;
    /**
     * 税额
     */
    private BigDecimal taxDetail;
    /**
     * 税率
     */
    private BigDecimal taxDetailRate;

    public BigDecimal getTaxUnitPrice() {
        return taxUnitPrice;
    }

    public void setTaxUnitPrice(BigDecimal taxUnitPrice) {
        this.taxUnitPrice = taxUnitPrice;
    }

    public BigDecimal getTaxTotalAmount() {
        return taxTotalAmount;
    }

    public void setTaxTotalAmount(BigDecimal taxTotalAmount) {
        this.taxTotalAmount = taxTotalAmount;
    }

    public BigDecimal getTaxDetail() {
        return taxDetail;
    }

    public void setTaxDetail(BigDecimal taxDetail) {
        this.taxDetail = taxDetail;
    }

    public BigDecimal getTaxDetailRate() {
        return taxDetailRate;
    }

    public void setTaxDetailRate(BigDecimal taxDetailRate) {
        this.taxDetailRate = taxDetailRate;
    }

    public Integer getSrcSupplementFlag() {
        return srcSupplementFlag;
    }

    public void setSrcSupplementFlag(Integer srcSupplementFlag) {
        this.srcSupplementFlag = srcSupplementFlag;
    }

    public Long getSrcSupplementId() {
        return srcSupplementId;
    }

    public void setSrcSupplementId(Long srcSupplementId) {
        this.srcSupplementId = srcSupplementId;
    }

    public Long getSrcSupplementDetailId() {
        return srcSupplementDetailId;
    }

    public void setSrcSupplementDetailId(Long srcSupplementDetailId) {
        this.srcSupplementDetailId = srcSupplementDetailId;
    }

    public Long getMaterialTypeId() {
        return materialTypeId;
    }

    public void setMaterialTypeId(Long materialTypeId) {
        this.materialTypeId = materialTypeId;
    }

    public String getMaterialTypeName() {
        return materialTypeName;
    }

    public void setMaterialTypeName(String materialTypeName) {
        this.materialTypeName = materialTypeName;
    }

    public String getMaterialName() {
        return materialName;
    }

    public void setMaterialName(String materialName) {
        this.materialName = materialName;
    }

    public String getSpec() {
        return spec;
    }

    public void setSpec(String spec) {
        this.spec = spec;
    }

    public String getMeasureUnit() {
        return measureUnit;
    }

    public void setMeasureUnit(String measureUnit) {
        this.measureUnit = measureUnit;
    }

    public BigDecimal getCount() {
        return count;
    }

    public void setCount(BigDecimal count) {
        this.count = count;
    }

    public BigDecimal getUnitPrice() {
        return unitPrice;
    }

    public void setUnitPrice(BigDecimal unitPrice) {
        this.unitPrice = unitPrice;
    }

    public BigDecimal getTotalAmount() {
        return totalAmount;
    }

    public void setTotalAmount(BigDecimal totalAmount) {
        this.totalAmount = totalAmount;
    }

    public String getMaterialRemark() {
        return materialRemark;
    }

    public void setMaterialRemark(String materialRemark) {
        this.materialRemark = materialRemark;
    }

    public String getSourceType() {
        return sourceType;
    }

    public void setSourceType(String sourceType) {
        this.sourceType = sourceType;
    }

    public Long getMaterialContractId() {
        return materialContractId;
    }

    public void setMaterialContractId(Long materialContractId) {
        this.materialContractId = materialContractId;
    }

    public Long getChangeId() {
        return changeId;
    }

    public void setChangeId(Long changeId) {
        this.changeId = changeId;
    }

    public Long getChangBid() {
        return changBid;
    }

    public void setChangBid(Long changBid) {
        this.changBid = changBid;
    }

    public Long getContractDetailId() {
        return contractDetailId;
    }

    public void setContractDetailId(Long contractDetailId) {
        this.contractDetailId = contractDetailId;
    }

    public String getChangeType() {
        return changeType;
    }

    public void setChangeType(String changeType) {
        this.changeType = changeType;
    }

    public Long getSourceId() {
        return sourceId;
    }

    public void setSourceId(Long sourceId) {
        this.sourceId = sourceId;
    }

    public String getMaterialId() {
        return materialId;
    }

    public void setMaterialId(String materialId) {
        this.materialId = materialId;
    }
}
