package com.ejianc.business.material.vo;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * @author CJ
 * @Description:
 * @date 2020/7/22 19:46
 */
public class ContractExportVO implements Serializable {

    /**
     * 合同编号
     */
    private String code;

    /**
     * 合同名称
     */
    private String name;

    /**
     * 是否属于项目
     */
    private String dependOnProject;

    /**
     * 所属项目Id
     */
    private Long projectId;

    /**
     * 所属项目名称
     */
    private String projectName;

    /**
     * 所属组织
     */
    private Long orgId;

    /**
     * 签约日期
     */
    private String signDate;

    /**
     * 总包方企业
     */
    private Long contractorEnterpriseId;

    /**
     * 供应商
     */
    private Long supplierId;

    /**
     * 供应商名称
     */
    private String supplierName;

    /**
     * 采购类别
     */
    private Long purchaseType;

    /**
     * 采购类别名称
     */
    private String purchaseTypeName;

    /**
     * 税率
     */
    private Double taxRate;

    /**
     * 合同状态：1-未签订，2-履约中，3-已封账
     */
    private String state;

    /**
     * 合同状态名称
     */
    private String stateName;

    /**
     * 询比价单
     */
    private Long enquiryPriceBillId;

    /**
     * 采购方式：
     * 1、当合同的所属组织类型为：集团、公司、分公司、经理部时，采购方式为公司集采合同（及需求中定义的框架合同）
     * 2、当合同的所属组织类型为项目部时，采购方式为项目自采合同
     */
    private String purchaseMode;
    /**
     * 采购方式名称
     */
    private String purchaseModeName;

    /**
     * 约定支付比例
     */
    private Double aggreedPaymentRatio;

    /**
     * 备注
     */
    private String remark;

    /**
     * 创建人名称
     */
    private String createUserName;

    /**
     * 所属组织名称
     */
    private String orgName;

    /**
     * 合同金额（含税）
     */
    private BigDecimal amountWithTax;

    /**
     * 合同金额（不含税）
     */
    private BigDecimal amountWithoutTax;

    /**
     * 税金
     */
    private BigDecimal taxFee;

    /**
     * 合同变更状态：0-未变更，1-变更中，2-已变更
     */
    private Integer changeState;

    /**
     * 总包方企业名称
     */
    private String contractorEnterpriseName;

    /**
     * 单据审批状态：0、自由态， 1、已提交，2、审批中，3、审批通过，5、审批中
     */
    private Integer billState;

    //页面展示统计字段
    /**
     * 展示字段-税率
     */
    private Double viewTaxRate;

    //其他字段
    /**
     * 变更版本
     */
    private Integer changeVersion;
    /**
     * 变更单主键Id
     */
    private Long changeId;
    /**
     * 变更单编号
     */
    private String changeCode;

    /**
     * 初始版本合同金额（不含税）
     */
    private BigDecimal baseMoney;

    /**
     * 初始版本合同金额（含税）
     */
    private BigDecimal baseTaxMoney;

    /**
     * 变更前合同金额（不含税）
     */
    private BigDecimal beforeChangeMny;

    /**
     * 变更前合同金额（含税）
     */
    private BigDecimal beforeChangeTaxMny;

    /**
     * 变更中合同金额（不含税）
     */
    private BigDecimal changingMny;

    /**
     * 变更中合同金额（含税）
     */
    private BigDecimal changingTaxMny;

    /**
     * 合同变更单据审批状态：0、自由态， 1、已提交，2、审批中，3、审批通过，5、审批中
     */
    private Integer changeBillState;

    /**
     * 询比价单名称
     */
    private String enquiryPriceBillName;

    /**
     * 生效日期
     */
    private Date effectiveDate;

    /**
     * 修改人名称
     */
    private String modifyUserName;

    /**
     * 提交日期
     */
    private Date commitDate;

    /**
     * 提交人名称
     */
    private String commitUserName;

    /**
     * 提交人账号
     */
    private String commitUserCode;

    private String billStateName;
    private String changeStateName;
    private String createTime;
    private String purchaseOrgName;

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDependOnProject() {
        return dependOnProject;
    }

    public void setDependOnProject(String dependOnProject) {
        this.dependOnProject = dependOnProject;
    }

    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getSignDate() {
        return signDate;
    }

    public void setSignDate(String signDate) {
        this.signDate = signDate;
    }

    public Long getContractorEnterpriseId() {
        return contractorEnterpriseId;
    }

    public void setContractorEnterpriseId(Long contractorEnterpriseId) {
        this.contractorEnterpriseId = contractorEnterpriseId;
    }

    public Long getSupplierId() {
        return supplierId;
    }

    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }

    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }

    public Long getPurchaseType() {
        return purchaseType;
    }

    public void setPurchaseType(Long purchaseType) {
        this.purchaseType = purchaseType;
    }

    public String getPurchaseTypeName() {
        return purchaseTypeName;
    }

    public void setPurchaseTypeName(String purchaseTypeName) {
        this.purchaseTypeName = purchaseTypeName;
    }

    public Double getTaxRate() {
        return taxRate;
    }

    public void setTaxRate(Double taxRate) {
        this.taxRate = taxRate;
    }

    public String getState() {
        return state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public String getStateName() {
        return stateName;
    }

    public void setStateName(String stateName) {
        this.stateName = stateName;
    }

    public Long getEnquiryPriceBillId() {
        return enquiryPriceBillId;
    }

    public void setEnquiryPriceBillId(Long enquiryPriceBillId) {
        this.enquiryPriceBillId = enquiryPriceBillId;
    }

    public String getPurchaseMode() {
        return purchaseMode;
    }

    public void setPurchaseMode(String purchaseMode) {
        this.purchaseMode = purchaseMode;
    }

    public String getPurchaseModeName() {
        return purchaseModeName;
    }

    public void setPurchaseModeName(String purchaseModeName) {
        this.purchaseModeName = purchaseModeName;
    }

    public Double getAggreedPaymentRatio() {
        return aggreedPaymentRatio;
    }

    public void setAggreedPaymentRatio(Double aggreedPaymentRatio) {
        this.aggreedPaymentRatio = aggreedPaymentRatio;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public String getCreateUserName() {
        return createUserName;
    }

    public void setCreateUserName(String createUserName) {
        this.createUserName = createUserName;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public BigDecimal getAmountWithTax() {
        return amountWithTax;
    }

    public void setAmountWithTax(BigDecimal amountWithTax) {
        this.amountWithTax = amountWithTax;
    }

    public BigDecimal getAmountWithoutTax() {
        return amountWithoutTax;
    }

    public void setAmountWithoutTax(BigDecimal amountWithoutTax) {
        this.amountWithoutTax = amountWithoutTax;
    }

    public BigDecimal getTaxFee() {
        return taxFee;
    }

    public void setTaxFee(BigDecimal taxFee) {
        this.taxFee = taxFee;
    }

    public Integer getChangeState() {
        return changeState;
    }

    public void setChangeState(Integer changeState) {
        this.changeState = changeState;
    }

    public String getContractorEnterpriseName() {
        return contractorEnterpriseName;
    }

    public void setContractorEnterpriseName(String contractorEnterpriseName) {
        this.contractorEnterpriseName = contractorEnterpriseName;
    }

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    public Double getViewTaxRate() {
        return viewTaxRate;
    }

    public void setViewTaxRate(Double viewTaxRate) {
        this.viewTaxRate = viewTaxRate;
    }

    public Integer getChangeVersion() {
        return changeVersion;
    }

    public void setChangeVersion(Integer changeVersion) {
        this.changeVersion = changeVersion;
    }

    public Long getChangeId() {
        return changeId;
    }

    public void setChangeId(Long changeId) {
        this.changeId = changeId;
    }

    public String getChangeCode() {
        return changeCode;
    }

    public void setChangeCode(String changeCode) {
        this.changeCode = changeCode;
    }

    public BigDecimal getBaseMoney() {
        return baseMoney;
    }

    public void setBaseMoney(BigDecimal baseMoney) {
        this.baseMoney = baseMoney;
    }

    public BigDecimal getBaseTaxMoney() {
        return baseTaxMoney;
    }

    public void setBaseTaxMoney(BigDecimal baseTaxMoney) {
        this.baseTaxMoney = baseTaxMoney;
    }

    public BigDecimal getBeforeChangeMny() {
        return beforeChangeMny;
    }

    public void setBeforeChangeMny(BigDecimal beforeChangeMny) {
        this.beforeChangeMny = beforeChangeMny;
    }

    public BigDecimal getBeforeChangeTaxMny() {
        return beforeChangeTaxMny;
    }

    public void setBeforeChangeTaxMny(BigDecimal beforeChangeTaxMny) {
        this.beforeChangeTaxMny = beforeChangeTaxMny;
    }

    public BigDecimal getChangingMny() {
        return changingMny;
    }

    public void setChangingMny(BigDecimal changingMny) {
        this.changingMny = changingMny;
    }

    public BigDecimal getChangingTaxMny() {
        return changingTaxMny;
    }

    public void setChangingTaxMny(BigDecimal changingTaxMny) {
        this.changingTaxMny = changingTaxMny;
    }

    public Integer getChangeBillState() {
        return changeBillState;
    }

    public void setChangeBillState(Integer changeBillState) {
        this.changeBillState = changeBillState;
    }

    public String getEnquiryPriceBillName() {
        return enquiryPriceBillName;
    }

    public void setEnquiryPriceBillName(String enquiryPriceBillName) {
        this.enquiryPriceBillName = enquiryPriceBillName;
    }

    public Date getEffectiveDate() {
        return effectiveDate;
    }

    public void setEffectiveDate(Date effectiveDate) {
        this.effectiveDate = effectiveDate;
    }

    public String getModifyUserName() {
        return modifyUserName;
    }

    public void setModifyUserName(String modifyUserName) {
        this.modifyUserName = modifyUserName;
    }

    public Date getCommitDate() {
        return commitDate;
    }

    public void setCommitDate(Date commitDate) {
        this.commitDate = commitDate;
    }

    public String getCommitUserName() {
        return commitUserName;
    }

    public void setCommitUserName(String commitUserName) {
        this.commitUserName = commitUserName;
    }

    public String getCommitUserCode() {
        return commitUserCode;
    }

    public void setCommitUserCode(String commitUserCode) {
        this.commitUserCode = commitUserCode;
    }

    public String getBillStateName() {
        return billStateName;
    }

    public void setBillStateName(String billStateName) {
        this.billStateName = billStateName;
    }

    public String getChangeStateName() {
        return changeStateName;
    }

    public void setChangeStateName(String changeStateName) {
        this.changeStateName = changeStateName;
    }

    public String getCreateTime() {
        return createTime;
    }

    public void setCreateTime(String createTime) {
        this.createTime = createTime;
    }

    public String getPurchaseOrgName() {
        return purchaseOrgName;
    }

    public void setPurchaseOrgName(String purchaseOrgName) {
        this.purchaseOrgName = purchaseOrgName;
    }
}
