package com.ejianc.business.material.api;

import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import com.ejianc.business.material.hystrix.StoreHystrix;
import com.ejianc.business.material.vo.StoreVO;
import com.ejianc.framework.core.response.CommonResponse;

/**
 * 仓库的rpc服务
 * 
 * @author liyongjia
 *
 */
@FeignClient(name= "ejc-material-web", url="${common.env.feign-client-url}", path="ejc-material-web", fallback = StoreHystrix.class)
public interface IStoreApi {

	@RequestMapping(value = "/api/store/saveOrUpdate", method=RequestMethod.POST)
	public CommonResponse<StoreVO> saveOrUpdate(@RequestBody StoreVO vo);

	@PostMapping(value = "/api/store/delByProjectId")
	public CommonResponse<StoreVO> delByProjectId(@RequestBody Long projectId);
	
}
