package com.ejianc.business.material.vo;

import com.ejianc.framework.skeleton.template.BaseVO;
import org.springframework.web.bind.annotation.PathVariable;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

/***
 * @description:  物资价格VO

 * @author songlx
 * @date: 2021-05-25
 */
public class MaterialPriceVO extends BaseVO {

    private static final long serialVersionUID = 4702040708147731199L;

    BigDecimal settledAmount;
    BigDecimal currentSettlementAmount;
    BigDecimal contractAmount;
    String purchaseMethod;


    public String getPurchaseMethod() {
        return purchaseMethod;
    }

    public void setPurchaseMethod(String purchaseMethod) {
        this.purchaseMethod = purchaseMethod;
    }

    public BigDecimal getSettledAmount() {
        return settledAmount;
    }

    public void setSettledAmount(BigDecimal settledAmount) {
        this.settledAmount = settledAmount;
    }

    public BigDecimal getCurrentSettlementAmount() {
        return currentSettlementAmount;
    }

    public void setCurrentSettlementAmount(BigDecimal currentSettlementAmount) {
        this.currentSettlementAmount = currentSettlementAmount;
    }

    public BigDecimal getContractAmount() {
        return contractAmount;
    }

    public void setContractAmount(BigDecimal contractAmount) {
        this.contractAmount = contractAmount;
    }


    private Long contractId;
    /**
     * 项目Id
     */
    private Long projectId;

    /**
     * 所属项目部Id
     */
    private Long orgId;

    /**
     * 所属项目部名称
     */
    private String orgName;

    /**
     * 项目名称
     */
    private String projectName;

    /**
     * 物资Id
     */
    private Long materialId;
    /**
     * 物资名称
     */
    private String materialName;

    /**
     * 规则/型号
     */
    private String spec;
    /**
     * 单据数量
     */
    private BigDecimal num = BigDecimal.ZERO;
    /**
     * 单据单价
     */
    private BigDecimal price = BigDecimal.ZERO;

    /**
     * 总计划数量
     */
    private BigDecimal planNum = BigDecimal.ZERO;
    /**
     * 总计划单价
     */
    private BigDecimal planPrice = BigDecimal.ZERO;


    private BigDecimal minPrice = BigDecimal.ZERO;

    private BigDecimal maxPrice = BigDecimal.ZERO;


    private String priceArea = "0.00~0.00";

    //是否是直入直出
    private Boolean isStraight = false;

    public MaterialPriceVO() {
    }

    public Boolean getStraight() {
        return isStraight;
    }

    public void setStraight(Boolean straight) {
        isStraight = straight;
    }

    public MaterialPriceVO(Long projectId) {
        this.projectId = projectId;
    }

    private List<MaterialPriceVO> detail = new ArrayList<>();

    public Long getContractId() {
        return contractId;
    }

    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }

    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public Long getMaterialId() {
        return materialId;
    }

    public void setMaterialId(Long materialId) {
        this.materialId = materialId;
    }

    public String getMaterialName() {
        return materialName;
    }

    public void setMaterialName(String materialName) {
        this.materialName = materialName;
    }

    public BigDecimal getNum() {
        return num;
    }

    public void setNum(BigDecimal num) {
        this.num = num;
    }

    public BigDecimal getPrice() {
        return price;
    }

    public void setPrice(BigDecimal price) {
        this.price = price;
    }

    public BigDecimal getPlanNum() {
        return planNum;
    }

    public void setPlanNum(BigDecimal planNum) {
        this.planNum = planNum;
    }

    public BigDecimal getPlanPrice() {
        return planPrice;
    }

    public void setPlanPrice(BigDecimal planPrice) {
        this.planPrice = planPrice;
    }

    public BigDecimal getMinPrice() {
        return minPrice;
    }

    public void setMinPrice(BigDecimal minPrice) {
        this.minPrice = minPrice;
    }

    public BigDecimal getMaxPrice() {
        return maxPrice;
    }

    public void setMaxPrice(BigDecimal maxPrice) {
        this.maxPrice = maxPrice;
    }

    public String getPriceArea() {
        return priceArea;
    }

    public void setPriceArea(String priceArea) {
        this.priceArea = priceArea;
    }

    public List<MaterialPriceVO> getDetail() {
        return detail;
    }

    public void setDetail(List<MaterialPriceVO> detail) {
        this.detail = detail;
    }

    public String getSpec() {
        return spec;
    }

    public void setSpec(String spec) {
        this.spec = spec;
    }
}
