package com.ejianc.business.utils;

import com.ejianc.framework.core.exception.BusinessException;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

import com.ejianc.framework.core.util.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.springframework.web.multipart.MultipartFile;
public class ExcelReader {

    public ExcelReader() {
    }

    public static List<List<String>> readExcel(MultipartFile file) {
        String originalFileName = file.getOriginalFilename();
        String extName = null;
        originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
        originalFileName.replaceAll("00.", "");
        extName = FileUtils.getFileExt(originalFileName, false);
        if ("xls".equals(extName)) {
            return read2003Excel(file);
        } else if ("xlsx".equals(extName)) {
            return read2007Excel(file);
        } else {
            throw new BusinessException("不支持的文件类型");
        }
    }

    private static List<List<String>> read2003Excel(MultipartFile file) {
        LinkedList list = new LinkedList();

        HSSFWorkbook hwb;
        try {
            hwb = new HSSFWorkbook(new BufferedInputStream(file.getInputStream()));
        } catch (IOException var17) {
            throw new BusinessException(var17.getMessage());
        }

        int size = hwb.getNumberOfSheets();

        for(int index = 0; index < size; ++index) {
            HSSFSheet sheet = hwb.getSheetAt(index);
            String value = null;
            HSSFRow row = null;
            HSSFCell cell = null;
            boolean isEmpty = true;
            int rowFirstCellNum = 0;
            int rowLastCellNum = 0;

            for(int i = sheet.getFirstRowNum() + 1; i < sheet.getPhysicalNumberOfRows(); ++i) {
                isEmpty = true;
                row = sheet.getRow(i);
                if (row != null) {
                    rowLastCellNum = sheet.getRow(0).getLastCellNum();
                    List<String> linked = new LinkedList();

                    int headLength;
                    for(headLength = rowFirstCellNum; headLength < rowLastCellNum; ++headLength) {
                        cell = row.getCell(headLength);
                        if (cell == null) {
                            linked.add("");
                        } else {
                            switch(cell.getCellType()) {
                                case 0:
                                    DecimalFormat df = new DecimalFormat("0.00000000");
                                    value = df.format(cell.getNumericCellValue());
                                    if (null != value && !"".equals(value.trim())) {
                                        String[] item = value.split("[.]");
                                        if (1 < item.length && ("0".equals(item[1]) || "00".equals(item[1]) || "000".equals(item[1]) || "0000".equals(item[1]))) {
                                            value = item[0];
                                        }
                                    }
                                    break;
                                case 1:
                                    value = cell.getStringCellValue().toString();
                                    break;
                                case 2:
                                    value = String.valueOf(cell.getNumericCellValue());
                                    if (value.equals("NaN")) {
                                        value = cell.getStringCellValue().toString();
                                    }
                                    break;
                                case 3:
                                default:
                                    value = cell.getStringCellValue() + "";
                                    break;
                                case 4:
                                    value = " " + cell.getBooleanCellValue();
                            }

                            linked.add(value);
                        }
                    }

                    /*if (list.size() > 0) {
                        headLength = ((List)list.get(0)).size();
                        int nowLinkLength = linked.size();
                        if (nowLinkLength < headLength) {
                            for(int k = nowLinkLength; k < headLength; ++k) {
                                linked.add((Object)null);
                            }
                        }
                    }*/

                    if (isEmpty) {
                        Iterator var19 = linked.iterator();

                        while(var19.hasNext()) {
                            Object object = var19.next();
                            if (object != null && StringUtils.isNotBlank(String.valueOf(object))) {
                                isEmpty = false;
                                break;
                            }
                        }
                    }

                    if (isEmpty) {
                        break;
                    }

                    list.add(linked);
                }
            }
        }

        return list;
    }

    private static List<List<String>> read2007Excel(MultipartFile file) {
        LinkedList list = new LinkedList();

        XSSFWorkbook xwb;
        try {
            xwb = new XSSFWorkbook(new BufferedInputStream(file.getInputStream()));
        } catch (IOException var17) {
            throw new BusinessException(var17.getMessage());
        }

        int size = xwb.getNumberOfSheets();

        for(int index = 0; index < size; ++index) {
            XSSFSheet sheet = xwb.getSheetAt(index);
            String value = null;
            XSSFRow row = null;
            XSSFCell cell = null;
            boolean isEmpty = true;
            int rowFirstCellNum = 0;
            int rowLastCellNum = 0;

            for(int i = sheet.getFirstRowNum() + 1; i < sheet.getPhysicalNumberOfRows(); ++i) {
                isEmpty = true;
                row = sheet.getRow(i);
                rowLastCellNum = sheet.getRow(0).getLastCellNum();
                if (row != null) {
                    List<String> linked = new LinkedList();

                    int headLength;
                    for(headLength = rowFirstCellNum; headLength < rowLastCellNum; ++headLength) {
                        cell = row.getCell(headLength);
                        if (cell == null) {
                            linked.add("");
                        } else {
                            switch(cell.getCellType()) {
                                case 0:
                                    DecimalFormat df = new DecimalFormat("0.00000000");
                                    value = df.format(cell.getNumericCellValue());
                                    if (null != value && !"".equals(value.trim())) {
                                        String[] item = value.split("[.]");
                                        if (1 < item.length && ("0".equals(item[1]) || "00".equals(item[1]) || "000".equals(item[1]) || "0000".equals(item[1]))) {
                                            value = item[0];
                                        }
                                    }
                                    break;
                                case 1:
                                    value = cell.getStringCellValue().toString();
                                    break;
                                case 2:
                                    value = String.valueOf(cell.getNumericCellValue());
                                    if (value.equals("NaN")) {
                                        value = cell.getStringCellValue().toString();
                                    }
                                    break;
                                case 3:
                                default:
                                    value = cell.getStringCellValue() + "";
                                    break;
                                case 4:
                                    value = " " + cell.getBooleanCellValue();
                            }

                            linked.add(value);
                        }
                    }

                    /*if (list.size() > 0) {
                        headLength = ((List)list.get(0)).size();
                        int nowLinkLength = linked.size();
                        if (nowLinkLength < headLength) {
                            for(int k = nowLinkLength; k < headLength; ++k) {
                                linked.add((Object)null);
                            }
                        }
                    }*/

                    if (isEmpty) {
                        Iterator var19 = linked.iterator();

                        while(var19.hasNext()) {
                            Object object = var19.next();
                            if (object != null && StringUtils.isNotBlank(String.valueOf(object))) {
                                isEmpty = false;
                                break;
                            }
                        }
                    }

                    if (isEmpty) {
                        break;
                    }

                    list.add(linked);
                }
            }
        }

        return list;
    }
}
