package com.ejianc.business.storeCheck.vo;

import com.baomidou.mybatisplus.annotation.TableField;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.util.Date;
import java.util.List;

/**
 * @author CJ
 * @Description:
 * @date 2021/3/12 16:17
 */
public class StoreCheckVO extends BaseVO {

    private static final long serialVersionUID = 8804756028472612984L;
    /**
     * 盘点仓库Id
     */
    private Long storeId;

    /**
     * 盘点仓库名称
     */
    private String storeName;

    /**
     * 所属组织Id
     */
    private Long orgId;

    /**
     * 所属组织名称
     */
    private String orgName;

    /**
     * 盘点日期
     */
    @JsonFormat(
            shape = JsonFormat.Shape.STRING,
            pattern = "yyyy-MM-dd HH:mm:ss",
            timezone = "GMT+8"
    )
    private Date checkDate;

    /**
     * 提交日期
     */
    @JsonFormat(
            shape = JsonFormat.Shape.STRING,
            pattern = "yyyy-MM-dd HH:mm:ss",
            timezone = "GMT+8"
    )
    private Date commitDate;

    /**
     * 提交人名称
     */
    private String commitUserName;

    /**
     * 提交人账号
     */
    private String commitUserCode;

    /**
     * 创建人名称
     */
    private String createUserName;

    /**
     * 修改人名称
     */
    private String modifyUserName;

    /**
     * 单据状态
     */
    private Integer billState;

    /**
     * 盘点物资明细
     */
    private List<StoreCheckSubVO> materialSubList;

    /**
     * 盘点编码
     */
    private String billCode;

    /**
     * 生效日期
     */
    @JsonFormat(
            shape = JsonFormat.Shape.STRING,
            pattern = "yyyy-MM-dd HH:mm:ss",
            timezone = "GMT+8"
    )
    private Date effectiveDate;

    /**
     * 盘点单对应入库单据Id
     */
    private Long relationInStoreId;

    /**
     * 盘点单对应出库单据Id
     */
    private Long relationOutStoreId;

    public Long getRelationInStoreId() {
        return relationInStoreId;
    }

    public void setRelationInStoreId(Long relationInStoreId) {
        this.relationInStoreId = relationInStoreId;
    }

    public Long getRelationOutStoreId() {
        return relationOutStoreId;
    }

    public void setRelationOutStoreId(Long relationOutStoreId) {
        this.relationOutStoreId = relationOutStoreId;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    public Long getStoreId() {
        return storeId;
    }

    @ReferDeserialTransfer
    public void setStoreId(Long storeId) {
        this.storeId = storeId;
    }

    public String getStoreName() {
        return storeName;
    }

    public void setStoreName(String storeName) {
        this.storeName = storeName;
    }

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public Date getCheckDate() {
        return checkDate;
    }

    public void setCheckDate(Date checkDate) {
        this.checkDate = checkDate;
    }

    public Date getCommitDate() {
        return commitDate;
    }

    public void setCommitDate(Date commitDate) {
        this.commitDate = commitDate;
    }

    public String getCommitUserName() {
        return commitUserName;
    }

    public void setCommitUserName(String commitUserName) {
        this.commitUserName = commitUserName;
    }

    public String getCommitUserCode() {
        return commitUserCode;
    }

    public void setCommitUserCode(String commitUserCode) {
        this.commitUserCode = commitUserCode;
    }

    @Override
    public String getCreateUserName() {
        return createUserName;
    }

    public void setCreateUserName(String createUserName) {
        this.createUserName = createUserName;
    }

    public String getModifyUserName() {
        return modifyUserName;
    }

    public void setModifyUserName(String modifyUserName) {
        this.modifyUserName = modifyUserName;
    }

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    public Date getEffectiveDate() {
        return effectiveDate;
    }

    public void setEffectiveDate(Date effectiveDate) {
        this.effectiveDate = effectiveDate;
    }

    public List<StoreCheckSubVO> getMaterialSubList() {
        return materialSubList;
    }

    public void setMaterialSubList(List<StoreCheckSubVO> materialSubList) {
        this.materialSubList = materialSubList;
    }
}
