package com.ejianc.business.material.vo;

import com.baomidou.mybatisplus.annotation.TableField;
import com.ejianc.framework.skeleton.template.BaseVO;

import java.math.BigDecimal;

/**
 * @author CJ
 * @Description: 物资合同
 * @date 2020/6/9 14:12
 */
public class MaterialContractDetailSubVO extends BaseVO {

    private static final long serialVersionUID = -7472408353979202521L;

    /**
     * 物资合同Id
     */
    private Long materialContractId;

    /**
     * 物资分类Id
     */
    private Long materialTypeId;

    /**
     * 物资分类名称
     */
    private String materialTypeName;

    /**
     * 物资名称
     */
    private String materialName;

    /**
     * 规则/型号
     */
    private String spec;

    /**
     * 计量单位
     */
    private String measureUnit;

    /**
     * 品牌
     */
    private java.lang.String supplierName;

    /**
     * 数量
     */
    private BigDecimal count;

    /**
     * 单价
     */
    private BigDecimal unitPrice;

    /**
     * 金额
     */
    private BigDecimal totalAmount;

    /**
     * 备注
     */
    private String materialRemark;

    /**
     * 物资来源类型：1-物料档案，2-用料申请，3-询价单，4-导入，5-总计划，6-批次计划
     */
    private String sourceType;

    private String sourceTypeName;

    private Long sourceTypeId; //来源主表id

    /**
     * 物资Id
     */
    private String materialId;

    //其他字段
    /**
     * 变更项对应主表主键
     */
    private Long changeId;

    /**
     * 变更项子表主键Id
     */
    private Long changBid;

    /**
     * 变更类型
     */
    private String changeType;

    /**
     * 物资来源单据Id
     */
    private Long sourceId;


    /**
     * 数量
     */
    private BigDecimal planNum = BigDecimal.ZERO;;
    /**
     *
     */
    private BigDecimal planPrice = BigDecimal.ZERO;


    private BigDecimal minPrice;

    private BigDecimal maxPrice;


    private String priceArea;
    private Long sectionId; // 标段id
    private String sectionName; // 标段名称
    //唯一的key需要使用方自己构建
    public String onlyKey;
    private Integer matchStatus; // 匹配状态：0-未匹配，1-已匹配，2-模糊匹配，
    private String matchStatusDescription;
    private String assistUnitName; // 辅单位
    private BigDecimal unitAssistUnit; // 单位/辅单位
    private BigDecimal numAssistUnit; // 数量/辅单位=【数量】*【单位/辅单位】
    private BigDecimal priceAssistUnit; // 单价/辅单位=【金额】/【数量/辅单位】
    /**
     * 物资编码
     */
    private String materialCode;

    public Long getSourceTypeId() {
        return sourceTypeId;
    }

    public void setSourceTypeId(Long sourceTypeId) {
        this.sourceTypeId = sourceTypeId;
    }

    public String getSourceTypeName() {
        return sourceTypeName;
    }

    public void setSourceTypeName(String sourceTypeName) {
        this.sourceTypeName = sourceTypeName;
    }

    public String getMaterialCode() {
        return materialCode;
    }

    public void setMaterialCode(String materialCode) {
        this.materialCode = materialCode;
    }

    public BigDecimal getPlanNum() {
        return planNum;
    }

    public void setPlanNum(BigDecimal planNum) {
        this.planNum = planNum;
    }

    public BigDecimal getPlanPrice() {
        return planPrice;
    }

    public void setPlanPrice(BigDecimal planPrice) {
        this.planPrice = planPrice;
    }

    public BigDecimal getMinPrice() {
        return minPrice;
    }

    public void setMinPrice(BigDecimal minPrice) {
        this.minPrice = minPrice;
    }

    public BigDecimal getMaxPrice() {
        return maxPrice;
    }

    public void setMaxPrice(BigDecimal maxPrice) {
        this.maxPrice = maxPrice;
    }

    public String getPriceArea() {
        return priceArea;
    }

    public void setPriceArea(String priceArea) {
        this.priceArea = priceArea;
    }

    public Long getChangeId() {
        return changeId;
    }

    public void setChangeId(Long changeId) {
        this.changeId = changeId;
    }

    public Long getChangBid() {
        return changBid;
    }

    public void setChangBid(Long changBid) {
        this.changBid = changBid;
    }

    public String getChangeType() {
        return changeType;
    }

    public void setChangeType(String changeType) {
        this.changeType = changeType;
    }

    public Long getMaterialContractId() {
        return materialContractId;
    }

    public void setMaterialContractId(Long materialContractId) {
        this.materialContractId = materialContractId;
    }

    public Long getMaterialTypeId() {
        return materialTypeId;
    }

    public void setMaterialTypeId(Long materialTypeId) {
        this.materialTypeId = materialTypeId;
    }

    public String getMaterialTypeName() {
        return materialTypeName;
    }

    public void setMaterialTypeName(String materialTypeName) {
        this.materialTypeName = materialTypeName;
    }

    public String getMaterialName() {
        return materialName;
    }

    public void setMaterialName(String materialName) {
        this.materialName = materialName;
    }

    public String getSpec() {
        return spec;
    }

    public void setSpec(String spec) {
        this.spec = spec;
    }

    public String getMeasureUnit() {
        return measureUnit;
    }

    public void setMeasureUnit(String measureUnit) {
        this.measureUnit = measureUnit;
    }

    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }

    public BigDecimal getCount() {
        return count;
    }

    public Long getSectionId() {
        return sectionId;
    }

    public void setSectionId(Long sectionId) {
        this.sectionId = sectionId;
    }

    public String getSectionName() {
        return sectionName;
    }

    public void setSectionName(String sectionName) {
        this.sectionName = sectionName;
    }

    public void setCount(BigDecimal count) {
        this.count = count;
    }

    public BigDecimal getUnitPrice() {
        return unitPrice;
    }

    public void setUnitPrice(BigDecimal unitPrice) {
        this.unitPrice = unitPrice;
    }

    public BigDecimal getTotalAmount() {
        return totalAmount;
    }

    public void setTotalAmount(BigDecimal totalAmount) {
        this.totalAmount = totalAmount;
    }

    public String getMaterialRemark() {
        return materialRemark;
    }

    public void setMaterialRemark(String materialRemark) {
        this.materialRemark = materialRemark;
    }

    public String getSourceType() {
        return sourceType;
    }

    public void setSourceType(String sourceType) {
        this.sourceType = sourceType;
    }

    public String getMaterialId() {
        return materialId;
    }

    public void setMaterialId(String materialId) {
        this.materialId = materialId;
    }

    public Long getSourceId() {
        return sourceId;
    }

    public void setSourceId(Long sourceId) {
        this.sourceId = sourceId;
    }

    public String getOnlyKey() {
        return onlyKey;
    }

    public void setOnlyKey(String onlyKey) {
        this.onlyKey = onlyKey;
    }

    public Integer getMatchStatus() {
        return matchStatus;
    }

    public void setMatchStatus(Integer matchStatus) {
        this.matchStatus = matchStatus;
    }

    public String getMatchStatusDescription() {
        return matchStatusDescription;
    }

    public void setMatchStatusDescription(String matchStatusDescription) {
        this.matchStatusDescription = matchStatusDescription;
    }

    public String getAssistUnitName() {
        return assistUnitName;
    }

    public void setAssistUnitName(String assistUnitName) {
        this.assistUnitName = assistUnitName;
    }

    public BigDecimal getUnitAssistUnit() {
        return unitAssistUnit;
    }

    public void setUnitAssistUnit(BigDecimal unitAssistUnit) {
        this.unitAssistUnit = unitAssistUnit;
    }

    public BigDecimal getNumAssistUnit() {
        return numAssistUnit;
    }

    public void setNumAssistUnit(BigDecimal numAssistUnit) {
        this.numAssistUnit = numAssistUnit;
    }

    public BigDecimal getPriceAssistUnit() {
        return priceAssistUnit;
    }

    public void setPriceAssistUnit(BigDecimal priceAssistUnit) {
        this.priceAssistUnit = priceAssistUnit;
    }
}
